/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.comment.helper;

import androidx.annotation.WorkerThread;
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.amity.socialcloud.sdk.social.comment.AmityComment;
import com.amity.socialcloud.sdk.social.comment.AmityCommentSortOption;
import com.ekoapp.ekosdk.UserEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import com.ekoapp.ekosdk.internal.entity.CommentEntity;
import com.ekoapp.ekosdk.internal.mapper.EkoCommentMapper;
import com.ekoapp.ekosdk.internal.repository.user.helper.UserRepositoryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\r"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/comment/helper/CommentRepositoryHelper;", "", "()V", "attachDataToEkoComment", "Lcom/ekoapp/ekosdk/internal/entity/CommentEntity;", "comment", "mapToExternalModel", "Lcom/amity/socialcloud/sdk/social/comment/AmityComment;", "input", "setCommentChildren", "", "setMyReactions", "setSenderUser", "amity-sdk_release"})
public final class CommentRepositoryHelper {
    @WorkerThread
    @NotNull
    public final CommentEntity attachDataToEkoComment(@NotNull CommentEntity comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        this.setSenderUser(comment);
        this.setCommentChildren(comment);
        this.setMyReactions(comment);
        return comment;
    }

    private final void setSenderUser(CommentEntity comment) {
        CommentEntity commentEntity = comment;
        boolean bl = false;
        boolean bl2 = false;
        CommentEntity $this$apply = commentEntity;
        boolean bl3 = false;
        UserEntity internalUser = UserDatabase.get().userDao().getByIdNow(comment.getUserId());
        if (internalUser != null) {
            new UserRepositoryHelper().attachDataAndMapToExternal(internalUser);
            $this$apply.setUser(internalUser);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setCommentChildren(CommentEntity input) {
        EkoCommentDao localComment = UserDatabase.get().commentDao();
        List<CommentEntity> comments = localComment.getLatestReplies(input.getCommentId(), input.getReferenceType(), input.getReferenceId(), AmityCommentSortOption.LAST_CREATED);
        if (comments != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = comments;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void commentEntity;
                CommentEntity commentEntity2 = (CommentEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v0 = commentEntity;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"commentEntity");
                CommentEntity commentEntity3 = this.attachDataToEkoComment((CommentEntity)v0);
                collection.add(commentEntity3);
            }
            List list = (List)destination$iv$iv;
            input.setLatestReplies(list);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setMyReactions(CommentEntity comment) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        EkoReactionDao reactionDao = UserDatabase.get().reactionDao();
        List<EkoReactionEntity> list = reactionDao.getAllMyReactionsByReferenceTypeAndReferenceIdNow(ReactionReferenceType.COMMENT.getValue(), comment.getCommentId());
        Intrinsics.checkNotNullExpressionValue(list, (String)"reactionDao.getAllMyReac\u2026value, comment.commentId)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EkoReactionEntity ekoReactionEntity = (EkoReactionEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            String string = v1.getReactionName();
            collection.add(string);
        }
        List list2 = (List)destination$iv$iv;
        comment.setMyReactions(list2);
    }

    @WorkerThread
    @NotNull
    public final AmityComment mapToExternalModel(@NotNull CommentEntity input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return new EkoCommentMapper().map(input);
    }
}

