/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository;

import androidx.annotation.WorkerThread;
import androidx.arch.core.util.Function;
import androidx.paging.DataSource;
import androidx.paging.PagedList;
import com.amity.socialcloud.sdk.core.reaction.AmityReaction;
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.AmityReactionBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import com.ekoapp.ekosdk.internal.mapper.AmityReactionMapper;
import io.reactivex.Flowable;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J,\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003\u00a8\u0006\u0012"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/ReactionRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "getDefaultPageSize", "", "getReactionCollection", "Lio/reactivex/Flowable;", "Landroidx/paging/PagedList;", "Lcom/amity/socialcloud/sdk/core/reaction/AmityReaction;", "referenceType", "Lcom/amity/socialcloud/sdk/core/reaction/ReactionReferenceType;", "referenceId", "", "reactionName", "mapToExternalModel", "input", "Lcom/ekoapp/ekosdk/internal/data/model/EkoReactionEntity;", "MapToExternalModelHelper", "amity-sdk_release"})
public final class ReactionRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<PagedList<AmityReaction>> getReactionCollection(@NotNull ReactionReferenceType referenceType, @NotNull String referenceId, @Nullable String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        EkoReactionDao reactionDao = UserDatabase.get().reactionDao();
        CharSequence charSequence = reactionName;
        boolean bl = false;
        boolean bl2 = false;
        DataSource.Factory<Integer, EkoReactionEntity> localFactory = charSequence == null || charSequence.length() == 0 ? reactionDao.getAllByReferenceId(referenceId, referenceType.getValue()) : reactionDao.getAllByReferenceIdAndReactionName(referenceId, referenceType.getValue(), reactionName);
        DataSource.Factory factory2 = localFactory.map((Function)new MapToExternalModelHelper(this));
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        AmityReactionBoundaryCallback boundaryCallback = new AmityReactionBoundaryCallback(referenceId, referenceType, this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        return this.createRxCollectionWithBoundaryCallback(factory2.map((Function)boundaryCallback), boundaryCallback);
    }

    @WorkerThread
    private final AmityReaction mapToExternalModel(EkoReactionEntity input) {
        return new AmityReactionMapper().map(input);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/ReactionRepository$MapToExternalModelHelper;", "Landroidx/arch/core/util/Function;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoReactionEntity;", "Lcom/amity/socialcloud/sdk/core/reaction/AmityReaction;", "repository", "Lcom/ekoapp/ekosdk/internal/repository/ReactionRepository;", "(Lcom/ekoapp/ekosdk/internal/repository/ReactionRepository;)V", "getRepository", "()Lcom/ekoapp/ekosdk/internal/repository/ReactionRepository;", "apply", "input", "amity-sdk_release"})
    public static final class MapToExternalModelHelper
    implements Function<EkoReactionEntity, AmityReaction> {
        @NotNull
        private final ReactionRepository repository;

        @NotNull
        public AmityReaction apply(@NotNull EkoReactionEntity input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return this.repository.mapToExternalModel(input);
        }

        @NotNull
        public final ReactionRepository getRepository() {
            return this.repository;
        }

        public MapToExternalModelHelper(@NotNull ReactionRepository repository) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            this.repository = repository;
        }
    }
}

