/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.push;

import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amity.socialcloud.sdk.push.EkoPushContract;
import com.ekoapp.ekosdk.internal.api.EkoApi;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceForPushNotificationRequest;
import com.ekoapp.ekosdk.internal.api.http.request.UnregisterDeviceForPushNotificationRequest;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoBaiduToken;
import com.ekoapp.ekosdk.internal.data.model.EkoFcmToken;
import com.ekoapp.ekosdk.internal.data.model.EkoPushConfig;
import com.github.davidmoten.guavamini.Objects;
import com.google.gson.Gson;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import org.reactivestreams.Publisher;
import timber.log.Timber;

public class EkoPushContractImpl
implements EkoPushContract {
    private static Flowable<EkoPushConfig> PUSH_CONFIG = EkoDatabase.get().accountDao().getAll().flatMapIterable(accounts -> accounts).distinct(EkoAccount::getUserId).flatMap(account -> EkoDatabase.get().pushConfigDao().getPushConfig(account.getUserId()).distinctUntilChanged(config -> config));
    private static Flowable<EkoApiKey> API_KEY = EkoDatabase.get().apiKeyDao().getCurrentApiKeyFlowable();

    public EkoPushContractImpl() {
        this.initPushService();
    }

    private void initPushService() {
        Flowable.combineLatest((Publisher)this.initFcm().startWith(new TokenConfigAndApiKey<Object>(null, null, null)), (Publisher)this.initBaidu().startWith(new TokenConfigAndApiKey<Object>(null, null, null)), (fcmConfig, baiduConfig) -> new Pair(fcmConfig, baiduConfig)).skip(1L).flatMapCompletable(configPair -> {
            TokenConfigAndApiKey fcmConfig = (TokenConfigAndApiKey)configPair.first;
            String fcmState = "null";
            if (fcmConfig.config != null) {
                fcmState = fcmConfig.config.getState().getApiKey();
            }
            String fcmToken = "null";
            if (fcmConfig.token != null) {
                fcmToken = ((EkoFcmToken)fcmConfig.token).getToken();
            }
            Timber.e((String)("fcm: " + fcmState + " token:" + fcmToken), (Object[])new Object[0]);
            TokenConfigAndApiKey baiduConfig = (TokenConfigAndApiKey)configPair.second;
            String baiduState = "null";
            if (baiduConfig.config != null) {
                baiduState = baiduConfig.config.getState().getApiKey();
            }
            String baiduToken = "null";
            if (baiduConfig.token != null) {
                baiduToken = ((EkoBaiduToken)baiduConfig.token).getToken();
            }
            Timber.e((String)("baidu: " + baiduState + " token:" + baiduToken), (Object[])new Object[0]);
            if (fcmConfig.token != null && baiduConfig.token != null) {
                return this.prioritizeFcmToken(fcmConfig, baiduConfig);
            }
            if (fcmConfig.token != null) {
                return this.handleFcmToken(fcmConfig);
            }
            return this.handleBaiduToken(baiduConfig);
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    private Flowable<TokenConfigAndApiKey<EkoFcmToken>> initFcm() {
        return Flowable.combineLatest((Publisher)EkoDatabase.get().fcmTokenDao().getFcmToken().distinctUntilChanged(fcmToken -> fcmToken), PUSH_CONFIG, API_KEY, (x$0, x$1, x$2) -> new TokenConfigAndApiKey<Object>(x$0, (EkoPushConfig)x$1, (EkoApiKey)x$2));
    }

    private Flowable<TokenConfigAndApiKey<EkoBaiduToken>> initBaidu() {
        return Flowable.combineLatest((Publisher)EkoDatabase.get().baiduTokenDao().getBaiduToken().distinctUntilChanged(baiduToken -> baiduToken), PUSH_CONFIG, API_KEY, (x$0, x$1, x$2) -> new TokenConfigAndApiKey<Object>(x$0, (EkoPushConfig)x$1, (EkoApiKey)x$2)).filter(tokenConfigAndApiKey -> ((EkoBaiduToken)tokenConfigAndApiKey.token).getUserId() != null && ((EkoBaiduToken)tokenConfigAndApiKey.token).getChannelId() != null);
    }

    private Completable prioritizeFcmToken(TokenConfigAndApiKey<EkoFcmToken> fcmConfig, TokenConfigAndApiKey<EkoBaiduToken> baiduConfig) {
        if (Objects.equal((Object)((Object)EkoPushConfig.State.REGISTERED), (Object)((Object)fcmConfig.config.getState()))) {
            RegisterDeviceForPushNotificationRequest registerRequest = RegisterDeviceForPushNotificationRequest.create(fcmConfig.config.getUserId(), fcmConfig.config.getDeviceId(), ((EkoFcmToken)fcmConfig.token).getToken(), Provider.FCM.getApiKey());
            UnregisterDeviceForPushNotificationRequest unregisterRequest = UnregisterDeviceForPushNotificationRequest.create(baiduConfig.config.getUserId(), baiduConfig.config.getDeviceId());
            return EkoApi.INSTANCE.notification().unregisterNotificationToken(baiduConfig.apiKey.getApiKey(), unregisterRequest).ignoreElement().andThen((CompletableSource)EkoApi.INSTANCE.notification().registerNotificationToken(fcmConfig.apiKey.getApiKey(), registerRequest).doOnSuccess(response -> Timber.tag((String)this.getClass().getName()).i(String.format("fcm response:%s", new Gson().toJson(response)), new Object[0])).ignoreElement());
        }
        UnregisterDeviceForPushNotificationRequest request = UnregisterDeviceForPushNotificationRequest.create(fcmConfig.config.getUserId(), fcmConfig.config.getDeviceId());
        Timber.tag((String)this.getClass().getName()).i(String.format("fcm un-registration request:%s", new Gson().toJson((Object)request)), new Object[0]);
        return EkoApi.INSTANCE.notification().unregisterNotificationToken(fcmConfig.apiKey.getApiKey(), request).doOnSuccess(response -> Timber.tag((String)this.getClass().getName()).i(String.format("fcm response:%s", new Gson().toJson(response)), new Object[0])).ignoreElement();
    }

    private Completable handleFcmToken(TokenConfigAndApiKey<EkoFcmToken> tokenConfigAndApiKey) {
        if (Objects.equal((Object)((Object)EkoPushConfig.State.REGISTERED), (Object)((Object)tokenConfigAndApiKey.config.getState()))) {
            RegisterDeviceForPushNotificationRequest request = RegisterDeviceForPushNotificationRequest.create(tokenConfigAndApiKey.config.getUserId(), tokenConfigAndApiKey.config.getDeviceId(), ((EkoFcmToken)tokenConfigAndApiKey.token).getToken(), Provider.FCM.getApiKey());
            Timber.tag((String)this.getClass().getName()).i(String.format("fcm registration request:%s", new Gson().toJson((Object)request)), new Object[0]);
            return EkoApi.INSTANCE.notification().registerNotificationToken(tokenConfigAndApiKey.apiKey.getApiKey(), request).doOnSuccess(response -> Timber.tag((String)this.getClass().getName()).i(String.format("fcm response:%s", new Gson().toJson(response)), new Object[0])).ignoreElement();
        }
        UnregisterDeviceForPushNotificationRequest request = UnregisterDeviceForPushNotificationRequest.create(tokenConfigAndApiKey.config.getUserId(), tokenConfigAndApiKey.config.getDeviceId());
        Timber.tag((String)this.getClass().getName()).i(String.format("fcm un-registration request:%s", new Gson().toJson((Object)request)), new Object[0]);
        return EkoApi.INSTANCE.notification().unregisterNotificationToken(tokenConfigAndApiKey.apiKey.getApiKey(), request).doOnSuccess(response -> Timber.tag((String)this.getClass().getName()).i(String.format("fcm response:%s", new Gson().toJson(response)), new Object[0])).ignoreElement();
    }

    private Completable handleBaiduToken(TokenConfigAndApiKey<EkoBaiduToken> tokenConfigAndApiKey) {
        if (Objects.equal((Object)((Object)EkoPushConfig.State.REGISTERED), (Object)((Object)tokenConfigAndApiKey.config.getState()))) {
            RegisterDeviceForPushNotificationRequest request = RegisterDeviceForPushNotificationRequest.create(tokenConfigAndApiKey.config.getUserId(), tokenConfigAndApiKey.config.getDeviceId(), new Gson().toJson((Object)new RegisterDeviceForPushNotificationRequest.BaiduToken(((EkoBaiduToken)tokenConfigAndApiKey.token).getToken(), ((EkoBaiduToken)tokenConfigAndApiKey.token).getUserId(), ((EkoBaiduToken)tokenConfigAndApiKey.token).getChannelId())), Provider.BAIDU.apiKey);
            Timber.tag((String)this.getClass().getName()).i(String.format("baidu registration request:%s", new Gson().toJson((Object)request)), new Object[0]);
            return EkoApi.INSTANCE.notification().registerNotificationToken(tokenConfigAndApiKey.apiKey.getApiKey(), request).doOnSuccess(response -> Timber.tag((String)this.getClass().getName()).i(String.format("baidu response:%s", new Gson().toJson(response)), new Object[0])).ignoreElement();
        }
        UnregisterDeviceForPushNotificationRequest request = UnregisterDeviceForPushNotificationRequest.create(tokenConfigAndApiKey.config.getUserId(), tokenConfigAndApiKey.config.getDeviceId());
        Timber.tag((String)this.getClass().getName()).i(String.format("baidu un-registration request:%s", new Gson().toJson((Object)request)), new Object[0]);
        return EkoApi.INSTANCE.notification().unregisterNotificationToken(tokenConfigAndApiKey.apiKey.getApiKey(), request).doOnSuccess(response -> Timber.tag((String)this.getClass().getName()).i(String.format("baidu response:%s", new Gson().toJson(response)), new Object[0])).ignoreElement();
    }

    public Completable insertBaiduApiKey(@NonNull String apiKey) {
        return Completable.fromAction(() -> EkoDatabase.get().baiduTokenDao().insertOrUpdate(new EkoBaiduToken(apiKey)));
    }

    public Completable updateBaiduToken(@Nullable String token, @Nullable String userId, @Nullable String channelId) {
        return Completable.fromAction(() -> EkoDatabase.get().baiduTokenDao().updateToken(token, userId, channelId));
    }

    public Completable insertFcmToken(@NonNull String fcmToken) {
        return Completable.fromAction(() -> EkoDatabase.get().fcmTokenDao().insert(new EkoFcmToken(fcmToken)));
    }

    public Flowable<Boolean> hasRegisteredConfig() {
        return EkoDatabase.get().pushConfigDao().hasRegisteredConfig();
    }

    class TokenConfigAndApiKey<TOKEN> {
        TOKEN token;
        EkoPushConfig config;
        EkoApiKey apiKey;

        TokenConfigAndApiKey(TOKEN token, EkoPushConfig config, EkoApiKey apiKey) {
            this.token = token;
            this.config = config;
            this.apiKey = apiKey;
        }
    }

    static enum Provider {
        FCM("fcm"),
        BAIDU("baidu");

        private final String apiKey;

        private Provider(String apiKey) {
            this.apiKey = apiKey;
        }

        public String getApiKey() {
            return this.apiKey;
        }
    }
}

