/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.channel;

import androidx.paging.ExperimentalPagingApi;
import androidx.paging.PagingData;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMember;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembership;
import com.amity.socialcloud.sdk.core.permission.AmityRoles;
import com.amity.socialcloud.sdk.core.permission.ChannelMembership;
import com.ekoapp.ekosdk.internal.usecase.channel.SearchChannelMembershipPagingSourceUseCase;
import io.reactivex.Flowable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMemberSearch;", "", "channelId", "", "roles", "Lcom/amity/socialcloud/sdk/core/permission/AmityRoles;", "filters", "Lcom/amity/socialcloud/sdk/core/permission/ChannelMembership;", "keyword", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/core/permission/AmityRoles;Lcom/amity/socialcloud/sdk/core/permission/ChannelMembership;Ljava/lang/String;)V", "getPagingData", "Lio/reactivex/Flowable;", "Landroidx/paging/PagingData;", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMember;", "Builder", "amity-sdk_release"})
public final class AmityChannelMemberSearch {
    private final String channelId;
    private final AmityRoles roles;
    private final ChannelMembership filters;
    private final String keyword;

    @ExperimentalPagingApi
    @NotNull
    public final Flowable<PagingData<AmityChannelMember>> getPagingData() {
        return new SearchChannelMembershipPagingSourceUseCase().execute(this.channelId, this.roles, this.filters, this.keyword);
    }

    public AmityChannelMemberSearch(@NotNull String channelId, @NotNull AmityRoles roles, @NotNull ChannelMembership filters, @Nullable String keyword) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        this.channelId = channelId;
        this.roles = roles;
        this.filters = filters;
        this.keyword = keyword;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0014\u0010\t\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMemberSearch$Builder;", "", "channelId", "", "keyword", "(Ljava/lang/String;Ljava/lang/String;)V", "()V", "channelMembership", "Lcom/amity/socialcloud/sdk/core/permission/ChannelMembership;", "roles", "Lcom/amity/socialcloud/sdk/core/permission/AmityRoles;", "build", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMemberSearch;", "membershipFilter", "", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMembership;", "amity-sdk_release"})
    public static final class Builder {
        private String channelId;
        private AmityRoles roles;
        private ChannelMembership channelMembership;
        private String keyword;

        @NotNull
        public final Builder membershipFilter(@NotNull List<? extends AmityChannelMembership> channelMembership) {
            Intrinsics.checkNotNullParameter(channelMembership, (String)"channelMembership");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.channelMembership = new ChannelMembership(channelMembership);
            return builder;
        }

        @NotNull
        public final Builder roles(@NotNull List<String> roles) {
            Intrinsics.checkNotNullParameter(roles, (String)"roles");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.roles = new AmityRoles(roles);
            return builder;
        }

        @NotNull
        public final AmityChannelMemberSearch build() {
            String string = this.channelId;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"channelId");
            }
            return new AmityChannelMemberSearch(string, this.roles, this.channelMembership, this.keyword);
        }

        private Builder() {
            this.roles = new AmityRoles();
            this.channelMembership = new ChannelMembership(CollectionsKt.listOf((Object)((Object)AmityChannelMembership.MEMBER)));
        }

        public Builder(@NotNull String channelId, @NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            this();
            this.channelId = channelId;
            this.keyword = keyword;
        }
    }
}

