/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.social.feed.AmityFeedType;
import com.ekoapp.ekosdk.internal.api.dto.EkoFeedDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoCommentListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoCommunityCategoryListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoCommunityListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoCommunityMembershipListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoFeedListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoFileListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectMapper;
import com.ekoapp.ekosdk.internal.api.mapper.EkoPollPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoPostListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoStreamListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoUserListPersister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public interface EkoPostAndUserMapper
extends EkoObjectMapper<EkoPostQueryDto, Void> {
    public static final EkoPostAndUserMapper MAPPER = dto -> {
        EkoFileListPersister.persist(dto.getFiles());
        EkoUserListPersister.persist(dto.getUsers());
        EkoCommunityCategoryListPersister.persist(dto.getCategories());
        EkoCommunityMembershipListPersister.persist(dto.getCommunityUsers());
        EkoCommunityListPersister.persist(dto.getCommunities());
        EkoCommentListPersister.persist(dto.getComments());
        List<EkoPostDto> postChildrenDto = EkoPostAndUserMapper.mapPostDtoList(dto.getChildren(), dto.getFeeds());
        EkoPostListPersister.persist(postChildrenDto);
        List<EkoPostDto> postsDto = EkoPostAndUserMapper.mapPostDtoList(dto.getPosts(), dto.getFeeds());
        EkoPostListPersister.persist(postsDto);
        EkoFeedListPersister.persist(dto.getFeeds());
        EkoStreamListPersister.persist(dto.getStreams());
        EkoPollPersister.Companion.persist(dto.getPolls());
        return null;
    };

    public static List<EkoPostDto> mapPostDtoList(List<EkoPostDto> postDtoList, List<EkoFeedDto> feedDtoList) {
        ArrayList<EkoPostDto> newItems = new ArrayList<EkoPostDto>(postDtoList);
        HashMap<String, EkoFeedDto> feedDtoMap = new HashMap<String, EkoFeedDto>();
        for (EkoFeedDto feedDto : feedDtoList) {
            feedDtoMap.put(Objects.requireNonNull(feedDto.getFeedId()), feedDto);
        }
        for (EkoPostDto postDto : newItems) {
            String feedId = postDto.getFeedId();
            if (feedId != null && feedDtoMap.get(feedId) != null) {
                postDto.setFeedType(((EkoFeedDto)feedDtoMap.get(feedId)).getFeedType());
                continue;
            }
            postDto.setFeedType(AmityFeedType.PUBLISHED.getApiKey());
        }
        return newItems;
    }
}

