/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.event;

import androidx.annotation.NonNull;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.internal.api.dto.ChannelEvent;
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelMembershipDto;
import com.ekoapp.ekosdk.internal.api.event.SocketEventListener;
import com.ekoapp.ekosdk.internal.repository.channel.ChannelRepository;
import com.google.gson.Gson;
import io.reactivex.schedulers.Schedulers;

public class ChannelDidBanListener
extends SocketEventListener {
    private final Gson gson = EkoGson.get();

    @Override
    @NonNull
    public String getEvent() {
        return "v3.channel.didBan";
    }

    @Override
    protected void onEvent(@NonNull String event, Object ... args) {
        super.onEvent(event, args);
        String json = args[0].toString();
        ChannelEvent eventData = (ChannelEvent)this.gson.fromJson(json, ChannelEvent.class);
        if (eventData.getChannelDtoList() != null && !eventData.getChannelDtoList().isEmpty() && eventData.getChannelMembershipDtoList() != null && !eventData.getChannelMembershipDtoList().isEmpty()) {
            EkoChannelDto channel = eventData.getChannelDtoList().get(0);
            EkoChannelMembershipDto membership = eventData.getChannelMembershipDtoList().get(0);
            new ChannelRepository().handleMembershipBanned(channel.getChannelId(), membership.getUserId()).subscribeOn(Schedulers.io()).subscribe();
        }
    }
}

