/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.paging.PagingSource;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import co.amity.rxremotemediator.AmityPagingDao;
import com.amity.socialcloud.sdk.core.permission.AmityPermissions;
import com.amity.socialcloud.sdk.core.permission.AmityRoles;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.community.membership.query.AmityCommunityMembership;
import com.ekoapp.ekosdk.internal.data.converter.EkoPermissionsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoRolesTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityMembershipPagingDao;
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity;
import com.google.gson.JsonObject;
import io.reactivex.Completable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoCommunityMembershipPagingDao_Impl
implements EkoCommunityMembershipPagingDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CommunityMembershipEntity> __insertionAdapterOfCommunityMembershipEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final EkoRolesTypeConverter __ekoRolesTypeConverter = new EkoRolesTypeConverter();
    private final EkoPermissionsTypeConverter __ekoPermissionsTypeConverter = new EkoPermissionsTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();

    public EkoCommunityMembershipPagingDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCommunityMembershipEntity = new EntityInsertionAdapter<CommunityMembershipEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `community_membership` (`id`,`userId`,`communityId`,`channelId`,`metadata`,`communityMembership`,`isBanned`,`roles`,`permissions`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityMembershipEntity value) {
                Integer _tmp_1;
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
                if (value.getCommunityId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getCommunityId());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getChannelId());
                }
                String _tmp = EkoCommunityMembershipPagingDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                if (value.getCommunityMembership() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getCommunityMembership());
                }
                Integer n = value.isBanned() == null ? null : (_tmp_1 = Integer.valueOf(value.isBanned() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindLong(7, (long)_tmp_1.intValue());
                }
                String _tmp_2 = EkoCommunityMembershipPagingDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(value.getRoles());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_2);
                }
                String _tmp_3 = EkoCommunityMembershipPagingDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(value.getPermissions());
                if (_tmp_3 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_3);
                }
                String _tmp_4 = EkoCommunityMembershipPagingDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
                String _tmp_5 = EkoCommunityMembershipPagingDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_5);
                }
            }
        };
    }

    @Override
    public Completable insertCommunityMembership(final List<CommunityMembershipEntity> entities) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                EkoCommunityMembershipPagingDao_Impl.this.__db.beginTransaction();
                try {
                    EkoCommunityMembershipPagingDao_Impl.this.__insertionAdapterOfCommunityMembershipEntity.insert((Iterable)entities);
                    EkoCommunityMembershipPagingDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    EkoCommunityMembershipPagingDao_Impl.this.__db.endTransaction();
                }
            }
        });
    }

    @Override
    public PagingSource<Integer, CommunityMembershipEntity> queryPagingData(SimpleSQLiteQuery sqlQuery) {
        SimpleSQLiteQuery _internalQuery = sqlQuery;
        return (PagingSource)new DataSource.Factory<Integer, CommunityMembershipEntity>((SupportSQLiteQuery)_internalQuery){
            final /* synthetic */ SupportSQLiteQuery val$_internalQuery;
            {
                this.val$_internalQuery = supportSQLiteQuery;
            }

            public LimitOffsetDataSource<CommunityMembershipEntity> create() {
                return new LimitOffsetDataSource<CommunityMembershipEntity>(EkoCommunityMembershipPagingDao_Impl.this.__db, this.val$_internalQuery, false, false, new String[]{"community_membership", "amity_paging_id"}){

                    protected List<CommunityMembershipEntity> convertRows(Cursor cursor) {
                        ArrayList<CommunityMembershipEntity> _res = new ArrayList<CommunityMembershipEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommunityMembershipEntity _item = EkoCommunityMembershipPagingDao_Impl.this.__entityCursorConverter_comEkoappEkosdkInternalEntityCommunityMembershipEntity(cursor);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        }.asPagingSourceFactory().invoke();
    }

    @Override
    public PagingSource<Integer, CommunityMembershipEntity> searchCommunityMembership(String communityId, AmityRoles roles, List<? extends AmityCommunityMembership> filters, String keyword) {
        return EkoCommunityMembershipPagingDao.DefaultImpls.searchCommunityMembership(this, communityId, roles, filters, keyword);
    }

    public SimpleSQLiteQuery generateSqlQuery(String tableName, String primaryKeyColumnName, Map<String, ?> additionalPrimaryKeys, Map<String, ?> queryParameters, int nonce, AmityPagingDao.Order order) {
        return EkoCommunityMembershipPagingDao.DefaultImpls.generateSqlQuery(this, tableName, primaryKeyColumnName, additionalPrimaryKeys, queryParameters, nonce, order);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private CommunityMembershipEntity __entityCursorConverter_comEkoappEkosdkInternalEntityCommunityMembershipEntity(Cursor cursor) {
        int _cursorIndexOfId = cursor.getColumnIndex("id");
        int _cursorIndexOfUserId = cursor.getColumnIndex("userId");
        int _cursorIndexOfCommunityId = cursor.getColumnIndex("communityId");
        int _cursorIndexOfChannelId = cursor.getColumnIndex("channelId");
        int _cursorIndexOfMetadata = cursor.getColumnIndex("metadata");
        int _cursorIndexOfCommunityMembership = cursor.getColumnIndex("communityMembership");
        int _cursorIndexOfIsBanned = cursor.getColumnIndex("isBanned");
        int _cursorIndexOfRoles = cursor.getColumnIndex("roles");
        int _cursorIndexOfPermissions = cursor.getColumnIndex("permissions");
        int _cursorIndexOfCreatedAt = cursor.getColumnIndex("createdAt");
        int _cursorIndexOfUpdatedAt = cursor.getColumnIndex("updatedAt");
        CommunityMembershipEntity _entity = new CommunityMembershipEntity();
        if (_cursorIndexOfId != -1) {
            String _tmpId = cursor.isNull(_cursorIndexOfId) ? null : cursor.getString(_cursorIndexOfId);
            _entity.setId(_tmpId);
        }
        if (_cursorIndexOfUserId != -1) {
            String _tmpUserId = cursor.isNull(_cursorIndexOfUserId) ? null : cursor.getString(_cursorIndexOfUserId);
            _entity.setUserId(_tmpUserId);
        }
        if (_cursorIndexOfCommunityId != -1) {
            String _tmpCommunityId = cursor.isNull(_cursorIndexOfCommunityId) ? null : cursor.getString(_cursorIndexOfCommunityId);
            _entity.setCommunityId(_tmpCommunityId);
        }
        if (_cursorIndexOfChannelId != -1) {
            String _tmpChannelId = cursor.isNull(_cursorIndexOfChannelId) ? null : cursor.getString(_cursorIndexOfChannelId);
            _entity.setChannelId(_tmpChannelId);
        }
        if (_cursorIndexOfMetadata != -1) {
            String _tmp = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
            JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
            _entity.setMetadata(_tmpMetadata);
        }
        if (_cursorIndexOfCommunityMembership != -1) {
            String _tmpCommunityMembership = cursor.isNull(_cursorIndexOfCommunityMembership) ? null : cursor.getString(_cursorIndexOfCommunityMembership);
            _entity.setCommunityMembership(_tmpCommunityMembership);
        }
        if (_cursorIndexOfIsBanned != -1) {
            Integer _tmp_1 = cursor.isNull(_cursorIndexOfIsBanned) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsBanned));
            Boolean _tmpIsBanned = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
            _entity.setBanned(_tmpIsBanned);
        }
        if (_cursorIndexOfRoles != -1) {
            String _tmp_2 = cursor.isNull(_cursorIndexOfRoles) ? null : cursor.getString(_cursorIndexOfRoles);
            AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
            _entity.setRoles(_tmpRoles);
        }
        if (_cursorIndexOfPermissions != -1) {
            String _tmp_3 = cursor.isNull(_cursorIndexOfPermissions) ? null : cursor.getString(_cursorIndexOfPermissions);
            AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
            _entity.setPermissions(_tmpPermissions);
        }
        if (_cursorIndexOfCreatedAt != -1) {
            String _tmp_4 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
            DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
            _entity.setCreatedAt(_tmpCreatedAt);
        }
        if (_cursorIndexOfUpdatedAt != -1) {
            String _tmp_5 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
            DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
            _entity.setUpdatedAt(_tmpUpdatedAt);
        }
        return _entity;
    }
}

