/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.community;

import androidx.paging.DataSource;
import androidx.paging.ExperimentalPagingApi;
import androidx.paging.PagedList;
import androidx.paging.Pager;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import androidx.paging.RemoteMediator;
import androidx.paging.rxjava2.PagingRx;
import co.amity.rxremotemediator.AmityQueryTokenDao;
import com.amity.socialcloud.sdk.core.permission.AmityRoles;
import com.amity.socialcloud.sdk.social.community.AmityCommunityMember;
import com.amity.socialcloud.sdk.social.community.AmityCommunityMembership;
import com.amity.socialcloud.sdk.social.community.AmityCommunityMembershipFilter;
import com.amity.socialcloud.sdk.social.community.AmityCommunityMembershipSortOption;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.CommunityListQueryConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityAddRolesRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityAddUsersRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityBanUsersRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityRemoveRolesRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityRemoveUsersRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityUnBanUsersRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoCommunityMembershipBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityMembershipDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityMembershipPagingDao;
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity;
import com.ekoapp.ekosdk.internal.repository.community.CommunityMembershipRepository;
import com.ekoapp.ekosdk.internal.repository.community.SearchMembershipRxRemoteMediator;
import com.ekoapp.ekosdk.internal.repository.community.helper.CommunityMembershipRepositoryHelper;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u001c\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u001c\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\bJJ\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J*\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u001c\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ:\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u001c0\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001d2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\b2\u0006\u0010\u001e\u001a\u00020\u0006H\u0007J\u001c\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a8\u0006 "}, d2={"Lcom/ekoapp/ekosdk/internal/repository/community/CommunityMembershipRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "addRoles", "Lio/reactivex/Completable;", "communityId", "", "roles", "", "userIds", "addUsers", "banUsers", "users", "getCommunityMembershipCollection", "Lio/reactivex/Flowable;", "Landroidx/paging/PagedList;", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityMember;", "filter", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityMembershipFilter;", "communityMembership", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityMembership;", "sortBy", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityMembershipSortOption;", "getDefaultPageSize", "", "removeRoles", "removeUsers", "searchCommunityMembershipPagingData", "Landroidx/paging/PagingData;", "Lcom/amity/socialcloud/sdk/core/permission/AmityRoles;", "keyword", "unbanUsers", "amity-sdk_release"})
public final class CommunityMembershipRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @ExperimentalPagingApi
    @NotNull
    public final Flowable<PagingData<AmityCommunityMember>> searchCommunityMembershipPagingData(@NotNull String communityId, @NotNull AmityRoles roles, @NotNull List<? extends AmityCommunityMembership> communityMembership, @NotNull String keyword) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter(communityMembership, (String)"communityMembership");
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        PagingConfig pagingConfig = new PagingConfig(15, 0, false, 0, 0, 0, 58, null);
        AmityQueryTokenDao amityQueryTokenDao = UserDatabase.get().queryTokenDao();
        Intrinsics.checkNotNullExpressionValue((Object)amityQueryTokenDao, (String)"UserDatabase.get().queryTokenDao()");
        Pager pager2 = new Pager(pagingConfig, null, (RemoteMediator)new SearchMembershipRxRemoteMediator(communityId, roles, communityMembership, keyword, amityQueryTokenDao), (Function0)new Function0<PagingSource<Integer, CommunityMembershipEntity>>(communityId, roles, communityMembership, keyword){
            final /* synthetic */ String $communityId;
            final /* synthetic */ AmityRoles $roles;
            final /* synthetic */ List $communityMembership;
            final /* synthetic */ String $keyword;

            @NotNull
            public final PagingSource<Integer, CommunityMembershipEntity> invoke() {
                EkoCommunityMembershipPagingDao communityMembershipDao = UserDatabase.get().communityMembersPagingDao();
                return communityMembershipDao.searchCommunityMembership(this.$communityId, this.$roles, this.$communityMembership, this.$keyword);
            }
            {
                this.$communityId = string;
                this.$roles = amityRoles;
                this.$communityMembership = list;
                this.$keyword = string2;
                super(0);
            }
        });
        Flowable flowable = PagingRx.getFlowable((Pager)pager2).map((Function)searchCommunityMembershipPagingData.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"pager.flowable\n         \u2026          }\n            }");
        return flowable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flowable<PagedList<AmityCommunityMember>> getCommunityMembershipCollection(@NotNull String communityId, @Nullable List<String> roles, @NotNull AmityCommunityMembershipFilter filter, @Nullable List<? extends AmityCommunityMembership> communityMembership, @NotNull AmityCommunityMembershipSortOption sortBy) {
        List list;
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        List<? extends AmityCommunityMembership> list2 = communityMembership;
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AmityCommunityMembership amityCommunityMembership = (AmityCommunityMembership)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getValue();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        } else {
            list = filter.getMemberships();
        }
        List membership = list;
        EkoCommunityMembershipDao communityMembershipDao = UserDatabase.get().communityMembershipDao();
        DataSource.Factory<Integer, CommunityMembershipEntity> factory2 = communityMembershipDao.getMembers(communityId, roles, membership, sortBy);
        EkoCommunityMembershipBoundaryCallback boundaryCallback = new EkoCommunityMembershipBoundaryCallback(communityId, membership, roles, sortBy.getApiKey(), this.getDefaultPageSize());
        return this.createRxCollectionWithBoundaryCallback(factory2.map(CommunityMembershipRepositoryHelper.INSTANCE.getFactoryMapper()), boundaryCallback);
    }

    @NotNull
    public final Completable addUsers(@NotNull String communityId, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        CommunityAddUsersRequest request = new CommunityAddUsersRequest(communityId, userIds);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026erter())).ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable removeUsers(@NotNull String communityId, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        CommunityRemoveUsersRequest request = new CommunityRemoveUsersRequest(communityId, userIds);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026erter())).ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable addRoles(@NotNull String communityId, @NotNull List<String> roles, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        CommunityAddRolesRequest request = new CommunityAddRolesRequest(communityId, roles, userIds);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable removeRoles(@NotNull String communityId, @NotNull List<String> roles, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        CommunityRemoveRolesRequest request = new CommunityRemoveRolesRequest(communityId, roles, userIds);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable banUsers(@NotNull String communityId, @NotNull List<String> users) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter(users, (String)"users");
        CommunityBanUsersRequest request = new CommunityBanUsersRequest(communityId, users);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable unbanUsers(@NotNull String communityId, @NotNull List<String> users) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter(users, (String)"users");
        CommunityUnBanUsersRequest request = new CommunityUnBanUsersRequest(communityId, users);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }
}

