/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.paging.PagingSource;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import co.amity.rxremotemediator.AmityPagingDao;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembership;
import com.amity.socialcloud.sdk.core.permission.AmityPermissions;
import com.amity.socialcloud.sdk.core.permission.AmityRoles;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoPermissionsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoRolesTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipPagingDao;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import io.reactivex.Completable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoChannelMembershipPagingDao_Impl
implements EkoChannelMembershipPagingDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChannelMembershipEntity> __insertionAdapterOfChannelMembershipEntity;
    private final EkoRolesTypeConverter __ekoRolesTypeConverter = new EkoRolesTypeConverter();
    private final EkoPermissionsTypeConverter __ekoPermissionsTypeConverter = new EkoPermissionsTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();

    public EkoChannelMembershipPagingDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfChannelMembershipEntity = new EntityInsertionAdapter<ChannelMembershipEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `channel_membership` (`channelId`,`userId`,`readToSegment`,`lastMentionedSegment`,`membership`,`isMuted`,`isBanned`,`roles`,`permissions`,`displayName`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelMembershipEntity value) {
                Integer _tmp_1;
                Integer _tmp;
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
                stmt.bindLong(3, (long)value.getReadToSegment());
                stmt.bindLong(4, (long)value.getLastMentionedSegment());
                if (value.getMembership() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getMembership());
                }
                Integer n = value.isMuted() == null ? null : (_tmp = Integer.valueOf(value.isMuted() != false ? 1 : 0));
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, (long)_tmp.intValue());
                }
                Integer n2 = value.isBanned() == null ? null : (_tmp_1 = Integer.valueOf(value.isBanned() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindLong(7, (long)_tmp_1.intValue());
                }
                String _tmp_2 = EkoChannelMembershipPagingDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(value.getRoles());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_2);
                }
                String _tmp_3 = EkoChannelMembershipPagingDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(value.getPermissions());
                if (_tmp_3 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_3);
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getDisplayName());
                }
                String _tmp_4 = EkoChannelMembershipPagingDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_4);
                }
                String _tmp_5 = EkoChannelMembershipPagingDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_5);
                }
            }
        };
    }

    @Override
    public Completable insertChannelMembership(final List<ChannelMembershipEntity> entities) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                EkoChannelMembershipPagingDao_Impl.this.__db.beginTransaction();
                try {
                    EkoChannelMembershipPagingDao_Impl.this.__insertionAdapterOfChannelMembershipEntity.insert((Iterable)entities);
                    EkoChannelMembershipPagingDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    EkoChannelMembershipPagingDao_Impl.this.__db.endTransaction();
                }
            }
        });
    }

    @Override
    public PagingSource<Integer, ChannelMembershipEntity> queryPagingData(SimpleSQLiteQuery sqlQuery) {
        SimpleSQLiteQuery _internalQuery = sqlQuery;
        return (PagingSource)new DataSource.Factory<Integer, ChannelMembershipEntity>((SupportSQLiteQuery)_internalQuery){
            final /* synthetic */ SupportSQLiteQuery val$_internalQuery;
            {
                this.val$_internalQuery = supportSQLiteQuery;
            }

            public LimitOffsetDataSource<ChannelMembershipEntity> create() {
                return new LimitOffsetDataSource<ChannelMembershipEntity>(EkoChannelMembershipPagingDao_Impl.this.__db, this.val$_internalQuery, false, false, new String[]{"channel_membership", "amity_paging_id"}){

                    protected List<ChannelMembershipEntity> convertRows(Cursor cursor) {
                        ArrayList<ChannelMembershipEntity> _res = new ArrayList<ChannelMembershipEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            ChannelMembershipEntity _item = EkoChannelMembershipPagingDao_Impl.this.__entityCursorConverter_comEkoappEkosdkInternalEntityChannelMembershipEntity(cursor);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        }.asPagingSourceFactory().invoke();
    }

    @Override
    public PagingSource<Integer, ChannelMembershipEntity> searchChannelMembership(String channelId, AmityRoles roles, List<? extends AmityChannelMembership> filters, String keyword) {
        return EkoChannelMembershipPagingDao.DefaultImpls.searchChannelMembership(this, channelId, roles, filters, keyword);
    }

    public SimpleSQLiteQuery generateSqlQuery(String tableName, String primaryKeyColumnName, Map<String, ?> additionalPrimaryKeys, Map<String, ?> queryParameters, int nonce, AmityPagingDao.Order order) {
        return EkoChannelMembershipPagingDao.DefaultImpls.generateSqlQuery(this, tableName, primaryKeyColumnName, additionalPrimaryKeys, queryParameters, nonce, order);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private ChannelMembershipEntity __entityCursorConverter_comEkoappEkosdkInternalEntityChannelMembershipEntity(Cursor cursor) {
        int _cursorIndexOfChannelId = cursor.getColumnIndex("channelId");
        int _cursorIndexOfUserId = cursor.getColumnIndex("userId");
        int _cursorIndexOfReadToSegment = cursor.getColumnIndex("readToSegment");
        int _cursorIndexOfLastMentionedSegment = cursor.getColumnIndex("lastMentionedSegment");
        int _cursorIndexOfMembership = cursor.getColumnIndex("membership");
        int _cursorIndexOfIsMuted = cursor.getColumnIndex("isMuted");
        int _cursorIndexOfIsBanned = cursor.getColumnIndex("isBanned");
        int _cursorIndexOfRoles = cursor.getColumnIndex("roles");
        int _cursorIndexOfPermissions = cursor.getColumnIndex("permissions");
        int _cursorIndexOfDisplayName = cursor.getColumnIndex("displayName");
        int _cursorIndexOfCreatedAt = cursor.getColumnIndex("createdAt");
        int _cursorIndexOfUpdatedAt = cursor.getColumnIndex("updatedAt");
        ChannelMembershipEntity _entity = new ChannelMembershipEntity();
        if (_cursorIndexOfChannelId != -1) {
            String _tmpChannelId = cursor.isNull(_cursorIndexOfChannelId) ? null : cursor.getString(_cursorIndexOfChannelId);
            _entity.setChannelId(_tmpChannelId);
        }
        if (_cursorIndexOfUserId != -1) {
            String _tmpUserId = cursor.isNull(_cursorIndexOfUserId) ? null : cursor.getString(_cursorIndexOfUserId);
            _entity.setUserId(_tmpUserId);
        }
        if (_cursorIndexOfReadToSegment != -1) {
            int _tmpReadToSegment = cursor.getInt(_cursorIndexOfReadToSegment);
            _entity.setReadToSegment(_tmpReadToSegment);
        }
        if (_cursorIndexOfLastMentionedSegment != -1) {
            int _tmpLastMentionedSegment = cursor.getInt(_cursorIndexOfLastMentionedSegment);
            _entity.setLastMentionedSegment(_tmpLastMentionedSegment);
        }
        if (_cursorIndexOfMembership != -1) {
            String _tmpMembership = cursor.isNull(_cursorIndexOfMembership) ? null : cursor.getString(_cursorIndexOfMembership);
            _entity.setMembership(_tmpMembership);
        }
        if (_cursorIndexOfIsMuted != -1) {
            Integer _tmp = cursor.isNull(_cursorIndexOfIsMuted) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsMuted));
            Boolean _tmpIsMuted = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
            _entity.setMuted(_tmpIsMuted);
        }
        if (_cursorIndexOfIsBanned != -1) {
            Integer _tmp_1 = cursor.isNull(_cursorIndexOfIsBanned) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsBanned));
            Boolean _tmpIsBanned = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
            _entity.setBanned(_tmpIsBanned);
        }
        if (_cursorIndexOfRoles != -1) {
            String _tmp_2 = cursor.isNull(_cursorIndexOfRoles) ? null : cursor.getString(_cursorIndexOfRoles);
            AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
            _entity.setRoles(_tmpRoles);
        }
        if (_cursorIndexOfPermissions != -1) {
            String _tmp_3 = cursor.isNull(_cursorIndexOfPermissions) ? null : cursor.getString(_cursorIndexOfPermissions);
            AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
            _entity.setPermissions(_tmpPermissions);
        }
        if (_cursorIndexOfDisplayName != -1) {
            String _tmpDisplayName = cursor.isNull(_cursorIndexOfDisplayName) ? null : cursor.getString(_cursorIndexOfDisplayName);
            _entity.setDisplayName(_tmpDisplayName);
        }
        if (_cursorIndexOfCreatedAt != -1) {
            String _tmp_4 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
            DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
            _entity.setCreatedAt(_tmpCreatedAt);
        }
        if (_cursorIndexOfUpdatedAt != -1) {
            String _tmp_5 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
            DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
            _entity.setUpdatedAt(_tmpUpdatedAt);
        }
        return _entity;
    }
}

