/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.ekoapp.ekosdk.EkoChannelExtra;
import com.ekoapp.ekosdk.EkoChannelReadStatus;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.util.List;

@Dao
public abstract class EkoChannelExtraDao
extends EkoObjectDao<EkoChannelExtra> {
    @Query(value="SELECT * from channel_extra where channelId = :id LIMIT 1")
    public abstract Flowable<EkoChannelExtra> getById(String var1);

    @Override
    @Query(value="SELECT * from channel_extra where channelId = :id LIMIT 1")
    public abstract EkoChannelExtra getByIdNow(String var1);

    @Query(value="SELECT channelId from channel_extra where readStatus = :readStatus")
    public abstract Single<List<String>> getAllIdsByReadStatus(EkoChannelReadStatus var1);

    @Transaction
    public void insertOrUpdate(String id) {
        EkoChannelExtra extra = this.getByIdNow(id);
        if (extra != null) {
            this.update(extra);
        } else {
            this.insert(new EkoChannelExtra(id));
        }
    }

    @Query(value="UPDATE channel_extra set readStatus = :status where readStatus != :status")
    public abstract void updateAllReadStatuses(EkoChannelReadStatus var1);

    @Query(value="UPDATE channel_extra set readStatus = :readMode where channelId = :id")
    public abstract void updateReadStatus(String var1, EkoChannelReadStatus var2);

    @Query(value="UPDATE channel_extra set localReadToSegment = :localReadToSegment where channelId = :channelId and localReadToSegment < :localReadToSegment")
    public abstract void updateLocalReadToSegment(String var1, int var2);

    @Query(value="UPDATE channel_extra set localLastMentionedSegment = :localLastMentionedSegment where channelId = :channelId and localLastMentionedSegment < :localLastMentionedSegment")
    public abstract void updateLocalLastMentionedSegment(String var1, int var2);

    @Override
    @Query(value="DELETE from channel_extra")
    public abstract void deleteAll();

    @Query(value="DELETE from channel_extra where channelId = :channelId")
    public abstract void deleteAllFromChannel(String var1);
}

