/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.DataSource;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Query;
import com.amity.socialcloud.sdk.social.community.AmityCommunityCategorySortOption;
import com.ekoapp.ekosdk.community.category.CommunityCategoryEntity;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import java.util.List;

@Dao
public abstract class EkoCommunityCategoryDao
extends EkoObjectDao<CommunityCategoryEntity> {
    @Override
    @Delete
    public abstract void delete(CommunityCategoryEntity var1);

    @Override
    @Query(value="DELETE from community_category")
    public abstract void deleteAll();

    @Query(value="SELECT * from community_category where community_category.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) order by case when :isSortByName = 1 then community_category.name end asc, case when :isSortByName = 0 and :isSortByCreatedACS = 1 then community_category.createdAt end asc, case when :isSortByName = 0 and :isSortByCreatedACS = 0 then community_category.createdAt end desc")
    abstract DataSource.Factory<Integer, CommunityCategoryEntity> getAllImpl(boolean var1, boolean var2, Boolean var3);

    public DataSource.Factory<Integer, CommunityCategoryEntity> getAll(AmityCommunityCategorySortOption sortBy, Boolean isDeleted) {
        return this.getAllImpl(this.isSortByName(sortBy), this.isSortByCreatedACS(sortBy), isDeleted).map(input -> input);
    }

    private Boolean isSortByName(AmityCommunityCategorySortOption sortBy) {
        return sortBy == AmityCommunityCategorySortOption.NAME;
    }

    private Boolean isSortByCreatedACS(AmityCommunityCategorySortOption sortBy) {
        return sortBy == AmityCommunityCategorySortOption.FIRST_CREATED;
    }

    @Query(value="SELECT * from community_category where community_category.categoryId IN (:ids)")
    abstract List<CommunityCategoryEntity> getByIdsNowImpl(List<String> var1);

    @Override
    public List<CommunityCategoryEntity> getByIdsNow(List<String> ids) {
        return this.getByIdsNowImpl(ids);
    }
}

