/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk;

import android.util.Base64;
import android.util.LruCache;
import com.amity.socialcloud.sdk.socket.model.SocketRequest;
import com.ekoapp.ekosdk.internal.api.hash.EkoBloomFilter;
import com.ekoapp.ekosdk.internal.data.model.EkoAccountCache;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import org.joda.time.DateTime;

public class EkoFlag {
    private String hash;
    @SerializedName(value="bits")
    private int bitSize;
    @SerializedName(value="hashes")
    private int hashSize;
    private static final long EXPIRE_TIME = 1000L;
    private static final LruCache<SocketRequest, Long> timeMap = new LruCache<SocketRequest, Long>(100){

        protected Long create(SocketRequest request) {
            return 0L;
        }
    };

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    public void setBitSize(int bitSize) {
        this.bitSize = bitSize;
    }

    public int getHashSize() {
        return this.hashSize;
    }

    public void setHashSize(int hashSize) {
        this.hashSize = hashSize;
    }

    public boolean mightFlaggedByMe() {
        return new EkoBloomFilter.Builder(Base64.decode((String)this.hash, (int)0), this.bitSize, this.hashSize).build().mightContains((String)EkoAccountCache.getMyUserId().get());
    }

    public boolean expired(SocketRequest request) {
        long now = DateTime.now().getMillis();
        long lastRpcRequestTime = (Long)timeMap.get((Object)request);
        if (lastRpcRequestTime > 0L) {
            boolean expired;
            boolean bl = expired = now - lastRpcRequestTime > 1000L;
            if (expired) {
                timeMap.put((Object)request, (Object)now);
            }
            return expired;
        }
        timeMap.put((Object)request, (Object)now);
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        EkoFlag other = (EkoFlag)obj;
        return Objects.equal((Object)this.hash, (Object)other.hash) && Objects.equal((Object)this.bitSize, (Object)other.bitSize) && Objects.equal((Object)this.hashSize, (Object)other.hashSize);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hash, this.bitSize, this.hashSize});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hash", (Object)this.hash).add("bitSize", this.bitSize).add("hashSize", this.hashSize).toString();
    }
}

