/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import com.ekoapp.ekosdk.internal.EkoChannelEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoTagObject;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

@Entity(tableName="channel_tag", primaryKeys={"channelId", "tagName"}, foreignKeys={@ForeignKey(entity=EkoChannelEntity.class, parentColumns={"channelId"}, childColumns={"channelId"}, onDelete=5)})
public class EkoChannelTag
extends EkoTagObject {
    @NonNull
    private String channelId;
    @NonNull
    private String tagName;

    @NonNull
    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(@NonNull String channelId) {
        this.channelId = EkoPreconditions.checkValidId(channelId, "channelId");
    }

    @NonNull
    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(@NonNull String tagName) {
        this.tagName = EkoPreconditions.checkValidId(tagName, "tagName");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        EkoChannelTag other = (EkoChannelTag)obj;
        return Objects.equal((Object)this.channelId, (Object)other.channelId) && Objects.equal((Object)this.tagName, (Object)other.tagName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.channelId, this.tagName});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("channelId", (Object)this.channelId).add("tagName", (Object)this.tagName).toString();
    }

    public static EkoChannelTag create(@NonNull String channelId, @NonNull String tagName) {
        EkoChannelTag channelTag = new EkoChannelTag();
        channelTag.setChannelId(channelId);
        channelTag.setTagName(tagName);
        return channelTag;
    }
}

