/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.DataSource;
import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembershipSortOption;
import com.amity.socialcloud.sdk.core.permission.AmityRoles;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.AmityPagingDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelPermissionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelRoleDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoPermissionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoRoleDao;
import com.ekoapp.ekosdk.internal.data.model.ChannelMembershipPermissionEntity;
import com.ekoapp.ekosdk.internal.data.model.ChannelMembershipRoleEntity;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import io.reactivex.Flowable;
import java.util.List;

@Dao
public abstract class EkoChannelMembershipDao
extends EkoObjectDao<ChannelMembershipEntity>
implements AmityPagingDao<ChannelMembershipEntity> {
    private final EkoChannelRoleDao channelRoleDao;
    private final EkoChannelPermissionDao channelPermissionDao;

    EkoChannelMembershipDao() {
        UserDatabase db = UserDatabase.get();
        this.channelRoleDao = db.channelRoleDao();
        this.channelPermissionDao = db.channelPermissionDao();
    }

    @Query(value="UPDATE channel_membership set membership = :membership, isBanned = 1 where channelId = :channelId and userId = :userId")
    public abstract void updateMembership(String var1, String var2, String var3);

    @Query(value="UPDATE channel_membership set readToSegment = :readToSegment where channelId = :channelId and userId = :userId and readToSegment < :readToSegment")
    public abstract void updateReadToSegment(String var1, String var2, int var3);

    @Query(value="UPDATE channel_membership set lastMentionedSegment = :lastMentionedSegment where channelId = :channelId and userId = :userId and lastMentionedSegment < :lastMentionedSegment")
    public abstract void updateLastMentionedSegment(String var1, String var2, int var3);

    @Override
    @Query(value="DELETE from channel_membership")
    public abstract void deleteAll();

    @Query(value="DELETE from channel_membership where channelId = :channelId")
    public abstract void deleteAllFromChannel(String var1);

    @Query(value="SELECT * from channel_membership where channelId = :channelId and userId = :userId LIMIT 1")
    abstract Flowable<ChannelMembershipEntity> getByChannelIdAndUserIdImpl(String var1, String var2);

    public Flowable<ChannelMembershipEntity> getByChannelIdAndUserId(String channelId, String userId) {
        return this.getByChannelIdAndUserIdImpl(channelId, userId);
    }

    @Query(value="SELECT * from channel_membership where channelId = :channelId and userId = :userId LIMIT 1")
    public abstract ChannelMembershipEntity getByChannelIdAndUserIdNow(String var1, String var2);

    @Deprecated
    @Query(value="SELECT * from channel_membership where channelId = :channelId and membership in (:memberships) and isMuted = :isMuted and case when :isFilterByRoles then userId in (SELECT userId from channel_role where channelId = :channelId and roleName in (:roles)) else userId is not null end order by case when :isSortByDisplayName = 1 then channel_membership.displayName end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 1 then channel_membership.createdAt end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 0 then channel_membership.createdAt end desc")
    abstract DataSource.Factory<Integer, ChannelMembershipEntity> getDataSource(String var1, boolean var2, List<String> var3, List<String> var4, Boolean var5, boolean var6, boolean var7);

    @Deprecated
    public DataSource.Factory<Integer, ChannelMembershipEntity> getDataSource(String channelId, AmityRoles roles, List<String> memberships, Boolean isMuted, AmityChannelMembershipSortOption sortBy) {
        return this.getDataSource(channelId, !roles.isEmpty(), roles, memberships, isMuted, this.isSortByDisplayName(sortBy), this.isSortByCreatedACS(sortBy)).map(input -> input);
    }

    @Query(value="SELECT * from channel_membership where channelId = :channelId and membership in (:memberships) and isMuted = :isMuted and case when :isFilterByRoles then userId in (SELECT userId from channel_role where channelId = :channelId and roleName in (:roles)) else userId is not null end order by case when :isSortByDisplayName = 1 then channel_membership.displayName end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 1 then channel_membership.createdAt end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 0 then channel_membership.createdAt end desc")
    abstract PagingSource<Integer, ChannelMembershipEntity> getPagingSource(String var1, boolean var2, List<String> var3, List<String> var4, Boolean var5, boolean var6, boolean var7);

    public PagingSource<Integer, ChannelMembershipEntity> getPagingSource(String channelId, AmityRoles roles, List<String> memberships, Boolean isMuted, AmityChannelMembershipSortOption sortBy) {
        return this.getPagingSource(channelId, !roles.isEmpty(), roles, memberships, isMuted, this.isSortByDisplayName(sortBy), this.isSortByCreatedACS(sortBy));
    }

    private Boolean isSortByDisplayName(AmityChannelMembershipSortOption sortBy) {
        return false;
    }

    private Boolean isSortByCreatedACS(AmityChannelMembershipSortOption sortBy) {
        return sortBy == AmityChannelMembershipSortOption.FIRST_CREATED;
    }

    @Override
    @Transaction
    public void insert(ChannelMembershipEntity membership) {
        super.insert(membership);
        EkoRoleDao.update(membership, this.channelRoleDao, ChannelMembershipRoleEntity::create);
        EkoPermissionDao.update(membership, this.channelPermissionDao, ChannelMembershipPermissionEntity::create);
    }

    @Override
    @Transaction
    public void insert(List<ChannelMembershipEntity> memberships) {
        super.insert(memberships);
        EkoRoleDao.update(memberships, this.channelRoleDao, ChannelMembershipRoleEntity::create);
        EkoPermissionDao.update(memberships, this.channelPermissionDao, ChannelMembershipPermissionEntity::create);
    }

    @Override
    public void update(ChannelMembershipEntity membership) {
        super.update(membership);
        EkoRoleDao.update(membership, this.channelRoleDao, ChannelMembershipRoleEntity::create);
        EkoPermissionDao.update(membership, this.channelPermissionDao, ChannelMembershipPermissionEntity::create);
    }

    @Transaction
    public void updateUser(String userId) {
        this.updateUserImpl(userId);
    }

    @Query(value="UPDATE channel_membership set userId = :userId where userId = :userId")
    abstract void updateUserImpl(String var1);
}

