/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.CommunityMemberQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.model.CommunityMemberQueryTokenEntity;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class CommunityMemberQueryTokenDao_Impl
extends CommunityMemberQueryTokenDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CommunityMemberQueryTokenEntity> __insertionAdapterOfCommunityMemberQueryTokenEntity;
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();

    public CommunityMemberQueryTokenDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCommunityMemberQueryTokenEntity = new EntityInsertionAdapter<CommunityMemberQueryTokenEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `community_member_query_token` (`communityId`,`memberships`,`roles`,`sortOption`,`previous`,`next`,`pageNumber`,`ids`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityMemberQueryTokenEntity value) {
                if (value.getCommunityId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommunityId());
                }
                if (value.getMemberships() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMemberships());
                }
                if (value.getRoles() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getRoles());
                }
                if (value.getSortOption() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getSortOption());
                }
                if (value.getPrevious() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getPrevious());
                }
                if (value.getNext() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getNext());
                }
                stmt.bindLong(7, (long)value.getPageNumber());
                String _tmp = CommunityMemberQueryTokenDao_Impl.this.__stringListConverter.stringListToString(value.getIds());
                if (_tmp == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp);
                }
                String _tmp_1 = CommunityMemberQueryTokenDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_1);
                }
            }
        };
    }

    @Override
    public Completable insertToken(final CommunityMemberQueryTokenEntity token) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CommunityMemberQueryTokenDao_Impl.this.__db.beginTransaction();
                try {
                    CommunityMemberQueryTokenDao_Impl.this.__insertionAdapterOfCommunityMemberQueryTokenEntity.insert((Object)token);
                    CommunityMemberQueryTokenDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    CommunityMemberQueryTokenDao_Impl.this.__db.endTransaction();
                }
            }
        });
    }

    @Override
    public Maybe<CommunityMemberQueryTokenEntity> queryToken(SimpleSQLiteQuery query) {
        SimpleSQLiteQuery _internalQuery = query;
        return Maybe.fromCallable((Callable)new Callable<CommunityMemberQueryTokenEntity>((SupportSQLiteQuery)_internalQuery){
            final /* synthetic */ SupportSQLiteQuery val$_internalQuery;
            {
                this.val$_internalQuery = supportSQLiteQuery;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommunityMemberQueryTokenEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CommunityMemberQueryTokenDao_Impl.this.__db, (SupportSQLiteQuery)this.val$_internalQuery, (boolean)false, null);){
                    CommunityMemberQueryTokenEntity _result = _cursor.moveToFirst() ? CommunityMemberQueryTokenDao_Impl.this.__entityCursorConverter_comEkoappEkosdkInternalDataModelCommunityMemberQueryTokenEntity(_cursor) : null;
                    CommunityMemberQueryTokenEntity communityMemberQueryTokenEntity = _result;
                    return communityMemberQueryTokenEntity;
                }
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private CommunityMemberQueryTokenEntity __entityCursorConverter_comEkoappEkosdkInternalDataModelCommunityMemberQueryTokenEntity(Cursor cursor) {
        int _cursorIndexOfCommunityId = cursor.getColumnIndex("communityId");
        int _cursorIndexOfMemberships = cursor.getColumnIndex("memberships");
        int _cursorIndexOfRoles = cursor.getColumnIndex("roles");
        int _cursorIndexOfSortOption = cursor.getColumnIndex("sortOption");
        int _cursorIndexOfPrevious = cursor.getColumnIndex("previous");
        int _cursorIndexOfNext = cursor.getColumnIndex("next");
        int _cursorIndexOfPageNumber = cursor.getColumnIndex("pageNumber");
        int _cursorIndexOfIds = cursor.getColumnIndex("ids");
        int _cursorIndexOfUpdatedAt = cursor.getColumnIndex("updatedAt");
        String _tmpCommunityId = _cursorIndexOfCommunityId == -1 ? null : (cursor.isNull(_cursorIndexOfCommunityId) ? null : cursor.getString(_cursorIndexOfCommunityId));
        String _tmpMemberships = _cursorIndexOfMemberships == -1 ? null : (cursor.isNull(_cursorIndexOfMemberships) ? null : cursor.getString(_cursorIndexOfMemberships));
        String _tmpRoles = _cursorIndexOfRoles == -1 ? null : (cursor.isNull(_cursorIndexOfRoles) ? null : cursor.getString(_cursorIndexOfRoles));
        String _tmpSortOption = _cursorIndexOfSortOption == -1 ? null : (cursor.isNull(_cursorIndexOfSortOption) ? null : cursor.getString(_cursorIndexOfSortOption));
        CommunityMemberQueryTokenEntity _entity = new CommunityMemberQueryTokenEntity(_tmpCommunityId, _tmpMemberships, _tmpRoles, _tmpSortOption);
        if (_cursorIndexOfPrevious != -1) {
            String _tmpPrevious = cursor.isNull(_cursorIndexOfPrevious) ? null : cursor.getString(_cursorIndexOfPrevious);
            _entity.setPrevious(_tmpPrevious);
        }
        if (_cursorIndexOfNext != -1) {
            String _tmpNext = cursor.isNull(_cursorIndexOfNext) ? null : cursor.getString(_cursorIndexOfNext);
            _entity.setNext(_tmpNext);
        }
        if (_cursorIndexOfPageNumber != -1) {
            int _tmpPageNumber = cursor.getInt(_cursorIndexOfPageNumber);
            _entity.setPageNumber(_tmpPageNumber);
        }
        if (_cursorIndexOfIds != -1) {
            String _tmp = cursor.isNull(_cursorIndexOfIds) ? null : cursor.getString(_cursorIndexOfIds);
            List<String> _tmpIds = this.__stringListConverter.stringToStringList(_tmp);
            _entity.setIds(_tmpIds);
        }
        if (_cursorIndexOfUpdatedAt != -1) {
            String _tmp_1 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
            DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
            _entity.setUpdatedAt(_tmpUpdatedAt);
        }
        return _entity;
    }
}

