/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.socket.call;

import com.amity.socialcloud.sdk.socket.model.SocketResponse;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoPostAndUserMapper;
import com.ekoapp.ekosdk.internal.api.socket.call.ResponseConverter;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.GlobalPostDao;
import com.ekoapp.ekosdk.internal.data.model.UserFeedQueryTokenEntity;
import com.ekoapp.ekosdk.internal.entity.GlobalPostEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/ekoapp/ekosdk/internal/api/socket/call/GlobalPostQueryConverter;", "Lcom/ekoapp/ekosdk/internal/api/socket/call/ResponseConverter;", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoPostQueryDto;", "()V", "assignRank", "", "dto", "convert", "response", "Lcom/amity/socialcloud/sdk/socket/model/SocketResponse;", "invalidateCache", "amity-sdk_release"})
public final class GlobalPostQueryConverter
implements ResponseConverter<EkoPostQueryDto> {
    @Override
    @NotNull
    public EkoPostQueryDto convert(@NotNull SocketResponse response) {
        EkoPostQueryDto dto;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        EkoPostQueryDto ekoPostQueryDto = dto = (EkoPostQueryDto)response.getData(EkoPostQueryDto.class);
        Intrinsics.checkNotNullExpressionValue((Object)ekoPostQueryDto, (String)"dto");
        this.invalidateCache(ekoPostQueryDto);
        this.assignRank(dto);
        EkoPostAndUserMapper.MAPPER.map(dto);
        return dto;
    }

    private final void invalidateCache(EkoPostQueryDto dto) {
        UserFeedQueryTokenEntity userFeedQueryTokenEntity = dto.getPaging();
        Intrinsics.checkNotNullExpressionValue((Object)userFeedQueryTokenEntity, (String)"dto.paging");
        if (userFeedQueryTokenEntity.getPrevious() == null) {
            UserDatabase.get().globalPostDao().deleteAll();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assignRank(EkoPostQueryDto dto) {
        void $this$mapTo$iv$iv;
        GlobalPostDao globalPostDao = UserDatabase.get().globalPostDao();
        int rank = globalPostDao.getHighestRank();
        List<EkoPostDto> list = dto.getPosts();
        Intrinsics.checkNotNullExpressionValue(list, (String)"dto.posts");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EkoPostDto ekoPostDto = (EkoPostDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int n = rank;
            rank = n + 1;
            GlobalPostEntity globalPostEntity = new GlobalPostEntity();
            boolean bl2 = false;
            boolean bl3 = false;
            GlobalPostEntity $this$apply = globalPostEntity;
            boolean bl4 = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            String string = v1.getPostId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.postId");
            $this$apply.setPostId(string);
            $this$apply.setPageNumber(1);
            $this$apply.setRank(rank);
            GlobalPostEntity globalPostEntity2 = globalPostEntity;
            collection.add(globalPostEntity2);
        }
        List globalPosts = (List)destination$iv$iv;
        globalPostDao.insert(globalPosts);
    }
}

