/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.community;

import androidx.paging.DataSource;
import androidx.paging.PagedList;
import com.amity.socialcloud.sdk.social.community.AmityCommunity;
import com.amity.socialcloud.sdk.social.community.AmityCommunityFilter;
import com.amity.socialcloud.sdk.social.community.AmityCommunitySortOption;
import com.amity.socialcloud.sdk.social.feed.AmityFeedType;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.CommunityDeleteConverter;
import com.ekoapp.ekosdk.internal.api.socket.call.CommunityListQueryConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityCreateByAdminRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityCreateRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityDeleteByIdRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityGetByIdRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityJoinRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityLeaveRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityUpdateByAdminRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityUpdateRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoCommunityBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoRecommendedCommunityBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoTrendingCommunityBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoFeedDao;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import com.ekoapp.ekosdk.internal.entity.FeedEntity;
import com.ekoapp.ekosdk.internal.repository.community.CommunityRepository$WhenMappings;
import com.ekoapp.ekosdk.internal.repository.community.CommunityRepository$getPostCount$1;
import com.ekoapp.ekosdk.internal.repository.community.CommunityRepository$sam$io_reactivex_functions_Function$0;
import com.ekoapp.ekosdk.internal.repository.community.helper.CommunityRepositoryHelper;
import com.google.gson.JsonObject;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Jk\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0012Ju\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\f2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007JC\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010%J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050'2\u0006\u0010\u0019\u001a\u00020\u0007JA\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050)0'2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020\u001cH\u0002J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0'2\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/J\u0012\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050)0'J\u0012\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050)0'J\u000e\u00102\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u00103\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007Je\u00104\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u00105Jo\u00106\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\f2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00107\u00a8\u00068"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/community/CommunityRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "createCommunity", "Lio/reactivex/Single;", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunity;", "displayName", "", "description", "categoryIds", "", "isPublic", "", "metadata", "Lcom/google/gson/JsonObject;", "userIds", "avatarFileId", "needApprovalOnPostCreation", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;Lcom/google/gson/JsonObject;Ljava/util/List;Ljava/lang/String;Ljava/lang/Boolean;)Lio/reactivex/Single;", "createCommunityByAdmin", "isOfficial", "onlyAdminCanPost", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/util/List;Lcom/google/gson/JsonObject;Ljava/util/List;Ljava/lang/String;)Lio/reactivex/Single;", "deleteCommunity", "Lio/reactivex/Completable;", "communityId", "getAllCommunity", "Landroidx/paging/DataSource$Factory;", "", "Lcom/ekoapp/ekosdk/internal/entity/CommunityEntity;", "keyword", "categoryId", "filter", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityFilter;", "sortBy", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunitySortOption;", "isDeleted", "(Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/social/community/AmityCommunityFilter;Lcom/amity/socialcloud/sdk/social/community/AmityCommunitySortOption;Ljava/lang/Boolean;)Landroidx/paging/DataSource$Factory;", "getCommunity", "Lio/reactivex/Flowable;", "getCommunityCollection", "Landroidx/paging/PagedList;", "(Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/social/community/AmityCommunityFilter;Lcom/amity/socialcloud/sdk/social/community/AmityCommunitySortOption;Ljava/lang/Boolean;)Lio/reactivex/Flowable;", "getDefaultPageSize", "getPostCount", "targetId", "feedType", "Lcom/amity/socialcloud/sdk/social/feed/AmityFeedType;", "getRecommendedCommunities", "getTrendingCommunities", "joinCommunity", "leaveCommunity", "updateCommunity", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;Lcom/google/gson/JsonObject;Ljava/lang/String;Ljava/lang/Boolean;)Lio/reactivex/Single;", "updateCommunityByAdmin", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/util/List;Lcom/google/gson/JsonObject;Ljava/lang/String;)Lio/reactivex/Single;", "amity-sdk_release"})
public final class CommunityRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Single<AmityCommunity> createCommunity(@NotNull String displayName, @Nullable String description, @Nullable List<String> categoryIds, @Nullable Boolean isPublic, @Nullable JsonObject metadata, @Nullable List<String> userIds, @Nullable String avatarFileId, @Nullable Boolean needApprovalOnPostCreation) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        CommunityCreateRequest request = new CommunityCreateRequest(displayName, description, categoryIds, isPublic, metadata, userIds, avatarFileId, needApprovalOnPostCreation);
        Single single = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).map(CommunityRepositoryHelper.INSTANCE.getSingleRequestMapper());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"EkoSocket.call(Call.crea\u2026lper.singleRequestMapper)");
        return single;
    }

    @NotNull
    public final Single<AmityCommunity> createCommunityByAdmin(@NotNull String displayName, @Nullable String description, @Nullable Boolean isOfficial, @Nullable Boolean isPublic, @Nullable Boolean onlyAdminCanPost, @Nullable List<String> categoryIds, @Nullable JsonObject metadata, @Nullable List<String> userIds, @Nullable String avatarFileId) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        CommunityCreateByAdminRequest request = new CommunityCreateByAdminRequest(displayName, description, isOfficial, isPublic, onlyAdminCanPost, categoryIds, metadata, userIds, avatarFileId);
        Single single = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).map(CommunityRepositoryHelper.INSTANCE.getSingleRequestMapper());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"EkoSocket.call(Call.crea\u2026lper.singleRequestMapper)");
        return single;
    }

    @NotNull
    public final Flowable<PagedList<AmityCommunity>> getCommunityCollection(@NotNull String keyword, @NotNull String categoryId, @NotNull AmityCommunityFilter filter, @NotNull AmityCommunitySortOption sortBy, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        DataSource.Factory factory2 = this.getAllCommunity(keyword, categoryId, filter, sortBy, isDeleted).map(CommunityRepositoryHelper.INSTANCE.getFactoryMapper());
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        EkoCommunityBoundaryCallback boundaryCallback = new EkoCommunityBoundaryCallback(keyword, categoryId, filter, sortBy, isDeleted, this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        return this.createRxCollectionWithBoundaryCallback(factory2.map((androidx.arch.core.util.Function)boundaryCallback), boundaryCallback);
    }

    @NotNull
    public final Flowable<PagedList<AmityCommunity>> getRecommendedCommunities() {
        EkoCommunityDao communityDao = UserDatabase.get().communityDao();
        DataSource.Factory factory2 = communityDao.getRecommendedCommunityCollection().map(CommunityRepositoryHelper.INSTANCE.getFactoryMapper());
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        EkoRecommendedCommunityBoundaryCallback boundaryCallback = new EkoRecommendedCommunityBoundaryCallback(this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        return this.createRxCollectionWithBoundaryCallback(factory2.map((androidx.arch.core.util.Function)boundaryCallback), boundaryCallback);
    }

    @NotNull
    public final Flowable<PagedList<AmityCommunity>> getTrendingCommunities() {
        EkoCommunityDao communityDao = UserDatabase.get().communityDao();
        DataSource.Factory factory2 = communityDao.getTrendingCommunityCollection().map(CommunityRepositoryHelper.INSTANCE.getFactoryMapper());
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        EkoTrendingCommunityBoundaryCallback boundaryCallback = new EkoTrendingCommunityBoundaryCallback(this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        return this.createRxCollectionWithBoundaryCallback(factory2.map((androidx.arch.core.util.Function)boundaryCallback), boundaryCallback);
    }

    @NotNull
    public final Flowable<AmityCommunity> getCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        EkoCommunityDao communityDao = UserDatabase.get().communityDao();
        CommunityGetByIdRequest request = new CommunityGetByIdRequest(communityId);
        CommunityListQueryConverter converter2 = new CommunityListQueryConverter();
        EkoSocket.call(Call.create(request, converter2));
        Flowable flowable = communityDao.getByCommunityId(communityId).map(CommunityRepositoryHelper.INSTANCE.getQueryMapper());
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"communityDao.getByCommun\u2026sitoryHelper.queryMapper)");
        return flowable;
    }

    @NotNull
    public final Completable deleteCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        CommunityDeleteByIdRequest request = new CommunityDeleteByIdRequest(communityId);
        CommunityDeleteConverter converter2 = new CommunityDeleteConverter(communityId);
        Completable completable = EkoSocket.call(Call.create(request, converter2)).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Single<AmityCommunity> updateCommunity(@NotNull String communityId, @Nullable String displayName, @Nullable String description, @Nullable List<String> categoryIds, @Nullable Boolean isPublic, @Nullable JsonObject metadata, @Nullable String avatarFileId, @Nullable Boolean needApprovalOnPostCreation) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Boolean bl = needApprovalOnPostCreation;
        String string = avatarFileId;
        JsonObject jsonObject = metadata;
        Boolean bl2 = isPublic;
        List<String> list = categoryIds;
        CommunityUpdateRequest request = new CommunityUpdateRequest(communityId, displayName, description, bl2, list, jsonObject, string, bl);
        Single single = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).map(CommunityRepositoryHelper.INSTANCE.getSingleRequestMapper());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"EkoSocket.call(Call.crea\u2026lper.singleRequestMapper)");
        return single;
    }

    @NotNull
    public final Single<AmityCommunity> updateCommunityByAdmin(@NotNull String communityId, @Nullable String displayName, @Nullable String description, @Nullable Boolean isOfficial, @Nullable Boolean isPublic, @Nullable Boolean onlyAdminCanPost, @Nullable List<String> categoryIds, @Nullable JsonObject metadata, @Nullable String avatarFileId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        CommunityUpdateByAdminRequest request = new CommunityUpdateByAdminRequest(communityId, displayName, description, isOfficial, isPublic, onlyAdminCanPost, categoryIds, metadata, avatarFileId);
        Single single = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).map(CommunityRepositoryHelper.INSTANCE.getSingleRequestMapper());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"EkoSocket.call(Call.crea\u2026lper.singleRequestMapper)");
        return single;
    }

    @NotNull
    public final Completable joinCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        CommunityJoinRequest request = new CommunityJoinRequest(communityId);
        CommunityListQueryConverter converter2 = new CommunityListQueryConverter();
        Completable completable = EkoSocket.call(Call.create(request, converter2)).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026nverter)).ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable leaveCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        CommunityLeaveRequest request = new CommunityLeaveRequest(communityId);
        CommunityListQueryConverter converter2 = new CommunityListQueryConverter();
        Completable completable = EkoSocket.call(Call.create(request, converter2)).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026nverter)).ignoreElement()");
        return completable;
    }

    @NotNull
    public final Flowable<Integer> getPostCount(@NotNull String targetId, @NotNull AmityFeedType feedType) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
        EkoFeedDao feedDao = UserDatabase.get().feedDao();
        Flowable<FeedEntity> flowable = feedDao.getCommunityFeed(targetId, feedType.getApiKey());
        Object object = (Function1)CommunityRepository$getPostCount$1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new CommunityRepository$sam$io_reactivex_functions_Function$0(function1);
        }
        Flowable flowable2 = flowable.map((Function)object);
        Intrinsics.checkNotNullExpressionValue((Object)flowable2, (String)"feedDao.getCommunityFeed\u2026ap(FeedEntity::postCount)");
        return flowable2;
    }

    private final DataSource.Factory<Integer, CommunityEntity> getAllCommunity(String keyword, String categoryId, AmityCommunityFilter filter, AmityCommunitySortOption sortBy, Boolean isDeleted) {
        DataSource.Factory<Integer, CommunityEntity> factory2;
        EkoCommunityDao communityDao = UserDatabase.get().communityDao();
        switch (CommunityRepository$WhenMappings.$EnumSwitchMapping$0[filter.ordinal()]) {
            case 1: {
                DataSource.Factory<Integer, CommunityEntity> factory3;
                CharSequence charSequence = categoryId;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    DataSource.Factory<Integer, CommunityEntity> factory4 = communityDao.getAllByKeywordForMember(keyword, sortBy, isDeleted);
                    factory3 = factory4;
                    Intrinsics.checkNotNullExpressionValue(factory4, (String)"communityDao.getAllByKey\u2026yword, sortBy, isDeleted)");
                } else {
                    DataSource.Factory<Integer, CommunityEntity> factory5 = communityDao.getAllByCategoryIdForMember(keyword, categoryId, sortBy, isDeleted);
                    factory3 = factory5;
                    Intrinsics.checkNotNullExpressionValue(factory5, (String)"communityDao.getAllByCat\u2026oryId, sortBy, isDeleted)");
                }
                return factory3;
            }
            case 2: {
                DataSource.Factory<Integer, CommunityEntity> factory6;
                CharSequence charSequence = categoryId;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    DataSource.Factory<Integer, CommunityEntity> factory7 = communityDao.getAllByKeywordForNonMember(keyword, sortBy, isDeleted);
                    factory6 = factory7;
                    Intrinsics.checkNotNullExpressionValue(factory7, (String)"communityDao.getAllByKey\u2026yword, sortBy, isDeleted)");
                } else {
                    DataSource.Factory<Integer, CommunityEntity> factory8 = communityDao.getAllByCategoryIdForNonMember(keyword, categoryId, sortBy, isDeleted);
                    factory6 = factory8;
                    Intrinsics.checkNotNullExpressionValue(factory8, (String)"communityDao.getAllByCat\u2026oryId, sortBy, isDeleted)");
                }
                return factory6;
            }
        }
        CharSequence charSequence = categoryId;
        boolean bl = false;
        if (charSequence.length() == 0) {
            DataSource.Factory<Integer, CommunityEntity> factory9 = communityDao.getAllByKeyword(keyword, sortBy, isDeleted);
            factory2 = factory9;
            Intrinsics.checkNotNullExpressionValue(factory9, (String)"communityDao.getAllByKey\u2026yword, sortBy, isDeleted)");
        } else {
            DataSource.Factory<Integer, CommunityEntity> factory10 = communityDao.getAllByCategoryId(keyword, categoryId, sortBy, isDeleted);
            factory2 = factory10;
            Intrinsics.checkNotNullExpressionValue(factory10, (String)"communityDao.getAllByCat\u2026oryId, sortBy, isDeleted)");
        }
        return factory2;
    }
}

