/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.event;

import androidx.annotation.NonNull;
import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageAndUserListDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto;
import com.ekoapp.ekosdk.internal.api.event.MessageListener;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;
import com.ekoapp.ekosdk.message.mention.AmityMessageMentionType;

public class MessageDidUpdateListener
extends MessageListener {
    @Override
    @NonNull
    public String getEvent() {
        return "v3.message.didUpdate";
    }

    @Override
    protected void onEvent(@NonNull String event, Object ... args) {
        super.onEvent(event, args);
        String json = args[0].toString();
        EkoMessageAndUserListDto messageAndUserDto = (EkoMessageAndUserListDto)EkoGson.get().fromJson(json, EkoMessageAndUserListDto.class);
        EkoMessageDto messageDto = messageAndUserDto.getMessages().get(0);
        EkoChannelMembershipDao membershipDao = UserDatabase.get().channelMembershipDao();
        for (EkoMentioneesDto mentioneesDto : messageDto.getMentionees()) {
            boolean isMentionChannel;
            boolean bl = isMentionChannel = AmityMessageMentionType.Companion.enumOf(mentioneesDto.getType()) == AmityMessageMentionType.CHANNEL;
            if (!isMentionChannel && (mentioneesDto.getUserIds() == null || !mentioneesDto.getUserIds().contains(AmityCoreClient.INSTANCE.getUserId()))) continue;
            membershipDao.updateLastMentionedSegment(messageDto.getChannelId(), AmityCoreClient.INSTANCE.getUserId(), messageDto.getChannelSegment());
        }
    }
}

