/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.stream;

import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoStreamSessionDao;
import com.ekoapp.ekosdk.stream.StreamSessionSyncState;
import com.ekoapp.ekosdk.stream.entity.EkoStreamSessionEntity;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u0016\u0010\f\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0011J%\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010\u0017\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0014\u0010\u0018\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0014\u0010\u0019\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0006\u0010\u001a\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000f\u00a8\u0006\u001d"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/stream/StreamSessionRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "createStreamSession", "", "sessionId", "", "streamId", "title", "startedAt", "Lorg/joda/time/DateTime;", "resolution", "deleteIfExceedRetry", "streamEntities", "", "Lcom/ekoapp/ekosdk/stream/entity/EkoStreamSessionEntity;", "getById", "Lio/reactivex/Flowable;", "getStreamSessionCollection", "syncStateArray", "", "Lcom/ekoapp/ekosdk/stream/StreamSessionSyncState;", "([Lcom/ekoapp/ekosdk/stream/StreamSessionSyncState;)Lio/reactivex/Flowable;", "markAsFailed", "markAsSynced", "markAsSyncing", "resetSyncState", "updateStreamSession", "streamEntity", "amity-sdk_release"})
public final class StreamSessionRepository
extends EkoObjectRepository {
    @NotNull
    public final Flowable<List<EkoStreamSessionEntity>> getStreamSessionCollection() {
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        Flowable<List<EkoStreamSessionEntity>> flowable = streamDao.getAll(new String[]{StreamSessionSyncState.PENDING.getKey(), StreamSessionSyncState.SYNCING.getKey(), StreamSessionSyncState.SYNCED.getKey()});
        Intrinsics.checkExpressionValueIsNotNull(flowable, (String)"streamDao.getAll(arrayOf\u2026ionSyncState.SYNCED.key))");
        return flowable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flowable<List<EkoStreamSessionEntity>> getStreamSessionCollection(@NotNull StreamSessionSyncState[] syncStateArray) {
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)syncStateArray, (String)"syncStateArray");
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        boolean bl = false;
        ArrayList<String> syncStateList = new ArrayList<String>();
        Object $this$forEach$iv = syncStateArray;
        boolean $i$f$forEach = false;
        StreamSessionSyncState[] streamSessionSyncStateArray = $this$forEach$iv;
        int n = streamSessionSyncStateArray.length;
        for (int i = 0; i < n; ++i) {
            StreamSessionSyncState element$iv;
            StreamSessionSyncState it = element$iv = streamSessionSyncStateArray[i];
            boolean bl2 = false;
            syncStateList.add(it.getKey());
        }
        $this$forEach$iv = syncStateList;
        EkoStreamSessionDao ekoStreamSessionDao = streamDao;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        Flowable<List<EkoStreamSessionEntity>> flowable = ekoStreamSessionDao.getAll(stringArray2);
        Intrinsics.checkExpressionValueIsNotNull(flowable, (String)"streamDao.getAll(syncStateList.toTypedArray())");
        return flowable;
    }

    @NotNull
    public final Flowable<EkoStreamSessionEntity> getById(@NotNull String sessionId) {
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        Flowable<EkoStreamSessionEntity> flowable = streamDao.getById(sessionId);
        Intrinsics.checkExpressionValueIsNotNull(flowable, (String)"streamDao.getById(sessionId)");
        return flowable;
    }

    public final void resetSyncState() {
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        streamDao.updateSyncState(StreamSessionSyncState.SYNCING, StreamSessionSyncState.PENDING);
    }

    public final void createStreamSession(@NotNull String sessionId, @NotNull String streamId, @NotNull String title, @NotNull DateTime startedAt, @NotNull String resolution) {
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        Intrinsics.checkParameterIsNotNull((Object)streamId, (String)"streamId");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)startedAt, (String)"startedAt");
        Intrinsics.checkParameterIsNotNull((Object)resolution, (String)"resolution");
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        EkoStreamSessionEntity streamSession = new EkoStreamSessionEntity();
        streamSession.setSessionId(sessionId);
        streamSession.setStreamId(streamId);
        streamSession.setTitle(title);
        streamSession.setStartTime(startedAt);
        streamSession.setResolution(resolution);
        streamDao.insert((EkoObject)streamSession);
    }

    public final void updateStreamSession(@NotNull EkoStreamSessionEntity streamEntity) {
        Intrinsics.checkParameterIsNotNull((Object)streamEntity, (String)"streamEntity");
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        streamDao.update((EkoObject)streamEntity);
    }

    public final void markAsSyncing(@NotNull List<EkoStreamSessionEntity> streamEntities) {
        Intrinsics.checkParameterIsNotNull(streamEntities, (String)"streamEntities");
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        Iterable $this$forEach$iv = streamEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EkoStreamSessionEntity it = (EkoStreamSessionEntity)element$iv;
            boolean bl = false;
            it.setSyncState(StreamSessionSyncState.SYNCING.getKey());
        }
        streamDao.update(streamEntities);
    }

    public final void markAsSynced(@NotNull List<EkoStreamSessionEntity> streamEntities) {
        Intrinsics.checkParameterIsNotNull(streamEntities, (String)"streamEntities");
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        Iterable $this$forEach$iv = streamEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EkoStreamSessionEntity it = (EkoStreamSessionEntity)element$iv;
            boolean bl = false;
            it.setSyncState(StreamSessionSyncState.SYNCED.getKey());
        }
        streamDao.update(streamEntities);
    }

    public final void markAsFailed(@NotNull List<EkoStreamSessionEntity> streamEntities) {
        Intrinsics.checkParameterIsNotNull(streamEntities, (String)"streamEntities");
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        Iterable $this$forEach$iv = streamEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EkoStreamSessionEntity it = (EkoStreamSessionEntity)element$iv;
            boolean bl = false;
            it.setSyncState(StreamSessionSyncState.PENDING.getKey());
            EkoStreamSessionEntity ekoStreamSessionEntity = it;
            int n = ekoStreamSessionEntity.getRetryCount();
            ekoStreamSessionEntity.setRetryCount(n + 1);
        }
        streamDao.update(streamEntities);
        this.deleteIfExceedRetry(streamEntities);
    }

    private final void deleteIfExceedRetry(List<EkoStreamSessionEntity> streamEntities) {
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        Iterable $this$forEach$iv = streamEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EkoStreamSessionEntity it = (EkoStreamSessionEntity)element$iv;
            boolean bl = false;
            if (it.getRetryCount() <= 3) continue;
            streamDao.delete((EkoObject)it);
        }
    }
}

