/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoStreamSessionDao;
import com.ekoapp.ekosdk.stream.StreamSessionSyncState;
import com.ekoapp.ekosdk.stream.entity.EkoStreamSessionEntity;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoStreamSessionDao_Impl
extends EkoStreamSessionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoStreamSessionEntity> __insertionAdapterOfEkoStreamSessionEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<EkoStreamSessionEntity> __deletionAdapterOfEkoStreamSessionEntity;
    private final EntityDeletionOrUpdateAdapter<EkoStreamSessionEntity> __updateAdapterOfEkoStreamSessionEntity;
    private final SharedSQLiteStatement __preparedStmtOfUpdateSyncStateImpl;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoStreamSessionDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoStreamSessionEntity = new EntityInsertionAdapter<EkoStreamSessionEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `stream_session` (`sessionId`,`streamId`,`title`,`watchSeconds`,`startTime`,`endTime`,`resolution`,`syncState`,`syncedAt`,`retryCount`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoStreamSessionEntity value) {
                if (value.getSessionId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSessionId());
                }
                if (value.getStreamId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getStreamId());
                }
                if (value.getTitle() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTitle());
                }
                stmt.bindLong(4, value.getWatchSeconds());
                String _tmp = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getStartTime());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEndTime());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                if (value.getResolution() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getResolution());
                }
                if (value.getSyncState() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getSyncState());
                }
                String _tmp_2 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getSyncedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_2);
                }
                stmt.bindLong(10, (long)value.getRetryCount());
                String _tmp_3 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_3);
                }
                String _tmp_4 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_4);
                }
            }
        };
        this.__deletionAdapterOfEkoStreamSessionEntity = new EntityDeletionOrUpdateAdapter<EkoStreamSessionEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `stream_session` WHERE `sessionId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoStreamSessionEntity value) {
                if (value.getSessionId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSessionId());
                }
            }
        };
        this.__updateAdapterOfEkoStreamSessionEntity = new EntityDeletionOrUpdateAdapter<EkoStreamSessionEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `stream_session` SET `sessionId` = ?,`streamId` = ?,`title` = ?,`watchSeconds` = ?,`startTime` = ?,`endTime` = ?,`resolution` = ?,`syncState` = ?,`syncedAt` = ?,`retryCount` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `sessionId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoStreamSessionEntity value) {
                if (value.getSessionId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSessionId());
                }
                if (value.getStreamId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getStreamId());
                }
                if (value.getTitle() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTitle());
                }
                stmt.bindLong(4, value.getWatchSeconds());
                String _tmp = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getStartTime());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEndTime());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                if (value.getResolution() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getResolution());
                }
                if (value.getSyncState() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getSyncState());
                }
                String _tmp_2 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getSyncedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_2);
                }
                stmt.bindLong(10, (long)value.getRetryCount());
                String _tmp_3 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_3);
                }
                String _tmp_4 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_4);
                }
                if (value.getSessionId() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getSessionId());
                }
            }
        };
        this.__preparedStmtOfUpdateSyncStateImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE stream_session set syncState = ? where syncState = ?";
                return "UPDATE stream_session set syncState = ? where syncState = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from stream_session";
                return "DELETE from stream_session";
            }
        };
    }

    @Override
    void insertImpl(EkoStreamSessionEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoStreamSessionEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<EkoStreamSessionEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoStreamSessionEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoStreamSessionEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoStreamSessionEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<EkoStreamSessionEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoStreamSessionEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(EkoStreamSessionEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoStreamSessionEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateSyncState(StreamSessionSyncState fromState, StreamSessionSyncState toState) {
        this.__db.beginTransaction();
        try {
            EkoStreamSessionDao_Impl.super.updateSyncState(fromState, toState);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoStreamSessionEntity object) {
        this.__db.beginTransaction();
        try {
            EkoStreamSessionDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<EkoStreamSessionEntity> objects) {
        this.__db.beginTransaction();
        try {
            EkoStreamSessionDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoStreamSessionEntity object) {
        this.__db.beginTransaction();
        try {
            EkoStreamSessionDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateSyncStateImpl(String fromState, String toState) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateSyncStateImpl.acquire();
        int _argIndex = 1;
        if (toState == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, toState);
        }
        _argIndex = 2;
        if (fromState == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, fromState);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateSyncStateImpl.release(_stmt);
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    Flowable<List<EkoStreamSessionEntity>> getAllImpl(String[] syncStates) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from stream_session where syncState in (");
        int _inputSize = syncStates.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") AND watchSeconds > 0 order by startTime DESC");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : syncStates) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"stream_session"}, (Callable)new Callable<List<EkoStreamSessionEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<EkoStreamSessionEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoStreamSessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
                    int _cursorIndexOfStreamId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"streamId");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfWatchSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"watchSeconds");
                    int _cursorIndexOfStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"startTime");
                    int _cursorIndexOfEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"endTime");
                    int _cursorIndexOfResolution = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resolution");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfSyncedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncedAt");
                    int _cursorIndexOfRetryCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"retryCount");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    ArrayList<EkoStreamSessionEntity> _result = new ArrayList<EkoStreamSessionEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        EkoStreamSessionEntity _item_1 = new EkoStreamSessionEntity();
                        String _tmpSessionId = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                        _item_1.setSessionId(_tmpSessionId);
                        String _tmpStreamId = _cursor.isNull(_cursorIndexOfStreamId) ? null : _cursor.getString(_cursorIndexOfStreamId);
                        _item_1.setStreamId(_tmpStreamId);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        _item_1.setTitle(_tmpTitle);
                        long _tmpWatchSeconds = _cursor.getLong(_cursorIndexOfWatchSeconds);
                        _item_1.setWatchSeconds(_tmpWatchSeconds);
                        String _tmp = _cursor.isNull(_cursorIndexOfStartTime) ? null : _cursor.getString(_cursorIndexOfStartTime);
                        DateTime _tmpStartTime = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _item_1.setStartTime(_tmpStartTime);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfEndTime) ? null : _cursor.getString(_cursorIndexOfEndTime);
                        DateTime _tmpEndTime = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _item_1.setEndTime(_tmpEndTime);
                        String _tmpResolution = _cursor.isNull(_cursorIndexOfResolution) ? null : _cursor.getString(_cursorIndexOfResolution);
                        _item_1.setResolution(_tmpResolution);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        _item_1.setSyncState(_tmpSyncState);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfSyncedAt) ? null : _cursor.getString(_cursorIndexOfSyncedAt);
                        DateTime _tmpSyncedAt = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _item_1.setSyncedAt(_tmpSyncedAt);
                        int _tmpRetryCount = _cursor.getInt(_cursorIndexOfRetryCount);
                        _item_1.setRetryCount(_tmpRetryCount);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _item_1.setCreatedAt(_tmpCreatedAt);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _item_1.setUpdatedAt(_tmpUpdatedAt);
                        _result.add(_item_1);
                    }
                    ArrayList<EkoStreamSessionEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    Flowable<EkoStreamSessionEntity> getByIdImpl(String sessionId) {
        String _sql = "SELECT * from stream_session where sessionId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_session where sessionId = ?", (int)1);
        int _argIndex = 1;
        if (sessionId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, sessionId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"stream_session"}, (Callable)new Callable<EkoStreamSessionEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoStreamSessionEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoStreamSessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoStreamSessionEntity _result;
                    int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
                    int _cursorIndexOfStreamId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"streamId");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfWatchSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"watchSeconds");
                    int _cursorIndexOfStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"startTime");
                    int _cursorIndexOfEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"endTime");
                    int _cursorIndexOfResolution = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resolution");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfSyncedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncedAt");
                    int _cursorIndexOfRetryCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"retryCount");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoStreamSessionEntity();
                        String _tmpSessionId = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                        _result.setSessionId(_tmpSessionId);
                        String _tmpStreamId = _cursor.isNull(_cursorIndexOfStreamId) ? null : _cursor.getString(_cursorIndexOfStreamId);
                        _result.setStreamId(_tmpStreamId);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        _result.setTitle(_tmpTitle);
                        long _tmpWatchSeconds = _cursor.getLong(_cursorIndexOfWatchSeconds);
                        _result.setWatchSeconds(_tmpWatchSeconds);
                        String _tmp = _cursor.isNull(_cursorIndexOfStartTime) ? null : _cursor.getString(_cursorIndexOfStartTime);
                        DateTime _tmpStartTime = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setStartTime(_tmpStartTime);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfEndTime) ? null : _cursor.getString(_cursorIndexOfEndTime);
                        DateTime _tmpEndTime = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setEndTime(_tmpEndTime);
                        String _tmpResolution = _cursor.isNull(_cursorIndexOfResolution) ? null : _cursor.getString(_cursorIndexOfResolution);
                        _result.setResolution(_tmpResolution);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        _result.setSyncState(_tmpSyncState);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfSyncedAt) ? null : _cursor.getString(_cursorIndexOfSyncedAt);
                        DateTime _tmpSyncedAt = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setSyncedAt(_tmpSyncedAt);
                        int _tmpRetryCount = _cursor.getInt(_cursorIndexOfRetryCount);
                        _result.setRetryCount(_tmpRetryCount);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    EkoStreamSessionEntity ekoStreamSessionEntity = _result;
                    return ekoStreamSessionEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

