/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.DataSource;
import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.amity.socialcloud.sdk.core.AmityTags;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.AmityPagingDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageTagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoTagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoMessageTag;
import io.reactivex.Flowable;
import java.util.List;

@Dao
public abstract class EkoMessageDao
extends EkoObjectDao<EkoMessageEntity>
implements AmityPagingDao<EkoMessageEntity> {
    private final EkoMessageTagDao messageTagDao = UserDatabase.get().messageTagDao();

    EkoMessageDao() {
    }

    @Deprecated
    @Query(value="SELECT count(*) from message")
    public abstract Flowable<Integer> getCount();

    @Deprecated
    @Query(value="SELECT count(*) from message where channelId = :channelId")
    public abstract Flowable<Integer> getCount(String var1);

    @Deprecated
    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = :channelId and message.messageId = message_flag.messageId and case when :isFilterByParentId and :parentId is not null then message.parentId = :parentId  when :isFilterByParentId and :parentId is null then message.parentId is null  else message.messageId is not null end and case when :isFilterByTags then message.messageId in (SELECT messageId from message_tag where tagName in (:includingTags))  else message.messageId is not null end and message.messageId not in (SELECT messageId from message_tag where tagName in (:excludingTags)) and case when :isDeleted is not null then message.isDeleted = :isDeleted else message.messageId is not null end order by channelSegment, createdAt ASC")
    abstract DataSource.Factory<Integer, EkoMessageEntity> getDataSourceImpl(String var1, boolean var2, String var3, boolean var4, String[] var5, String[] var6, Boolean var7);

    public DataSource.Factory<Integer, EkoMessageEntity> getDataSource(String channelId, boolean isFilterByParentId, String parentId, AmityTags includingTags, AmityTags excludingTags, Boolean isDeleted) {
        return this.getDataSourceImpl(channelId, isFilterByParentId, parentId, !includingTags.isEmpty(), includingTags.toArray(new String[0]), excludingTags.toArray(new String[0]), isDeleted);
    }

    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = :channelId and message.messageId = message_flag.messageId and case when :isFilterByParentId and :parentId is not null then message.parentId = :parentId  when :isFilterByParentId and :parentId is null then message.parentId is null  else message.messageId is not null end and case when :isFilterByTags then message.messageId in (SELECT messageId from message_tag where tagName in (:includingTags))  else message.messageId is not null end and message.messageId not in (SELECT messageId from message_tag where tagName in (:excludingTags)) and case when :isDeleted is not null then message.isDeleted = :isDeleted else message.messageId is not null end order by channelSegment, createdAt ASC")
    abstract PagingSource<Integer, EkoMessageEntity> getPagingSourceImpl(String var1, boolean var2, String var3, boolean var4, String[] var5, String[] var6, Boolean var7);

    public PagingSource<Integer, EkoMessageEntity> getPagingSource(String channelId, boolean isFilterByParentId, String parentId, AmityTags includingTags, AmityTags excludingTags, Boolean isDeleted) {
        return this.getPagingSourceImpl(channelId, isFilterByParentId, parentId, !includingTags.isEmpty(), includingTags.toArray(new String[0]), excludingTags.toArray(new String[0]), isDeleted);
    }

    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = :channelId and message.messageId = message_flag.messageId and message.isDeleted = case when :isDeleted is not null then :isDeleted else isDeleted end order by channelSegment DESC LIMIT 1")
    abstract Flowable<EkoMessageEntity> getLatestMessageImpl(String var1, Boolean var2);

    public Flowable<EkoMessageEntity> getLatestMessage(String channelId) {
        return this.getLatestMessageImpl(channelId, null);
    }

    public Flowable<EkoMessageEntity> getLatestMessage(String channelId, Boolean isDeleted) {
        return this.getLatestMessageImpl(channelId, isDeleted);
    }

    @Query(value="SELECT channelSegment from message where channelId = :channelId and syncState = 'synced' order by channelSegment DESC LIMIT 1")
    public abstract int getHighestChannelSegment(String var1);

    @Query(value="UPDATE message set syncState = 'failed' where syncState = 'syncing'")
    public abstract void cleanUpSyncingStateOnStartup();

    @Query(value="UPDATE message set syncState = 'failed' where syncState = 'uploading'")
    public abstract void cleanUpUploadingStateOnStartup();

    @Override
    @Query(value="DELETE from message")
    public abstract void deleteAll();

    @Query(value="DELETE from message where channelId = :channelId")
    public abstract void deleteAllFromChannel(String var1);

    @Query(value="SELECT * from message where channelId = :channelId order by createdAt DESC LIMIT -1 OFFSET :offset")
    abstract List<EkoMessageEntity> getOldMessages(String var1, int var2);

    @Transaction
    public void retainLatestFromChannel(String channelId, int offset) {
        List<EkoMessageEntity> oldMessages = this.getOldMessages(channelId, offset);
        this.delete(oldMessages);
    }

    @Query(value="DELETE from message where channelId = :channelId")
    public abstract void hardDeleteAllFromChannel(String var1);

    @Query(value="UPDATE message set isDeleted = 1, data = null where channelId = :channelId and userId = :userId")
    abstract void softDeleteFromChannelByUserIdImpl(String var1, String var2);

    @Transaction
    public void softDeleteFromChannelByUserId(String channelId, String userId) {
        this.softDeleteFromChannelByUserIdImpl(channelId, userId);
    }

    @Query(value="UPDATE message set userId = :userId where userId = :userId")
    abstract void updateUserImpl(String var1);

    @Transaction
    public void updateUser(String userId) {
        this.updateUserImpl(userId);
    }

    @Override
    @Transaction
    public void insert(EkoMessageEntity message) {
        super.insert(message);
        EkoTagDao.update(message, this.messageTagDao, EkoMessageTag::create);
    }

    @Override
    @Transaction
    public void insert(List<EkoMessageEntity> messages) {
        super.insert(messages);
        EkoTagDao.update(messages, this.messageTagDao, EkoMessageTag::create);
    }

    @Override
    @Transaction
    public void update(EkoMessageEntity message) {
        super.update(message);
        EkoTagDao.update(message, this.messageTagDao, EkoMessageTag::create);
    }

    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.messageId = :messageId and message.messageId = message_flag.messageId LIMIT 1")
    abstract Flowable<EkoMessageEntity> getByIdImpl(String var1);

    public Flowable<EkoMessageEntity> getById(String messageId) {
        return this.getByIdImpl(messageId);
    }

    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.messageId = :messageId and message.messageId = message_flag.messageId LIMIT 1")
    abstract EkoMessageEntity getByIdNowImpl(String var1);

    @Override
    public EkoMessageEntity getByIdNow(String messageId) {
        return this.getByIdNowImpl(messageId);
    }

    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.messageId IN (:messageIds) and message.messageId = message_flag.messageId")
    abstract List<EkoMessageEntity> getByIdsNowImpl(List<String> var1);

    @Override
    public List<EkoMessageEntity> getByIdsNow(List<String> ids) {
        return this.getByIdsNowImpl(ids);
    }
}

