/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.core.user.AmityFollowStatusFilter;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.FollowStatusFilterConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.FollowerQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.model.FollowerQueryToken;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class FollowerQueryTokenDao_Impl
extends FollowerQueryTokenDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<FollowerQueryToken> __insertionAdapterOfFollowerQueryToken;
    private final FollowStatusFilterConverter __followStatusFilterConverter = new FollowStatusFilterConverter();
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();

    public FollowerQueryTokenDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfFollowerQueryToken = new EntityInsertionAdapter<FollowerQueryToken>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `follower_query_token` (`userId`,`filter`,`previous`,`next`,`pageNumber`,`ids`,`updatedAt`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, FollowerQueryToken value) {
                if (value.userId == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.userId);
                }
                String _tmp = FollowerQueryTokenDao_Impl.this.__followStatusFilterConverter.amityFollowStatusQueryToString(value.getFilter());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                if (value.getPrevious() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPrevious());
                }
                if (value.getNext() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getNext());
                }
                stmt.bindLong(5, (long)value.getPageNumber());
                String _tmp_1 = FollowerQueryTokenDao_Impl.this.__stringListConverter.stringListToString(value.getIds());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                String _tmp_2 = FollowerQueryTokenDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
            }
        };
    }

    @Override
    public Completable insertToken(final FollowerQueryToken token) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                FollowerQueryTokenDao_Impl.this.__db.beginTransaction();
                try {
                    FollowerQueryTokenDao_Impl.this.__insertionAdapterOfFollowerQueryToken.insert((Object)token);
                    FollowerQueryTokenDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    FollowerQueryTokenDao_Impl.this.__db.endTransaction();
                }
            }
        });
    }

    @Override
    public Maybe<FollowerQueryToken> queryToken(SimpleSQLiteQuery query) {
        SimpleSQLiteQuery _internalQuery = query;
        return Maybe.fromCallable((Callable)new Callable<FollowerQueryToken>((SupportSQLiteQuery)_internalQuery){
            final /* synthetic */ SupportSQLiteQuery val$_internalQuery;
            {
                this.val$_internalQuery = supportSQLiteQuery;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FollowerQueryToken call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)FollowerQueryTokenDao_Impl.this.__db, (SupportSQLiteQuery)this.val$_internalQuery, (boolean)false, null);){
                    FollowerQueryToken _result = _cursor.moveToFirst() ? FollowerQueryTokenDao_Impl.this.__entityCursorConverter_comEkoappEkosdkInternalDataModelFollowerQueryToken(_cursor) : null;
                    FollowerQueryToken followerQueryToken = _result;
                    return followerQueryToken;
                }
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private FollowerQueryToken __entityCursorConverter_comEkoappEkosdkInternalDataModelFollowerQueryToken(Cursor cursor) {
        int _cursorIndexOfUserId = CursorUtil.getColumnIndex((Cursor)cursor, (String)"userId");
        int _cursorIndexOfFilter = CursorUtil.getColumnIndex((Cursor)cursor, (String)"filter");
        int _cursorIndexOfPrevious = CursorUtil.getColumnIndex((Cursor)cursor, (String)"previous");
        int _cursorIndexOfNext = CursorUtil.getColumnIndex((Cursor)cursor, (String)"next");
        int _cursorIndexOfPageNumber = CursorUtil.getColumnIndex((Cursor)cursor, (String)"pageNumber");
        int _cursorIndexOfIds = CursorUtil.getColumnIndex((Cursor)cursor, (String)"ids");
        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndex((Cursor)cursor, (String)"updatedAt");
        FollowerQueryToken _entity = new FollowerQueryToken();
        if (_cursorIndexOfUserId != -1) {
            _entity.userId = cursor.isNull(_cursorIndexOfUserId) ? null : cursor.getString(_cursorIndexOfUserId);
        }
        if (_cursorIndexOfFilter != -1) {
            String _tmp = cursor.isNull(_cursorIndexOfFilter) ? null : cursor.getString(_cursorIndexOfFilter);
            AmityFollowStatusFilter _tmpFilter = this.__followStatusFilterConverter.stringToAmityFollowStatusQuery(_tmp);
            _entity.setFilter(_tmpFilter);
        }
        if (_cursorIndexOfPrevious != -1) {
            String _tmpPrevious = cursor.isNull(_cursorIndexOfPrevious) ? null : cursor.getString(_cursorIndexOfPrevious);
            _entity.setPrevious(_tmpPrevious);
        }
        if (_cursorIndexOfNext != -1) {
            String _tmpNext = cursor.isNull(_cursorIndexOfNext) ? null : cursor.getString(_cursorIndexOfNext);
            _entity.setNext(_tmpNext);
        }
        if (_cursorIndexOfPageNumber != -1) {
            int _tmpPageNumber = cursor.getInt(_cursorIndexOfPageNumber);
            _entity.setPageNumber(_tmpPageNumber);
        }
        if (_cursorIndexOfIds != -1) {
            String _tmp_1 = cursor.isNull(_cursorIndexOfIds) ? null : cursor.getString(_cursorIndexOfIds);
            List<String> _tmpIds = this.__stringListConverter.stringToStringList(_tmp_1);
            _entity.setIds(_tmpIds);
        }
        if (_cursorIndexOfUpdatedAt != -1) {
            String _tmp_2 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
            DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
            _entity.setUpdatedAt(_tmpUpdatedAt);
        }
        return _entity;
    }
}

