/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data;

import android.content.Context;
import androidx.room.Database;
import androidx.room.TypeConverters;
import com.amity.socialcloud.sdk.core.encryption.AmityDBEncryption;
import com.amity.socialcloud.sdk.infra.db.DBEncryptionUtils;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.BaseRoomDatabase;
import com.ekoapp.ekosdk.internal.data.converter.EkoPushConfigStateConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoAccountDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoApiKeyDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoBaiduTokenDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoFcmTokenDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoHttpUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMqttUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoPushConfigDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoSocketUrlDao;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoBaiduToken;
import com.ekoapp.ekosdk.internal.data.model.EkoFcmToken;
import com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoMqttUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoPushConfig;
import com.ekoapp.ekosdk.internal.data.model.EkoSocketUrl;
import java.io.File;

@Database(version=9, entities={EkoAccount.class, EkoApiKey.class, EkoFcmToken.class, EkoBaiduToken.class, EkoPushConfig.class, EkoHttpUrl.class, EkoSocketUrl.class, EkoMqttUrl.class})
@TypeConverters(value={EkoPushConfigStateConverter.class, DateTimeTypeConverter.class})
public abstract class EkoDatabase
extends BaseRoomDatabase {
    private static EkoDatabase ekoDatabase;
    private static final String AUTH_DB_NAME = "eko";

    public static synchronized void init(Context context, AmityDBEncryption dbEncryption) {
        File dbFile = context.getDatabasePath(AUTH_DB_NAME);
        DBEncryptionUtils.State state = DBEncryptionUtils.INSTANCE.getDatabaseState(context, dbFile);
        if (dbEncryption instanceof AmityDBEncryption.AUTH || dbEncryption instanceof AmityDBEncryption.ALL) {
            if (state == DBEncryptionUtils.State.ENCRYPTED) {
                boolean hasCorrectPassPhrase = DBEncryptionUtils.INSTANCE.isPassPhraseCorrect(context, dbFile, dbEncryption.getAuthDBKey());
                if (!hasCorrectPassPhrase) {
                    AmityLog.INSTANCE.tag("amityEncryption").d("re-creating auth file with new key", new Object[0]);
                    dbFile.delete();
                }
            } else if (state == DBEncryptionUtils.State.UNENCRYPTED) {
                AmityLog.INSTANCE.tag("amityEncryption").d("re-creating auth file with encryption", new Object[0]);
                DBEncryptionUtils.INSTANCE.encrypt(context, dbFile, dbEncryption.getAuthDBKey());
            }
        } else if (state == DBEncryptionUtils.State.ENCRYPTED) {
            AmityLog.INSTANCE.tag("amityEncryption").d("re-creating auth file without encryption", new Object[0]);
            dbFile.delete();
        }
        ekoDatabase = BaseRoomDatabase.init(context, EkoDatabase.class, AUTH_DB_NAME, ekoDatabase, true, dbEncryption.getAuthDBKey());
    }

    public static EkoDatabase get() {
        return ekoDatabase;
    }

    public abstract EkoHttpUrlDao httpUrlDao();

    public abstract EkoSocketUrlDao socketUrlDao();

    public abstract EkoMqttUrlDao mqttUrlDao();

    public abstract EkoApiKeyDao apiKeyDao();

    public abstract EkoAccountDao accountDao();

    public abstract EkoFcmTokenDao fcmTokenDao();

    public abstract EkoBaiduTokenDao baiduTokenDao();

    public abstract EkoPushConfigDao pushConfigDao();
}

