/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.channel.reader;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipRepository;
import com.amity.socialcloud.sdk.chat.data.channel.reader.ChannelReaderLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.channel.reader.ChannelReaderRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.ekoapp.ekosdk.EkoChannelExtra;
import com.ekoapp.ekosdk.EkoChannelReadStatus;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import com.google.common.base.Objects;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/channel/reader/ChannelReaderRepository;", "", "()V", "getUnreadCountInfo", "Lkotlin/Pair;", "", "", "channelId", "", "messageCount", "startReading", "", "stopReading", "amity-sdk_release"})
public final class ChannelReaderRepository {
    public final void startReading(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        ChannelReaderLocalDataStore localDataStore = new ChannelReaderLocalDataStore();
        Completable startReading = localDataStore.startReading(channelId).concatWith((CompletableSource)new ChannelReaderRemoteDataStore().startReading(channelId));
        localDataStore.observeChannelReader(channelId).firstElement().filter(ChannelReaderRepository::startReading$lambda-0).flatMapCompletable(arg_0 -> ChannelReaderRepository.startReading$lambda-1(startReading, arg_0)).onErrorResumeNext(arg_0 -> ChannelReaderRepository.startReading$lambda-2(channelId, arg_0)).subscribeOn(Schedulers.io()).subscribe();
    }

    public final void stopReading(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        ChannelReaderLocalDataStore localDataStore = new ChannelReaderLocalDataStore();
        Completable stopReading = localDataStore.stopReading(channelId).concatWith((CompletableSource)new ChannelReaderRemoteDataStore().stopReading(channelId));
        localDataStore.observeChannelReader(channelId).firstElement().filter(ChannelReaderRepository::stopReading$lambda-3).flatMapCompletable(arg_0 -> ChannelReaderRepository.stopReading$lambda-4(stopReading, arg_0)).subscribeOn(Schedulers.io()).subscribe();
    }

    @NotNull
    public final Pair<Integer, Boolean> getUnreadCountInfo(@NotNull String channelId, int messageCount) {
        EkoChannelExtra channelReader;
        ChannelMembershipEntity channelMember;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        String myUserId = new SessionLocalDataStore().getActiveUserId();
        ChannelMembershipEntity channelMembershipEntity = channelMember = new ChannelMembershipLocalDataStore().getChannelMember(channelId, myUserId);
        int channelReadToSegment = channelMembershipEntity != null ? channelMembershipEntity.getReadToSegment() : 0;
        ChannelMembershipEntity channelMembershipEntity2 = channelMember;
        int channelLastMentionedSegment = channelMembershipEntity2 != null ? channelMembershipEntity2.getLastMentionedSegment() : 0;
        EkoChannelExtra ekoChannelExtra = channelReader = new ChannelReaderLocalDataStore().getChannelReader(channelId);
        int localReadToSegment = ekoChannelExtra != null ? ekoChannelExtra.getLocalReadToSegment() : 0;
        EkoChannelExtra ekoChannelExtra2 = channelReader;
        int localLastMentionedSegment = ekoChannelExtra2 != null ? ekoChannelExtra2.getLocalLastMentionedSegment() : 0;
        int computedUnreadCount = Math.max(0, messageCount - Math.max(channelReadToSegment, localReadToSegment));
        int readToSegment = Math.max(channelReadToSegment, localReadToSegment);
        int lastMentionedSegment = Math.max(channelLastMentionedSegment, localLastMentionedSegment);
        boolean hasUnreadMention = readToSegment < lastMentionedSegment;
        return new Pair((Object)computedUnreadCount, (Object)hasUnreadMention);
    }

    private static final boolean startReading$lambda-0(EkoChannelExtra it) {
        return !Objects.equal((Object)((Object)EkoChannelReadStatus.READING), (Object)((Object)it.getReadStatus()));
    }

    private static final CompletableSource startReading$lambda-1(Completable $startReading, EkoChannelExtra it) {
        return (CompletableSource)$startReading;
    }

    private static final CompletableSource startReading$lambda-2(String $channelId, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$channelId, (String)"$channelId");
        return AmityError.USER_IS_BANNED == AmityError.Companion.from(it) ? (CompletableSource)new ChannelMembershipRepository().handleMembershipBanned($channelId, AmityCoreClient.INSTANCE.getUserId()).andThen((CompletableSource)Completable.error((Throwable)it)) : (CompletableSource)Completable.error((Throwable)it);
    }

    private static final boolean stopReading$lambda-3(EkoChannelExtra it) {
        return !Objects.equal((Object)((Object)EkoChannelReadStatus.NOT_READING), (Object)((Object)it.getReadStatus()));
    }

    private static final CompletableSource stopReading$lambda-4(Completable $stopReading, EkoChannelExtra it) {
        return (CompletableSource)$stopReading;
    }
}

