/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk;

import com.amity.socialcloud.sdk.AmityEndpoint;
import com.amity.socialcloud.sdk.core.AmityConnectionState;
import com.amity.socialcloud.sdk.core.AmityGlobalBanEvent;
import com.amity.socialcloud.sdk.core.authen.UserRegistration;
import com.amity.socialcloud.sdk.core.domain.notification.RegisterDeviceForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.notification.UnregisterAllUsersForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.notification.UnregisterDeviceForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.session.ActiveUserIdGetUseCase;
import com.amity.socialcloud.sdk.core.domain.session.LogoutUseCase;
import com.amity.socialcloud.sdk.core.encryption.AmityDBEncryption;
import com.amity.socialcloud.sdk.core.events.AmityTopic;
import com.amity.socialcloud.sdk.core.events.AmityTopicSubscription;
import com.amity.socialcloud.sdk.core.file.AmityFileRepository;
import com.amity.socialcloud.sdk.core.permission.AmityPermission;
import com.amity.socialcloud.sdk.core.permission.AmityPermissionValidator;
import com.amity.socialcloud.sdk.core.session.SessionError;
import com.amity.socialcloud.sdk.core.session.SessionHandler;
import com.amity.socialcloud.sdk.core.session.SessionStateManager;
import com.amity.socialcloud.sdk.core.session.component.TokenRenewalSessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.core.user.AmityUser;
import com.amity.socialcloud.sdk.core.user.AmityUserNotification;
import com.amity.socialcloud.sdk.core.user.AmityUserRepository;
import com.amity.socialcloud.sdk.core.user.AmityUserUpdate;
import com.amity.socialcloud.sdk.infra.CoreClient;
import com.amity.socialcloud.sdk.infra.mqtt.AmityMqttClient;
import com.amity.socialcloud.sdk.streamapi.AmityClientConfiguration;
import com.amity.socialcloud.sdk.streamapi.StreamFunctionInterface;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.AmityContentCheck;
import com.ekoapp.ekosdk.StreamFunction;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.usecase.content.GetContentCheckUseCase;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0007J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0006\u0010\u0015\u001a\u00020\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0010J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0010J\r\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0006\u0010\u001e\u001a\u00020\fJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\fH\u0007J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\f2\b\u0010&\u001a\u0004\u0018\u00010'J\u0006\u0010(\u001a\u00020\nJ\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020.J\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00160\u0010J\u0006\u00100\u001a\u00020\nJ\u000e\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\fJ\"\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\f2\b\b\u0002\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u000206J \u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\f2\u0006\u00107\u001a\u00020\f2\u0006\u00108\u001a\u00020\fH\u0007J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u0006\u0010=\u001a\u00020\nJ\u000e\u0010=\u001a\u00020\n2\u0006\u0010%\u001a\u00020\fJ\u0006\u0010>\u001a\u00020?R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006@"}, d2={"Lcom/amity/socialcloud/sdk/AmityCoreClient;", "", "()V", "millisTimeDiff", "", "getMillisTimeDiff$amity_sdk_release", "()I", "setMillisTimeDiff$amity_sdk_release", "(I)V", "disconnect", "Lio/reactivex/Completable;", "getAmityCoreSdkVersion", "", "getConfiguration", "Lcom/amity/socialcloud/sdk/streamapi/AmityClientConfiguration;", "getConnectionState", "Lio/reactivex/Flowable;", "Lcom/amity/socialcloud/sdk/core/AmityConnectionState;", "getContentCheck", "Lio/reactivex/Single;", "Lcom/ekoapp/ekosdk/AmityContentCheck;", "getCurrentSessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "getCurrentUser", "Lcom/amity/socialcloud/sdk/core/user/AmityUser;", "getGlobalBanEvents", "Lcom/amity/socialcloud/sdk/core/AmityGlobalBanEvent;", "getServerTime", "Lorg/joda/time/DateTime;", "getServerTime$amity_sdk_release", "getUserId", "hasPermission", "Lcom/amity/socialcloud/sdk/core/permission/AmityPermissionValidator;", "permission", "Lcom/amity/socialcloud/sdk/core/permission/AmityPermission;", "login", "Lcom/amity/socialcloud/sdk/core/authen/UserRegistration$Builder;", "userId", "sessionHandler", "Lcom/amity/socialcloud/sdk/core/session/SessionHandler;", "logout", "newFileRepository", "Lcom/amity/socialcloud/sdk/core/file/AmityFileRepository;", "newUserRepository", "Lcom/amity/socialcloud/sdk/core/user/AmityUserRepository;", "notification", "Lcom/amity/socialcloud/sdk/core/user/AmityUserNotification;", "observeSessionState", "registerDeviceForPushNotification", "setup", "apiKey", "endpoint", "Lcom/amity/socialcloud/sdk/AmityEndpoint;", "dbEncryption", "Lcom/amity/socialcloud/sdk/core/encryption/AmityDBEncryption;", "httpEndpoint", "socketEndpoint", "subscription", "Lcom/amity/socialcloud/sdk/core/events/AmityTopicSubscription;", "topic", "Lcom/amity/socialcloud/sdk/core/events/AmityTopic;", "unregisterDeviceForPushNotification", "updateUser", "Lcom/amity/socialcloud/sdk/core/user/AmityUserUpdate$Builder;", "amity-sdk_release"})
public final class AmityCoreClient {
    @NotNull
    public static final AmityCoreClient INSTANCE = new AmityCoreClient();
    private static int millisTimeDiff;

    private AmityCoreClient() {
    }

    public final int getMillisTimeDiff$amity_sdk_release() {
        return millisTimeDiff;
    }

    public final void setMillisTimeDiff$amity_sdk_release(int n) {
        millisTimeDiff = n;
    }

    @NotNull
    public final DateTime getServerTime$amity_sdk_release() {
        DateTime dateTime = DateTime.now().plusMillis(millisTimeDiff);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now().plusMillis(millisTimeDiff)");
        return dateTime;
    }

    @NotNull
    public final SessionState getCurrentSessionState() {
        SessionStateManager sessionStateManager = CoreClient.INSTANCE.getSessionStateManager$amity_sdk_release();
        Intrinsics.checkNotNull((Object)sessionStateManager);
        return sessionStateManager.getSessionState();
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey, @NotNull AmityEndpoint endpoint, @NotNull AmityDBEncryption dbEncryption) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)dbEncryption, (String)"dbEncryption");
        return CoreClient.INSTANCE.setup(apiKey, endpoint, dbEncryption);
    }

    public static /* synthetic */ Completable setup$default(AmityCoreClient amityCoreClient, String string, AmityEndpoint amityEndpoint, AmityDBEncryption amityDBEncryption, int n, Object object) {
        if ((n & 2) != 0) {
            amityEndpoint = AmityEndpoint.SG.INSTANCE;
        }
        if ((n & 4) != 0) {
            amityDBEncryption = AmityDBEncryption.NONE.INSTANCE;
        }
        return amityCoreClient.setup(string, amityEndpoint, amityDBEncryption);
    }

    @Deprecated(message="please use setup(apiKey: String, endpoint: AmityEndpoint) instead")
    @NotNull
    public final Completable setup(@NotNull String apiKey, @NotNull String httpEndpoint, @NotNull String socketEndpoint) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)httpEndpoint, (String)"httpEndpoint");
        Intrinsics.checkNotNullParameter((Object)socketEndpoint, (String)"socketEndpoint");
        String string = httpEndpoint;
        String mqttEndpoint = Intrinsics.areEqual((Object)string, (Object)"https://apix.eu.amity.co/") ? "ssq.eu.amity.co" : (Intrinsics.areEqual((Object)string, (Object)"https://apix.us.amity.co/") ? "ssq.us.amity.co" : "ssq.sg.amity.co");
        return AmityCoreClient.setup$default(this, apiKey, new AmityEndpoint.CUSTOM(httpEndpoint, socketEndpoint, mqttEndpoint), null, 4, null);
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return AmityCoreClient.setup$default(this, apiKey, AmityEndpoint.SG.INSTANCE, null, 4, null);
    }

    @NotNull
    public final Completable registerDeviceForPushNotification() {
        return RxJava3BridgeExtensionsKt.toV2(new RegisterDeviceForNotificationUseCase().execute());
    }

    @NotNull
    public final Completable unregisterDeviceForPushNotification() {
        return RxJava3BridgeExtensionsKt.toV2(new UnregisterAllUsersForNotificationUseCase().execute());
    }

    @NotNull
    public final Completable unregisterDeviceForPushNotification(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return RxJava3BridgeExtensionsKt.toV2(new UnregisterDeviceForNotificationUseCase().execute(userId));
    }

    @NotNull
    public final Completable disconnect() {
        Completable completable;
        if (CoreClient.INSTANCE.getMqttClient$amity_sdk_release() == null || CoreClient.INSTANCE.getSocketClient$amity_sdk_release() == null) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n            Completable.complete()\n        }");
        } else {
            EkoSocket ekoSocket = CoreClient.INSTANCE.getSocketClient$amity_sdk_release();
            if (ekoSocket != null) {
                ekoSocket.disconnect();
            }
            AmityMqttClient amityMqttClient = CoreClient.INSTANCE.getMqttClient$amity_sdk_release();
            Intrinsics.checkNotNull((Object)amityMqttClient);
            completable = amityMqttClient.disconnect();
        }
        return completable;
    }

    @Deprecated(message="Please use login function with sessionHandler instead", replaceWith=@ReplaceWith(expression="login(userId = userId, sessionHandler = sessionHandler)", imports={"com.amity.socialcloud.sdk.AmityCoreClient.login"}))
    @NotNull
    public final UserRegistration.Builder login(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.login(userId, null);
    }

    @NotNull
    public final UserRegistration.Builder login(@NotNull String userId, @Nullable SessionHandler sessionHandler) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        boolean isLegacyVersion = sessionHandler == null;
        SessionState currentSessionState = this.getCurrentSessionState();
        if (currentSessionState instanceof SessionState.Establishing) {
            throw SessionError.INSTANCE.fromState(currentSessionState);
        }
        SessionHandler sessionHandler2 = sessionHandler;
        if (sessionHandler2 != null) {
            SessionHandler it = sessionHandler2;
            boolean bl = false;
            TokenRenewalSessionComponent tokenRenewalSessionComponent = CoreClient.INSTANCE.getRenewalManager$amity_sdk_release();
            if (tokenRenewalSessionComponent != null) {
                tokenRenewalSessionComponent.setSessionHandler(it);
            }
        }
        AppEventBus appEventBus = CoreClient.INSTANCE.getAppEventBus$amity_sdk_release();
        Intrinsics.checkNotNull((Object)appEventBus);
        SessionLifeCycleEventBus sessionLifeCycleEventBus = CoreClient.INSTANCE.getSessionLifeCycleEventBus$amity_sdk_release();
        Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus);
        return new UserRegistration.Builder(appEventBus, sessionLifeCycleEventBus, userId, isLegacyVersion);
    }

    @NotNull
    public final Completable logout() {
        AppEventBus appEventBus = CoreClient.INSTANCE.getAppEventBus$amity_sdk_release();
        Intrinsics.checkNotNull((Object)appEventBus);
        appEventBus.publish(AppEvent.ManualLogout.INSTANCE);
        return RxJava3BridgeExtensionsKt.toV2(new LogoutUseCase().execute());
    }

    @NotNull
    public final String getUserId() {
        return new ActiveUserIdGetUseCase().execute();
    }

    @NotNull
    public final AmityUserUpdate.Builder updateUser() {
        return new AmityUserUpdate.Builder(this.getUserId());
    }

    @NotNull
    public final AmityPermissionValidator hasPermission(@NotNull AmityPermission permission) {
        Intrinsics.checkNotNullParameter((Object)((Object)permission), (String)"permission");
        return new AmityPermissionValidator(permission);
    }

    @NotNull
    public final Flowable<AmityUser> getCurrentUser() {
        return this.newUserRepository().getCurrentUser();
    }

    @NotNull
    public final AmityUserRepository newUserRepository() {
        return new AmityUserRepository();
    }

    @NotNull
    public final AmityFileRepository newFileRepository() {
        return new AmityFileRepository();
    }

    @NotNull
    public final String getAmityCoreSdkVersion() {
        return "5.35.5";
    }

    @NotNull
    public final Flowable<AmityGlobalBanEvent> getGlobalBanEvents() {
        return EkoSocket.Companion.getGlobalBanEvents();
    }

    @NotNull
    public final AmityUserNotification notification() {
        return new AmityUserNotification();
    }

    @NotNull
    public final AmityClientConfiguration getConfiguration() {
        return new AmityClientConfiguration((StreamFunctionInterface)new StreamFunction());
    }

    @Deprecated(message="Please use observeSessionState instead")
    @NotNull
    public final Flowable<AmityConnectionState> getConnectionState() {
        return EkoSocket.Companion.getConnectionState();
    }

    @NotNull
    public final AmityTopicSubscription subscription(@NotNull AmityTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return new AmityTopicSubscription(topic);
    }

    @NotNull
    public final Single<AmityContentCheck> getContentCheck() {
        return new GetContentCheckUseCase().execute();
    }

    @NotNull
    public final Flowable<SessionState> observeSessionState() {
        return CoreClient.INSTANCE.observeSessionState();
    }
}

