/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository;
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoPostMapper;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoPostFlagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.model.EkoPostFlag;
import com.google.common.collect.FluentIterable;
import java.util.List;

class EkoPostListPersister
extends EkoObjectPersister {
    EkoPostListPersister() {
    }

    static void persist(List<EkoPostDto> dtoList) {
        UserDatabase userDatabase = UserDatabase.get();
        userDatabase.runInTransaction(() -> {
            EkoPostListPersister.persistChanges(dtoList, EkoPostMapper.MAPPER, userDatabase.postDao());
            for (EkoPostDto postDto : dtoList) {
                if (postDto.getMyReactions() != null) {
                    EkoReactionDao reactionDao = userDatabase.reactionDao();
                    reactionDao.deleteByReferenceIdAndUserId(postDto.getPostId(), ReactionReferenceType.POST.getValue(), AmityCoreClient.INSTANCE.getUserId());
                    reactionDao.insert(FluentIterable.from(postDto.getMyReactions()).transform(reactionName -> new ReactionRepository().createMyReaction(ReactionReferenceType.POST, postDto.getPostId(), (String)reactionName)).toList());
                }
                EkoPostFlagDao flagDao = userDatabase.postFlagDao();
                EkoPostFlag postFlag = new EkoPostFlag();
                postFlag.setPostId(postDto.getPostId());
                postFlag.setFlag(postDto.getFlag());
                EkoPostFlag diskFlag = flagDao.getByIdNow(postDto.getPostId());
                if (diskFlag != null) {
                    postFlag.setLocalFlag(diskFlag.getLocalFlag());
                    flagDao.update(postFlag);
                    continue;
                }
                flagDao.insert(postFlag);
            }
        });
    }
}

