/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api;

import android.util.Log;
import com.amity.socialcloud.sdk.core.AmityConnectionState;
import com.amity.socialcloud.sdk.core.AmityGlobalBanEvent;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.amity.socialcloud.sdk.core.error.AmityException;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.socket.AmitySocketException;
import com.amity.socialcloud.sdk.socket.model.SocketRequest;
import com.amity.socialcloud.sdk.socket.model.SocketResponse;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.EkoChannelReadStatus;
import com.ekoapp.ekosdk.internal.api.EkoEndpoint;
import com.ekoapp.ekosdk.internal.api.SocketConnectionEvent;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidAddUsersListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidBanListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidCreateListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidDeleteListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidJoinListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidLeaveListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidMarkSeenListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidRemoveUsersListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidUnbanListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidUpdateListener;
import com.ekoapp.ekosdk.internal.api.event.MessageDidCreateListener;
import com.ekoapp.ekosdk.internal.api.event.MessageDidDeleteListener;
import com.ekoapp.ekosdk.internal.api.event.MessageDidUpdateListener;
import com.ekoapp.ekosdk.internal.api.event.SocketEventListener;
import com.ekoapp.ekosdk.internal.api.event.StreamDidStartListener;
import com.ekoapp.ekosdk.internal.api.event.StreamDidStopListener;
import com.ekoapp.ekosdk.internal.api.event.UserDidUpdateListener;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.request.ChannelStartReadingsRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelExtraDao;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.util.RxEko;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jakewharton.rxrelay2.BehaviorRelay;
import hu.akarnokd.rxjava3.bridge.RxJavaBridge;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.SingleSubject;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import timber.log.Timber;

@Deprecated(message="")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/ekoapp/ekosdk/internal/api/EkoSocket;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "destroy", "", "disconnect", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "handleTokenExpire", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "terminateSocket", "Companion", "amity-sdk_release"})
public final class EkoSocket
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String TAG = EkoSocket.class.getName();
    @NotNull
    private static final Socket PROXY = new Socket(null, null, null);
    @NotNull
    private static final AtomicInteger rpcId = new AtomicInteger(0);
    private static EkoAccount currentAccount = EkoAccount.create("seed");
    @NotNull
    private static Socket currentSocket = PROXY;
    @NotNull
    private static Dispatcher currentDispatcher = new Dispatcher();
    private static final BehaviorRelay<SocketConnectionEvent> connectionEventRelay = BehaviorRelay.create();
    @NotNull
    private static final PublishSubject<AmityGlobalBanEvent> globalBanEventPublisher;
    private static SessionStateEventBus companionSessionStateEventBus;

    public EkoSocket(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        companionSessionStateEventBus = this.getSessionStateEventBus();
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.terminateSocket();
        currentSocket = EkoSocket.Companion.init(account);
        currentSocket.connect();
    }

    @Override
    public void destroy() {
        this.terminateSocket();
    }

    @Override
    public void handleTokenExpire() {
        this.terminateSocket();
    }

    public final void disconnect() {
        this.terminateSocket();
    }

    private final void terminateSocket() {
        if (currentSocket.connected()) {
            currentSocket.disconnect();
        }
        currentDispatcher.executorService().shutdown();
        String socketHash = Integer.toHexString(currentSocket.hashCode());
        Log.e((String)"socket", (String)("terminate socket: " + socketHash));
    }

    @JvmStatic
    @NotNull
    public static final Flowable<SocketConnectionEvent> connectionEvent() {
        return Companion.connectionEvent();
    }

    @JvmStatic
    @NotNull
    public static final <T> Single<T> call(@NotNull Call<T> call) {
        return Companion.call(call);
    }

    static {
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)publishSubject, (String)"create<AmityGlobalBanEvent>()");
        globalBanEventPublisher = publishSubject;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0000\u0010 2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0!H\u0007J\b\u0010\"\u001a\u00020#H\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0007J0\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00062\b\u0010)\u001a\u0004\u0018\u00010\u00012\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002J\u0010\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0013H\u0002J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020,0\u001f2\u0006\u00100\u001a\u000201J\"\u0010/\u001a\b\u0012\u0004\u0012\u00020,0\u001f2\u0006\u0010(\u001a\u00020\u00062\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u0001H\u0007J\u0018\u00102\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u00103\u001a\u000204H\u0002J&\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00062\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\f0\f \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\f0\f\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n \u0007*\u0004\u0018\u00010\u00130\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00190\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/ekoapp/ekosdk/internal/api/EkoSocket$Companion;", "", "()V", "PROXY", "Lio/socket/client/Socket;", "TAG", "", "kotlin.jvm.PlatformType", "companionSessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "connectionEventRelay", "Lcom/jakewharton/rxrelay2/BehaviorRelay;", "Lcom/ekoapp/ekosdk/internal/api/SocketConnectionEvent;", "connectionState", "Lio/reactivex/Flowable;", "Lcom/amity/socialcloud/sdk/core/AmityConnectionState;", "getConnectionState", "()Lio/reactivex/Flowable;", "currentAccount", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "currentDispatcher", "Lokhttp3/Dispatcher;", "currentSocket", "globalBanEventPublisher", "Lio/reactivex/subjects/PublishSubject;", "Lcom/amity/socialcloud/sdk/core/AmityGlobalBanEvent;", "globalBanEvents", "getGlobalBanEvents", "rpcId", "Ljava/util/concurrent/atomic/AtomicInteger;", "call", "Lio/reactivex/Single;", "T", "Lcom/ekoapp/ekosdk/internal/api/socket/call/Call;", "callStartReadingOnAllChannelsWithReadingStatus", "Lio/reactivex/Completable;", "connectionEvent", "emit", "", "socket", "method", "parameter", "responseSubject", "Lio/reactivex/subjects/SingleSubject;", "Lcom/amity/socialcloud/sdk/socket/model/SocketResponse;", "init", "account", "rpc", "request", "Lcom/amity/socialcloud/sdk/socket/model/SocketRequest;", "subscribeSocketEvent", "listener", "Lcom/ekoapp/ekosdk/internal/api/event/SocketEventListener;", "wrapConnectionError", "socketio", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Socket init(EkoAccount account) throws URISyntaxException {
            currentDispatcher = new Dispatcher();
            currentAccount = account;
            String string = account.getUserId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"account.userId");
            String userId = string;
            String authority = EkoEndpoint.INSTANCE.getSocketUrl();
            Object[] objectArray = new Object[]{userId, authority};
            Timber.tag((String)TAG).i("init new socket for: %s , url: %s", objectArray);
            OkHttpClient okHttpClient = new OkHttpClient.Builder().dispatcher(currentDispatcher).readTimeout(1L, TimeUnit.MINUTES).build();
            IO.Options options = new IO.Options();
            options.callFactory = (Call.Factory)okHttpClient;
            options.webSocketFactory = (WebSocket.Factory)okHttpClient;
            options.reconnectionDelayMax = 10000L;
            String[] stringArray = new String[]{"websocket"};
            options.transports = stringArray;
            String string2 = "token=%s";
            Object[] objectArray2 = new Object[]{account.getAccessToken()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            options.query = string3;
            Socket socket = IO.socket((String)authority, (IO.Options)options);
            ImmutableSet immutableSet = ImmutableSet.builder().add((Object)"connect").add((Object)"connect_error").add((Object)"connect_timeout").add((Object)"connecting").add((Object)"disconnect").add((Object)"error").add((Object)"reconnect").add((Object)"reconnect_attempt").add((Object)"reconnect_failed").add((Object)"reconnecting").add((Object)"ping").add((Object)"pong").add((Object)"message").build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"builder<String>()\n      \u2026\n                .build()");
            Set events = (Set)immutableSet;
            for (String event : events) {
                socket.on(event, arg_0 -> Companion.init$lambda-0(socket, userId, event, arg_0));
            }
            socket.on("disconnect", arg_0 -> Companion.init$lambda-1(socket, arg_0));
            socket.on("error", arg_0 -> Companion.init$lambda-2(userId, arg_0));
            Completable.fromAction(Companion::init$lambda-3).doOnComplete(() -> Companion.init$lambda-5(socket)).subscribeOn(Schedulers.io()).subscribe();
            Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"socket");
            this.subscribeSocketEvent(socket, new ChannelDidBanListener());
            this.subscribeSocketEvent(socket, new ChannelDidCreateListener());
            this.subscribeSocketEvent(socket, new ChannelDidJoinListener());
            this.subscribeSocketEvent(socket, new ChannelDidLeaveListener());
            this.subscribeSocketEvent(socket, new ChannelDidMarkSeenListener());
            this.subscribeSocketEvent(socket, new ChannelDidUnbanListener());
            this.subscribeSocketEvent(socket, new ChannelDidUpdateListener());
            this.subscribeSocketEvent(socket, new ChannelDidAddUsersListener());
            this.subscribeSocketEvent(socket, new ChannelDidRemoveUsersListener());
            this.subscribeSocketEvent(socket, new ChannelDidDeleteListener());
            this.subscribeSocketEvent(socket, new MessageDidCreateListener());
            this.subscribeSocketEvent(socket, new MessageDidDeleteListener());
            this.subscribeSocketEvent(socket, new MessageDidUpdateListener());
            this.subscribeSocketEvent(socket, new UserDidUpdateListener());
            this.subscribeSocketEvent(socket, new StreamDidStartListener());
            this.subscribeSocketEvent(socket, new StreamDidStopListener());
            return socket;
        }

        private final Completable callStartReadingOnAllChannelsWithReadingStatus() {
            EkoChannelExtraDao extraDao = UserDatabase.get().channelExtraDao();
            Completable completable = RxJavaBridge.toV2Single(extraDao.getAllIdsByReadStatus(EkoChannelReadStatus.READING)).filter(Companion::callStartReadingOnAllChannelsWithReadingStatus$lambda-6).flatMapCompletable(Companion::callStartReadingOnAllChannelsWithReadingStatus$lambda-7);
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"toV2Single(extraDao.getA\u2026ement()\n                }");
            return completable;
        }

        private final void subscribeSocketEvent(Socket socket, SocketEventListener listener) {
            socket.on(listener.getEvent(), (Emitter.Listener)listener);
        }

        @JvmStatic
        @NotNull
        public final Flowable<SocketConnectionEvent> connectionEvent() {
            Flowable flowable = connectionEventRelay.toFlowable(BackpressureStrategy.BUFFER);
            Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"connectionEventRelay.toF\u2026kpressureStrategy.BUFFER)");
            return flowable;
        }

        @NotNull
        public final Flowable<AmityConnectionState> getConnectionState() {
            Flowable flowable = this.connectionEvent().map(Companion::_get_connectionState_$lambda-8).filter(Companion::_get_connectionState_$lambda-9).distinctUntilChanged();
            Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"connectionEvent()\n      \u2026  .distinctUntilChanged()");
            return flowable;
        }

        @JvmStatic
        @NotNull
        public final <T> Single<T> call(@NotNull Call<T> call) {
            Intrinsics.checkNotNullParameter(call, (String)"call");
            SingleSubject singleSubject = SingleSubject.create();
            Intrinsics.checkNotNullExpressionValue((Object)singleSubject, (String)"create<T>()");
            SingleSubject subject = singleSubject;
            SocketRequest socketRequest = call.getRequest();
            Intrinsics.checkNotNullExpressionValue((Object)socketRequest, (String)"call.request");
            this.rpc(socketRequest).map(arg_0 -> Companion.call$lambda-10(call, arg_0)).subscribe((SingleObserver)subject);
            Single single = subject.hide();
            Intrinsics.checkNotNullExpressionValue((Object)single, (String)"subject.hide()");
            return single;
        }

        @NotNull
        public final Flowable<AmityGlobalBanEvent> getGlobalBanEvents() {
            Flowable flowable = globalBanEventPublisher.toFlowable(BackpressureStrategy.BUFFER);
            Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"globalBanEventPublisher.\u2026kpressureStrategy.BUFFER)");
            return flowable;
        }

        @NotNull
        public final Single<SocketResponse> rpc(@NotNull SocketRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            String string = request.method();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.method()");
            return this.rpc(string, request);
        }

        @JvmOverloads
        @NotNull
        public final Single<SocketResponse> rpc(@NotNull String method, @Nullable Object parameter) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            SingleSubject singleSubject = SingleSubject.create();
            Intrinsics.checkNotNullExpressionValue((Object)singleSubject, (String)"create<SocketResponse>()");
            SingleSubject responseSubject = singleSubject;
            String json = EkoGson.get().toJson(parameter);
            JSONObject orgJson = new JSONObject(json);
            this.wrapConnectionError(currentSocket, method, (SingleSubject<SocketResponse>)responseSubject);
            if (currentSocket.connected()) {
                this.emit(currentSocket, method, orgJson, (SingleSubject<SocketResponse>)responseSubject);
            } else {
                currentSocket.once("connect", arg_0 -> Companion.rpc$lambda-11(method, orgJson, responseSubject, arg_0));
                Object[] objectArray = new Object[]{method, orgJson};
                Timber.tag((String)TAG).w("rpc: reschedule: %s parameter: %s", objectArray);
            }
            Single single = responseSubject.doOnError(RxEko.CATCH_UNAUTHORIZED_ERROR_CONSUMER).hide();
            Intrinsics.checkNotNullExpressionValue((Object)single, (String)"responseSubject.doOnErro\u2026ED_ERROR_CONSUMER).hide()");
            return single;
        }

        public static /* synthetic */ Single rpc$default(Companion companion, String string, Object object, int n, Object object2) {
            if ((n & 2) != 0) {
                object = null;
            }
            return companion.rpc(string, object);
        }

        private final void wrapConnectionError(Socket socketio, String method, SingleSubject<SocketResponse> responseSubject) {
            String[] stringArray = new String[]{"connect_error", "error"};
            for (String errorEvent : stringArray) {
                socketio.once(errorEvent, arg_0 -> Companion.wrapConnectionError$lambda-12(errorEvent, responseSubject, method, arg_0));
            }
        }

        private final void emit(Socket socket, String method, Object parameter, SingleSubject<SocketResponse> responseSubject) {
            int rpcId = rpcId.getAndIncrement();
            Object[] objectArray = new Object[]{method, rpcId, parameter};
            Timber.tag((String)TAG).i("rpc: %s [%s] parameter: %s", objectArray);
            objectArray = new Object[]{parameter, arg_0 -> Companion.emit$lambda-13(method, rpcId, responseSubject, arg_0)};
            socket.emit(method, objectArray);
        }

        @JvmOverloads
        @NotNull
        public final Single<SocketResponse> rpc(@NotNull String method) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            return com.ekoapp.ekosdk.internal.api.EkoSocket$Companion.rpc$default(this, method, null, 2, null);
        }

        private static final void init$lambda-0(Socket $socket, String $userId, String $event, Object[] args) {
            Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
            Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
            if (Objects.equal((Object)$socket, (Object)currentSocket)) {
                Intrinsics.checkNotNull((Object)args);
                SocketConnectionEvent sce = new SocketConnectionEvent($userId, $socket, $event, args);
                connectionEventRelay.accept((Object)sce);
            }
        }

        private static final void init$lambda-1(Socket $socket, Object[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (args.length > 0 && Objects.equal((Object)args[0], (Object)"io server disconnect")) {
                $socket.connect();
            }
        }

        private static final void init$lambda-2(String $userId, Object[] args) {
            Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
            try {
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse(Arrays.deepToString(args));
                JsonArray array = element.getAsJsonArray();
                JsonObject object = array.get(0).getAsJsonObject();
                AmityException exception = AmityException.Companion.create(object.get("message").getAsString(), null, object.get("code").getAsInt());
                if (AmityError.Companion.from(exception).is(AmityError.USER_IS_GLOBAL_BANNED)) {
                    globalBanEventPublisher.onNext((Object)new AmityGlobalBanEvent($userId));
                    SessionStateEventBus sessionStateEventBus = companionSessionStateEventBus;
                    if (sessionStateEventBus == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"companionSessionStateEventBus");
                        sessionStateEventBus = null;
                    }
                    sessionStateEventBus.publish(new SessionState.Terminated(exception));
                }
            }
            catch (Exception e) {
                Timber.tag((String)TAG);
            }
        }

        private static final void init$lambda-3() {
            EkoChannelDao channelDao = UserDatabase.get().channelDao();
            channelDao.deleteAllLocallyInactiveChannelsAndUpdateAllActiveChannelsToNotReading();
            Log.e((String)"AmitySDK", (String)"delete invalid channels");
        }

        private static final void init$lambda-5$lambda-4(Object[] args) {
            Companion.callStartReadingOnAllChannelsWithReadingStatus().subscribe();
        }

        private static final void init$lambda-5(Socket $socket) {
            $socket.on("connect", Companion::init$lambda-5$lambda-4);
        }

        private static final boolean callStartReadingOnAllChannelsWithReadingStatus$lambda-6(List channelIds) {
            Intrinsics.checkNotNullParameter((Object)channelIds, (String)"channelIds");
            return !((Collection)channelIds).isEmpty();
        }

        private static final CompletableSource callStartReadingOnAllChannelsWithReadingStatus$lambda-7(List channelIds) {
            return (CompletableSource)Companion.rpc(new ChannelStartReadingsRequest(channelIds)).ignoreElement();
        }

        private static final AmityConnectionState _get_connectionState_$lambda-8(SocketConnectionEvent socketConnectionEvent) {
            block27: {
                Intrinsics.checkNotNullParameter((Object)socketConnectionEvent, (String)"socketConnectionEvent");
                String string = socketConnectionEvent.event;
                if (string == null) break block27;
                int n = -1;
                switch (string.hashCode()) {
                    case 530405532: {
                        if (string.equals("disconnect")) {
                            n = 1;
                        }
                        break;
                    }
                    case -48584405: {
                        if (string.equals("reconnecting")) {
                            n = 2;
                        }
                        break;
                    }
                    case 288609829: {
                        if (string.equals("reconnect_failed")) {
                            n = 3;
                        }
                        break;
                    }
                    case -775651656: {
                        if (string.equals("connecting")) {
                            n = 4;
                        }
                        break;
                    }
                    case 96784904: {
                        if (string.equals("error")) {
                            n = 3;
                        }
                        break;
                    }
                    case 3446776: {
                        if (string.equals("pong")) {
                            n = 5;
                        }
                        break;
                    }
                    case 951351530: {
                        if (string.equals("connect")) {
                            n = 6;
                        }
                        break;
                    }
                    case -808593805: {
                        if (string.equals("connect_error")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 6: {
                        return AmityConnectionState.CONNECTED;
                    }
                    case 4: {
                        return AmityConnectionState.CONNECTING;
                    }
                    case 1: {
                        return AmityConnectionState.DISCONNECTED;
                    }
                    case 3: {
                        return AmityConnectionState.FAILED;
                    }
                    case 2: {
                        return AmityConnectionState.RECONNECTING;
                    }
                    case 5: {
                        if (socketConnectionEvent.isConnected) {
                            return AmityConnectionState.CONNECTED;
                        }
                        return AmityConnectionState.DISCONNECTED;
                    }
                }
            }
            return AmityConnectionState.UNKNOWN;
        }

        private static final boolean _get_connectionState_$lambda-9(AmityConnectionState amityConnectionState) {
            Intrinsics.checkNotNullParameter((Object)((Object)amityConnectionState), (String)"amityConnectionState");
            return amityConnectionState != AmityConnectionState.UNKNOWN;
        }

        private static final Object call$lambda-10(Call $call, SocketResponse response) {
            Intrinsics.checkNotNullParameter((Object)$call, (String)"$call");
            return $call.getConverter().convert(response);
        }

        private static final void rpc$lambda-11(String $method, JSONObject $orgJson, SingleSubject $responseSubject, Object[] args) {
            Intrinsics.checkNotNullParameter((Object)$method, (String)"$method");
            Intrinsics.checkNotNullParameter((Object)$orgJson, (String)"$orgJson");
            Intrinsics.checkNotNullParameter((Object)$responseSubject, (String)"$responseSubject");
            Companion.emit(currentSocket, $method, $orgJson, (SingleSubject<SocketResponse>)$responseSubject);
        }

        private static final void wrapConnectionError$lambda-12(String $errorEvent, SingleSubject $responseSubject, String $method, Object[] args) {
            Intrinsics.checkNotNullParameter((Object)$errorEvent, (String)"$errorEvent");
            Intrinsics.checkNotNullParameter((Object)$responseSubject, (String)"$responseSubject");
            Intrinsics.checkNotNullParameter((Object)$method, (String)"$method");
            String msg = $errorEvent + ": " + Arrays.deepToString(args);
            int code = AmityError.CONNECTION_ERROR.getCode();
            AmitySocketException amityError = AmitySocketException.Companion.create(msg, code);
            if (code == AmityError.USER_IS_GLOBAL_BANNED.getCode()) {
                SessionStateEventBus sessionStateEventBus = companionSessionStateEventBus;
                if (sessionStateEventBus == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"companionSessionStateEventBus");
                    sessionStateEventBus = null;
                }
                sessionStateEventBus.publish(new SessionState.Terminated(amityError));
            }
            $responseSubject.onError((Throwable)amityError);
            Object[] objectArray = new Object[]{$method, code, msg};
            Timber.tag((String)TAG).e("rpc: %s error (%s): %s", objectArray);
        }

        private static final void emit$lambda-13(String $method, int $rpcId, SingleSubject $responseSubject, Object[] args) {
            Intrinsics.checkNotNullParameter((Object)$method, (String)"$method");
            Intrinsics.checkNotNullParameter((Object)$responseSubject, (String)"$responseSubject");
            SocketResponse response = (SocketResponse)EkoGson.get().fromJson(args[0].toString(), SocketResponse.class);
            if (response.isSuccess()) {
                Object[] objectArray = new Object[]{$method, $rpcId, Arrays.deepToString(args)};
                Timber.tag((String)TAG).i("rpc: %s [%s] success socket response: %s", objectArray);
                $responseSubject.onSuccess((Object)response);
            } else {
                String msg = response.getMessage();
                int code = response.getCode();
                Object[] objectArray = new Object[]{$method, $rpcId, code, Arrays.deepToString(args)};
                Timber.tag((String)TAG).e("rpc: %s [%s] error socket response (%s): %s", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)msg, (String)"msg");
                $responseSubject.onError((Throwable)AmitySocketException.Companion.create(msg, code));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

