/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.channel;

import com.amity.socialcloud.sdk.chat.channel.AmityChannel;
import com.amity.socialcloud.sdk.chat.channel.ChannelCreateOption;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.amity.socialcloud.sdk.core.error.AmityException;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.internal.usecase.channel.CreateChannelUseCase;
import com.ekoapp.ekosdk.internal.usecase.channel.CreateChannelWithChannelIdUseCase;
import com.ekoapp.ekosdk.internal.usecase.channel.CreateConversationWithUserIdsUseCase;
import io.reactivex.Single;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0011B\u0017\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelCreator;", "", "channelType", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelCreator$CreationType;", "option", "Lcom/amity/socialcloud/sdk/chat/channel/ChannelCreateOption;", "(Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelCreator$CreationType;Lcom/amity/socialcloud/sdk/chat/channel/ChannelCreateOption;)V", "channelId", "", "(Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelCreator$CreationType;Ljava/lang/String;Lcom/amity/socialcloud/sdk/chat/channel/ChannelCreateOption;)V", "create", "Lio/reactivex/Single;", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannel;", "createChannel", "creationType", "createChannelByType", "createChannelConversation", "CreationType", "amity-sdk_release"})
public final class AmityChannelCreator {
    @Nullable
    private CreationType channelType;
    @NotNull
    private ChannelCreateOption option;
    @Nullable
    private String channelId;

    public AmityChannelCreator(@NotNull CreationType channelType, @NotNull ChannelCreateOption option) {
        Intrinsics.checkNotNullParameter((Object)((Object)channelType), (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        this.option = new ChannelCreateOption(null, null, null, null, null, 31, null);
        this.channelType = channelType;
        this.option = option;
    }

    public AmityChannelCreator(@NotNull CreationType channelType, @Nullable String channelId, @NotNull ChannelCreateOption option) {
        Intrinsics.checkNotNullParameter((Object)((Object)channelType), (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        this.option = new ChannelCreateOption(null, null, null, null, null, 31, null);
        this.channelType = channelType;
        this.channelId = channelId;
        this.option = option;
    }

    @NotNull
    public final Single<AmityChannel> create() {
        Single single;
        if (this.channelType != null) {
            CreationType creationType = this.channelType;
            switch (creationType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[creationType.ordinal()]) {
                case 1: {
                    single = this.createChannelByType(this.channelId, CreationType.LIVE, this.option);
                    break;
                }
                case 2: {
                    single = this.createChannelByType(this.channelId, CreationType.PRIVATE, this.option);
                    break;
                }
                case 3: {
                    single = this.createChannelByType(this.channelId, CreationType.COMMUNITY, this.option);
                    break;
                }
                case 4: {
                    single = this.createChannelByType(this.channelId, CreationType.STANDARD, this.option);
                    break;
                }
                case 5: {
                    single = this.createChannelConversation(this.option);
                    break;
                }
                default: {
                    Single single2 = Single.error((Throwable)AmityException.Companion.create("this channel type is not supported", null, AmityError.INVALID_PARAMETER));
                    single = single2;
                    Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"{\n                    Si\u2026METER))\n                }");
                    break;
                }
            }
        } else {
            Single single3 = Single.error((Throwable)AmityException.Companion.create("channel type must not be null", null, AmityError.INVALID_PARAMETER));
            single = single3;
            Intrinsics.checkNotNullExpressionValue((Object)single3, (String)"{\n            Single.err\u2026LID_PARAMETER))\n        }");
        }
        return single;
    }

    private final Single<AmityChannel> createChannelByType(String channelId, CreationType channelType, ChannelCreateOption option) {
        CharSequence charSequence = channelId;
        return charSequence == null || charSequence.length() == 0 ? this.createChannel(channelType, option) : this.createChannel(channelId, channelType, option);
    }

    private final Single<AmityChannel> createChannelConversation(ChannelCreateOption option) {
        return RxJava3BridgeExtensionsKt.toV2(new CreateConversationWithUserIdsUseCase().execute(option));
    }

    private final Single<AmityChannel> createChannel(String channelId, CreationType creationType, ChannelCreateOption option) {
        return RxJava3BridgeExtensionsKt.toV2(new CreateChannelWithChannelIdUseCase().execute(channelId, creationType, option));
    }

    private final Single<AmityChannel> createChannel(CreationType creationType, ChannelCreateOption option) {
        return RxJava3BridgeExtensionsKt.toV2(new CreateChannelUseCase().execute(creationType, option));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0080\u0001\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelCreator$CreationType;", "", "apiKey", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getApiKey", "()Ljava/lang/String;", "COMMUNITY", "STANDARD", "LIVE", "PRIVATE", "CONVERSATION", "Companion", "amity-sdk_release"})
    public static final class CreationType
    extends Enum<CreationType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String apiKey;
        public static final /* enum */ CreationType COMMUNITY;
        public static final /* enum */ CreationType STANDARD;
        public static final /* enum */ CreationType LIVE;
        public static final /* enum */ CreationType PRIVATE;
        public static final /* enum */ CreationType CONVERSATION;
        private static final /* synthetic */ CreationType[] $VALUES;

        private CreationType(String apiKey) {
            this.apiKey = apiKey;
        }

        @NotNull
        public final String getApiKey() {
            return this.apiKey;
        }

        public static CreationType[] values() {
            return (CreationType[])$VALUES.clone();
        }

        public static CreationType valueOf(String value) {
            return Enum.valueOf(CreationType.class, value);
        }

        static {
            COMMUNITY = new CreationType(AmityChannel.Type.COMMUNITY.getApiKey());
            STANDARD = new CreationType(AmityChannel.Type.STANDARD.getApiKey());
            LIVE = new CreationType(AmityChannel.Type.LIVE.getApiKey());
            PRIVATE = new CreationType(AmityChannel.Type.PRIVATE.getApiKey());
            CONVERSATION = new CreationType(AmityChannel.Type.CONVERSATION.getApiKey());
            $VALUES = creationTypeArray = new CreationType[]{CreationType.COMMUNITY, CreationType.STANDARD, CreationType.LIVE, CreationType.PRIVATE, CreationType.CONVERSATION};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelCreator$CreationType$Companion;", "", "()V", "fromJson", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelCreator$CreationType;", "jsonValue", "", "amity-sdk_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CreationType fromJson(@NotNull String jsonValue) {
                Intrinsics.checkNotNullParameter((Object)jsonValue, (String)"jsonValue");
                Companion $this$fromJson_u24lambda_u2d0 = this;
                boolean bl = false;
                for (CreationType type : CreationType.values()) {
                    if (Intrinsics.areEqual((Object)type.getApiKey(), (Object)jsonValue)) break;
                }
                return COMMUNITY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CreationType.values().length];
            nArray[CreationType.LIVE.ordinal()] = 1;
            nArray[CreationType.PRIVATE.ordinal()] = 2;
            nArray[CreationType.COMMUNITY.ordinal()] = 3;
            nArray[CreationType.STANDARD.ordinal()] = 4;
            nArray[CreationType.CONVERSATION.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

