/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.UserQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.model.UserQueryTokenEntity;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class UserQueryTokenDao_Impl
extends UserQueryTokenDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<UserQueryTokenEntity> __insertionAdapterOfUserQueryTokenEntity;
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();

    public UserQueryTokenDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserQueryTokenEntity = new EntityInsertionAdapter<UserQueryTokenEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `user_query_token` (`keyword`,`sortBy`,`previous`,`next`,`pageNumber`,`ids`,`updatedAt`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserQueryTokenEntity value) {
                if (value.keyword == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.keyword);
                }
                if (value.sortBy == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.sortBy);
                }
                if (value.getPrevious() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPrevious());
                }
                if (value.getNext() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getNext());
                }
                stmt.bindLong(5, (long)value.getPageNumber());
                String _tmp = UserQueryTokenDao_Impl.this.__stringListConverter.stringListToString(value.getIds());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp);
                }
                String _tmp_1 = UserQueryTokenDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
            }
        };
    }

    @Override
    public Completable insertToken(final UserQueryTokenEntity token) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                UserQueryTokenDao_Impl.this.__db.beginTransaction();
                try {
                    UserQueryTokenDao_Impl.this.__insertionAdapterOfUserQueryTokenEntity.insert((Object)token);
                    UserQueryTokenDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    UserQueryTokenDao_Impl.this.__db.endTransaction();
                }
            }
        });
    }

    @Override
    public Maybe<UserQueryTokenEntity> queryToken(SimpleSQLiteQuery query) {
        SimpleSQLiteQuery _internalQuery = query;
        return Maybe.fromCallable((Callable)new Callable<UserQueryTokenEntity>((SupportSQLiteQuery)_internalQuery){
            final /* synthetic */ SupportSQLiteQuery val$_internalQuery;
            {
                this.val$_internalQuery = supportSQLiteQuery;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UserQueryTokenEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserQueryTokenDao_Impl.this.__db, (SupportSQLiteQuery)this.val$_internalQuery, (boolean)false, null);){
                    UserQueryTokenEntity _result = _cursor.moveToFirst() ? UserQueryTokenDao_Impl.this.__entityCursorConverter_comEkoappEkosdkInternalDataModelUserQueryTokenEntity(_cursor) : null;
                    UserQueryTokenEntity userQueryTokenEntity = _result;
                    return userQueryTokenEntity;
                }
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private UserQueryTokenEntity __entityCursorConverter_comEkoappEkosdkInternalDataModelUserQueryTokenEntity(Cursor cursor) {
        int _cursorIndexOfKeyword = CursorUtil.getColumnIndex((Cursor)cursor, (String)"keyword");
        int _cursorIndexOfSortBy = CursorUtil.getColumnIndex((Cursor)cursor, (String)"sortBy");
        int _cursorIndexOfPrevious = CursorUtil.getColumnIndex((Cursor)cursor, (String)"previous");
        int _cursorIndexOfNext = CursorUtil.getColumnIndex((Cursor)cursor, (String)"next");
        int _cursorIndexOfPageNumber = CursorUtil.getColumnIndex((Cursor)cursor, (String)"pageNumber");
        int _cursorIndexOfIds = CursorUtil.getColumnIndex((Cursor)cursor, (String)"ids");
        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndex((Cursor)cursor, (String)"updatedAt");
        UserQueryTokenEntity _entity = new UserQueryTokenEntity();
        if (_cursorIndexOfKeyword != -1) {
            _entity.keyword = cursor.isNull(_cursorIndexOfKeyword) ? null : cursor.getString(_cursorIndexOfKeyword);
        }
        if (_cursorIndexOfSortBy != -1) {
            _entity.sortBy = cursor.isNull(_cursorIndexOfSortBy) ? null : cursor.getString(_cursorIndexOfSortBy);
        }
        if (_cursorIndexOfPrevious != -1) {
            String _tmpPrevious = cursor.isNull(_cursorIndexOfPrevious) ? null : cursor.getString(_cursorIndexOfPrevious);
            _entity.setPrevious(_tmpPrevious);
        }
        if (_cursorIndexOfNext != -1) {
            String _tmpNext = cursor.isNull(_cursorIndexOfNext) ? null : cursor.getString(_cursorIndexOfNext);
            _entity.setNext(_tmpNext);
        }
        if (_cursorIndexOfPageNumber != -1) {
            int _tmpPageNumber = cursor.getInt(_cursorIndexOfPageNumber);
            _entity.setPageNumber(_tmpPageNumber);
        }
        if (_cursorIndexOfIds != -1) {
            String _tmp = cursor.isNull(_cursorIndexOfIds) ? null : cursor.getString(_cursorIndexOfIds);
            List<String> _tmpIds = this.__stringListConverter.stringToStringList(_tmp);
            _entity.setIds(_tmpIds);
        }
        if (_cursorIndexOfUpdatedAt != -1) {
            String _tmp_1 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
            DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
            _entity.setUpdatedAt(_tmpUpdatedAt);
        }
        return _entity;
    }
}

