/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import com.amity.socialcloud.sdk.chat.data.message.MessageRepository;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import hu.akarnokd.rxjava3.bridge.RxJavaBridge;
import io.reactivex.Completable;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;

@Entity(tableName="message_flag", primaryKeys={"messageId"}, foreignKeys={@ForeignKey(entity=EkoMessageEntity.class, parentColumns={"messageId"}, childColumns={"messageId"}, onDelete=5)})
public class EkoMessageFlag
extends EkoObject {
    @NonNull
    private String messageId;
    @SerializedName(value="hashFlag")
    private EkoFlag flag;
    private EkoLocalFlag localFlag;

    @Override
    public String getId() {
        return null;
    }

    @NonNull
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(@NonNull String messageId) {
        this.messageId = messageId;
    }

    public EkoFlag getFlag() {
        return this.flag;
    }

    public void setFlag(EkoFlag flag) {
        this.flag = flag;
    }

    public EkoLocalFlag getLocalFlag() {
        return this.localFlag;
    }

    public void setLocalFlag(EkoLocalFlag localFlag) {
        this.localFlag = localFlag;
    }

    @SuppressLint(value={"CheckResult"})
    public boolean isFlaggedByMe() {
        if (this.flag != null) {
            boolean mightFlaggedByMe = this.flag.mightFlaggedByMe();
            if (this.localFlag == null) {
                this.localFlag = new EkoLocalFlag();
            }
            if (mightFlaggedByMe && !Objects.equal((Object)this.flag.getHash(), (Object)this.localFlag.getSyncedUpHash())) {
                Single.just((Object)this.messageId).filter(this.flag::expired).flatMapSingle(messageId -> RxJavaBridge.toV2Single(new MessageRepository().isFlaggedByMe((String)messageId))).subscribe(isFlaggedByMe -> {
                    this.localFlag.setFlaggedByMe((boolean)isFlaggedByMe);
                    this.localFlag.setSyncedUpHash(this.flag.getHash());
                    UserDatabase.get().messageFlagDao().update(this);
                }, Throwable::printStackTrace);
                return true;
            }
            return mightFlaggedByMe && this.localFlag.isFlaggedByMe();
        }
        if (this.localFlag != null) {
            Completable.fromAction(() -> {
                this.localFlag = null;
                UserDatabase.get().messageFlagDao().update(this);
            }).subscribeOn(Schedulers.io()).subscribe();
        }
        return false;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equal((Object)this.flag, (Object)((EkoMessageFlag)obj).flag) && Objects.equal((Object)this.localFlag, (Object)((EkoMessageFlag)obj).localFlag);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.flag, this.localFlag});
    }
}

