/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.boundarycallback;

import androidx.paging.PagedList;
import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.user.AmityUser;
import com.ekoapp.core.utils.PropertyUtilsKt;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.UserQueryConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.UserQueryRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.UserQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.model.UserQueryTokenEntity;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/ekoapp/ekosdk/internal/data/boundarycallback/UserBoundaryCallback;", "Landroidx/paging/PagedList$BoundaryCallback;", "Lcom/amity/socialcloud/sdk/core/user/AmityUser;", "keyword", "", "sortOption", "pageSize", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "getPageSize", "()I", "tokenDao", "Lcom/ekoapp/ekosdk/internal/data/dao/UserQueryTokenDao;", "call", "Lio/reactivex/Completable;", "request", "Lcom/ekoapp/ekosdk/internal/api/socket/request/UserQueryRequest;", "onFirstLoaded", "", "onItemAtEndLoaded", "itemAtEnd", "updateQueryToken", "token", "Lcom/ekoapp/ekosdk/internal/data/model/UserQueryTokenEntity;", "amity-sdk_release"})
public final class UserBoundaryCallback
extends PagedList.BoundaryCallback<AmityUser> {
    @NotNull
    private final String keyword;
    @NotNull
    private final String sortOption;
    private final int pageSize;
    @NotNull
    private final UserQueryTokenDao tokenDao;

    public UserBoundaryCallback(@NotNull String keyword, @NotNull String sortOption, int pageSize) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)sortOption, (String)"sortOption");
        this.keyword = keyword;
        this.sortOption = sortOption;
        this.pageSize = pageSize;
        this.onFirstLoaded();
        UserQueryTokenDao userQueryTokenDao = UserDatabase.get().userQueryTokenDao();
        Intrinsics.checkNotNullExpressionValue((Object)userQueryTokenDao, (String)"get().userQueryTokenDao()");
        this.tokenDao = userQueryTokenDao;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    private final void onFirstLoaded() {
        UserQueryRequest request = new UserQueryRequest(PropertyUtilsKt.requiredNotEmpty(this.keyword), this.sortOption, new UserQueryRequest.UserQueryOptions(null, this.pageSize, null, 5, null));
        this.call(request).subscribeOn(Schedulers.io()).subscribe();
    }

    public void onItemAtEndLoaded(@NotNull AmityUser itemAtEnd) {
        Intrinsics.checkNotNullParameter((Object)itemAtEnd, (String)"itemAtEnd");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"keyword", (Object)this.keyword), TuplesKt.to((Object)"sortBy", (Object)this.sortOption)};
        this.tokenDao.getQueryTokenByPageNumber(MapsKt.mapOf((Pair[])pairArray), 1).filter(UserBoundaryCallback::onItemAtEndLoaded$lambda-0).flatMapCompletable(arg_0 -> UserBoundaryCallback.onItemAtEndLoaded$lambda-1(this, arg_0)).subscribeOn(Schedulers.io()).subscribe();
    }

    private final Completable call(UserQueryRequest request) {
        Call call = Call.create(request, new UserQueryConverter());
        Intrinsics.checkNotNullExpressionValue(call, (String)"create(request, UserQueryConverter())");
        Completable completable = EkoSocket.Companion.call(call).doOnSuccess(arg_0 -> UserBoundaryCallback.call$lambda-4(this, arg_0)).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    private final void updateQueryToken(UserQueryTokenEntity token) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"keyword", (Object)this.keyword), TuplesKt.to((Object)"sortBy", (Object)this.sortOption)};
        this.tokenDao.getQueryTokenByPageNumber(MapsKt.mapOf((Pair[])pairArray), 1).flatMapCompletable(arg_0 -> UserBoundaryCallback.updateQueryToken$lambda-5(token, this, arg_0)).subscribeOn(Schedulers.io()).subscribe();
    }

    private static final boolean onItemAtEndLoaded$lambda-0(UserQueryTokenEntity token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        CharSequence charSequence = token.getNext();
        return !(charSequence == null || charSequence.length() == 0);
    }

    private static final CompletableSource onItemAtEndLoaded$lambda-1(UserBoundaryCallback this$0, UserQueryTokenEntity token) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        String string = PropertyUtilsKt.requiredNotEmpty(this$0.keyword);
        String string2 = this$0.sortOption;
        String string3 = token.getNext();
        Intrinsics.checkNotNull((Object)string3);
        return (CompletableSource)this$0.call(new UserQueryRequest(string, string2, new UserQueryRequest.UserQueryOptions(null, null, string3, 3, null)));
    }

    /*
     * WARNING - void declaration
     */
    private static final void call$lambda-4(UserBoundaryCallback this$0, EkoUserListDto dto) {
        boolean isFirstPage;
        List list;
        List<EkoUserDto> list2;
        UserQueryTokenEntity userQueryTokenEntity;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        UserQueryTokenEntity $this$call_u24lambda_u2d4_u24lambda_u2d3 = userQueryTokenEntity = new UserQueryTokenEntity();
        boolean bl = false;
        $this$call_u24lambda_u2d4_u24lambda_u2d3.setKeyword(this$0.keyword);
        $this$call_u24lambda_u2d4_u24lambda_u2d3.setSortBy(this$0.sortOption);
        $this$call_u24lambda_u2d4_u24lambda_u2d3.setPageNumber(1);
        UserQueryTokenEntity userQueryTokenEntity2 = dto.getToken();
        $this$call_u24lambda_u2d4_u24lambda_u2d3.setNext(userQueryTokenEntity2 != null ? userQueryTokenEntity2.getNext() : null);
        UserQueryTokenEntity userQueryTokenEntity3 = dto.getToken();
        $this$call_u24lambda_u2d4_u24lambda_u2d3.setPrevious(userQueryTokenEntity3 != null ? userQueryTokenEntity3.getPrevious() : null);
        UserQueryTokenEntity userQueryTokenEntity4 = $this$call_u24lambda_u2d4_u24lambda_u2d3;
        List<EkoUserDto> list3 = list2 = dto.getUsers();
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullExpressionValue(list3, (String)"users");
            Iterable iterable = list2;
            UserQueryTokenEntity userQueryTokenEntity5 = userQueryTokenEntity4;
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EkoUserDto ekoUserDto = (EkoUserDto)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getUserId());
            }
            list = (List)destination$iv$iv;
            userQueryTokenEntity4 = userQueryTokenEntity5;
        } else {
            list = null;
        }
        userQueryTokenEntity4.setIds(list);
        $this$call_u24lambda_u2d4_u24lambda_u2d3.setUpdatedAt(AmityCoreClient.INSTANCE.getServerTime$amity_sdk_release());
        UserQueryTokenEntity token = userQueryTokenEntity;
        UserQueryTokenEntity userQueryTokenEntity6 = dto.getToken();
        boolean bl3 = isFirstPage = (userQueryTokenEntity6 != null ? userQueryTokenEntity6.getPrevious() : null) == null;
        if (isFirstPage) {
            this$0.tokenDao.insertToken(token).subscribeOn(Schedulers.io()).subscribe();
        } else {
            this$0.updateQueryToken(token);
        }
    }

    private static final CompletableSource updateQueryToken$lambda-5(UserQueryTokenEntity $token, UserBoundaryCallback this$0, UserQueryTokenEntity it) {
        Intrinsics.checkNotNullParameter((Object)$token, (String)"$token");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List<String> list = $token.getIds();
        List<String> list2 = it.getIds();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"it.ids");
        list.addAll(0, (Collection<String>)list2);
        return (CompletableSource)this$0.tokenDao.insertToken($token);
    }
}

