/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.follow;

import androidx.arch.core.util.Function;
import androidx.paging.DataSource;
import androidx.paging.PagedList;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.follow.FollowLocalDataStore;
import com.amity.socialcloud.sdk.core.data.follow.FollowQueryPersister;
import com.amity.socialcloud.sdk.core.data.follow.FollowRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.follow.info.MyFollowInfoModelMapper;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.amity.socialcloud.sdk.core.user.AmityFollowRelationship;
import com.amity.socialcloud.sdk.core.user.AmityFollowStatus;
import com.amity.socialcloud.sdk.core.user.AmityFollowStatusFilter;
import com.amity.socialcloud.sdk.core.user.AmityMyFollowInfo;
import com.amity.socialcloud.sdk.core.user.AmityUserFollowInfo;
import com.amity.socialcloud.sdk.social.data.follow.FollowRelationshipModelMapper;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.AmityObjectRepository;
import com.ekoapp.ekosdk.internal.api.dto.EkoFollowDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoFollowListDto;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.FollowersBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.boundarycallback.FollowingsBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoFollowDao;
import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFollowStatusEntity;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.repository.user.FollowerMediator;
import com.ekoapp.ekosdk.internal.repository.user.FollowingMediator;
import com.ekoapp.ekosdk.internal.repository.user.helper.MapToUserFollowStatusModelHelper;
import com.ekoapp.ekosdk.internal.repository.user.helper.UserRepositoryHelper;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00150\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00150\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001dH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u000e\u0010 \u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010$\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006%"}, d2={"Lcom/amity/socialcloud/sdk/core/data/follow/FollowRepository;", "Lcom/ekoapp/ekosdk/AmityObjectRepository;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoFollowCountEntity;", "Lcom/amity/socialcloud/sdk/core/user/AmityMyFollowInfo;", "()V", "acceptFollow", "Lio/reactivex/rxjava3/core/Completable;", "userId", "", "declineFollow", "fetchAndSave", "objectId", "getDefaultPageSize", "", "getFollowersPagedList", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagedList;", "Lcom/amity/socialcloud/sdk/core/user/AmityFollowRelationship;", "filter", "Lcom/amity/socialcloud/sdk/core/user/AmityFollowStatusFilter;", "getFollowersPagingData", "Landroidx/paging/PagingData;", "getFollowingsPagedList", "getFollowingsPagingData", "getLatestFollower", "getLatestFollowing", "getUserFollowInfo", "Lcom/amity/socialcloud/sdk/core/user/AmityUserFollowInfo;", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "queryFromCache", "removeFollower", "requestFollow", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/core/user/AmityFollowStatus;", "unfollow", "amity-sdk_release"})
public final class FollowRepository
extends AmityObjectRepository<EkoFollowCountEntity, AmityMyFollowInfo> {
    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new FollowRemoteDataStore().getMyFollowInfo().flatMapCompletable(FollowRepository::fetchAndSave$lambda-0);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"FollowRemoteDataStore().\u2026persist(it)\n            }");
        return completable;
    }

    @Override
    @Nullable
    public EkoFollowCountEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new FollowLocalDataStore().getFollowCount(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<EkoFollowCountEntity, AmityMyFollowInfo> mapper() {
        return new MyFollowInfoModelMapper();
    }

    @Override
    @NotNull
    public Flowable<EkoFollowCountEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new FollowLocalDataStore().observeFollowCount(objectId);
    }

    @NotNull
    public final Flowable<AmityUserFollowInfo> getUserFollowInfo(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String myUserId = AmityCoreClient.INSTANCE.getUserId();
        Flowable flowable = new FollowRemoteDataStore().getUserFollowInfo(userId).flatMapCompletable(FollowRepository::getUserFollowInfo$lambda-1).andThen((Publisher)Flowable.combineLatest((Publisher)((Publisher)new FollowLocalDataStore().observeUserFollow(myUserId, userId)), (Publisher)((Publisher)new FollowLocalDataStore().observeFollowCount(userId)), FollowRepository::getUserFollowInfo$lambda-2));
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"FollowRemoteDataStore().\u2026      }\n                )");
        return flowable;
    }

    @NotNull
    public final Single<AmityFollowStatus> requestFollow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Single single = new FollowRemoteDataStore().requestFollow(userId).map(FollowRepository::requestFollow$lambda-3);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"FollowRemoteDataStore().\u2026mOf(status)\n            }");
        return single;
    }

    @NotNull
    public final Completable acceptFollow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction(() -> FollowRepository.acceptFollow$lambda-4(userId)).concatWith((CompletableSource)new FollowRemoteDataStore().acceptFollow(userId).flatMapCompletable(FollowRepository::acceptFollow$lambda-5).doOnError(arg_0 -> FollowRepository.acceptFollow$lambda-6(userId, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026     }\n                })");
        return completable;
    }

    @NotNull
    public final Completable declineFollow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction(() -> FollowRepository.declineFollow$lambda-7(userId)).concatWith((CompletableSource)new FollowRemoteDataStore().declineFollow(userId).flatMapCompletable(FollowRepository::declineFollow$lambda-8).doOnError(arg_0 -> FollowRepository.declineFollow$lambda-9(userId, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026     }\n                })");
        return completable;
    }

    @NotNull
    public final Completable removeFollower(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction(() -> FollowRepository.removeFollower$lambda-10(userId)).concatWith((CompletableSource)new FollowRemoteDataStore().declineFollow(userId).flatMapCompletable(FollowRepository::removeFollower$lambda-11).doOnError(arg_0 -> FollowRepository.removeFollower$lambda-12(userId, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026     }\n                })");
        return completable;
    }

    @NotNull
    public final Completable unfollow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction(() -> FollowRepository.unfollow$lambda-13(userId)).concatWith((CompletableSource)new FollowRemoteDataStore().unfollow(userId).flatMapCompletable(arg_0 -> FollowRepository.unfollow$lambda-14(userId, arg_0)).doOnError(arg_0 -> FollowRepository.unfollow$lambda-15(userId, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026     }\n                })");
        return completable;
    }

    @NotNull
    public final Flowable<PagedList<AmityFollowRelationship>> getFollowingsPagedList(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        EkoFollowDao followDao = UserDatabase.get().followDao();
        DataSource.Factory<Integer, EkoUserFollowStatusEntity> factory2 = followDao.getFollowingsDataSource(userId, filter);
        FollowingsBoundaryCallback boundaryCallback = new FollowingsBoundaryCallback(userId, filter, this.getDefaultPageSize());
        return RxJava3BridgeExtensionsKt.toV3(this.createRxCollectionWithBoundaryCallback(factory2.map((Function)new MapToUserFollowStatusModelHelper()), boundaryCallback));
    }

    @NotNull
    public final Flowable<PagingData<AmityFollowRelationship>> getFollowingsPagingData(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null), null, new FollowingMediator(userId, filter), (Function0)new Function0<PagingSource<Integer, EkoUserFollowStatusEntity>>(userId, filter){
            final /* synthetic */ String $userId;
            final /* synthetic */ AmityFollowStatusFilter $filter;
            {
                this.$userId = $userId;
                this.$filter = $filter;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, EkoUserFollowStatusEntity> invoke() {
                return new FollowLocalDataStore().getFollowingsPagingSource(this.$userId, this.$filter);
            }
        }, (ModelMapper)new FollowRelationshipModelMapper(), 2, null);
        return RxJava3BridgeExtensionsKt.toV3(pagerCreator2.create());
    }

    @NotNull
    public final Flowable<PagedList<AmityFollowRelationship>> getFollowersPagedList(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        EkoFollowDao followerDao = UserDatabase.get().followDao();
        DataSource.Factory<Integer, EkoUserFollowStatusEntity> factory2 = followerDao.getFollowersDataSource(userId, filter);
        FollowersBoundaryCallback boundaryCallback = new FollowersBoundaryCallback(userId, filter, this.getDefaultPageSize());
        return RxJava3BridgeExtensionsKt.toV3(this.createRxCollectionWithBoundaryCallback(factory2.map((Function)new MapToUserFollowStatusModelHelper()), boundaryCallback));
    }

    @NotNull
    public final Flowable<PagingData<AmityFollowRelationship>> getFollowersPagingData(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null), null, new FollowerMediator(userId, filter), (Function0)new Function0<PagingSource<Integer, EkoUserFollowStatusEntity>>(userId, filter){
            final /* synthetic */ String $userId;
            final /* synthetic */ AmityFollowStatusFilter $filter;
            {
                this.$userId = $userId;
                this.$filter = $filter;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, EkoUserFollowStatusEntity> invoke() {
                return new FollowLocalDataStore().getFollowersPagingSource(this.$userId, this.$filter);
            }
        }, (ModelMapper)new FollowRelationshipModelMapper(), 2, null);
        return RxJava3BridgeExtensionsKt.toV3(pagerCreator2.create());
    }

    @NotNull
    public final Flowable<AmityFollowRelationship> getLatestFollowing(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Flowable flowable = new FollowLocalDataStore().getLatestFollowing(userId, filter).map(FollowRepository::getLatestFollowing$lambda-16);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"FollowLocalDataStore().g\u2026ipModelMapper().map(it) }");
        return flowable;
    }

    @NotNull
    public final Flowable<AmityFollowRelationship> getLatestFollower(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Flowable flowable = new FollowLocalDataStore().getLatestFollower(userId, filter).map(FollowRepository::getLatestFollower$lambda-17);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"FollowLocalDataStore().g\u2026ipModelMapper().map(it) }");
        return flowable;
    }

    private final int getDefaultPageSize() {
        return 20;
    }

    private static final CompletableSource fetchAndSave$lambda-0(EkoFollowListDto it) {
        FollowQueryPersister followQueryPersister = new FollowQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (CompletableSource)followQueryPersister.persist(it);
    }

    private static final CompletableSource getUserFollowInfo$lambda-1(EkoFollowListDto it) {
        FollowQueryPersister followQueryPersister = new FollowQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (CompletableSource)followQueryPersister.persist(it);
    }

    private static final AmityUserFollowInfo getUserFollowInfo$lambda-2(EkoUserFollowStatusEntity followEntity, EkoFollowCountEntity followCountEntity) {
        Intrinsics.checkNotNullParameter((Object)followEntity, (String)"followEntity");
        Intrinsics.checkNotNullParameter((Object)followCountEntity, (String)"followCountEntity");
        EkoUserFollowStatusEntity ekoUserFollowStatusEntity = followEntity;
        UserRepositoryHelper userRepositoryHelper = new UserRepositoryHelper();
        EkoUserFollowStatusEntity p0 = ekoUserFollowStatusEntity;
        boolean bl = false;
        AmityFollowRelationship mapFollow = userRepositoryHelper.attachDataAndMapToExternal(p0);
        return new UserRepositoryHelper().attachUserFollowInfoDataAndMapToExternal(mapFollow, followCountEntity);
    }

    private static final AmityFollowStatus requestFollow$lambda-3(EkoFollowListDto it) {
        FollowQueryPersister followQueryPersister = new FollowQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        followQueryPersister.persist(it);
        String status = ((EkoFollowDto)CollectionsKt.first(it.getFollows())).getStatus();
        return AmityFollowStatus.Companion.enumOf(status);
    }

    private static final void acceptFollow$lambda-4(String $userId) {
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        new FollowLocalDataStore().updateFollower($userId, AmityFollowStatus.ACCEPTED);
    }

    private static final CompletableSource acceptFollow$lambda-5(EkoFollowListDto it) {
        FollowLocalDataStore followLocalDataStore = new FollowLocalDataStore();
        String myUserId = AmityCoreClient.INSTANCE.getUserId();
        EkoFollowCountEntity followCountEntity = followLocalDataStore.getFollowCountByIdNow(myUserId);
        if (followCountEntity.getFollowerCount() != null) {
            Integer n = followCountEntity.getFollowerCount();
            Intrinsics.checkNotNull((Object)n);
            if (n >= 0) {
                Integer n2 = followCountEntity.getFollowerCount();
                Intrinsics.checkNotNull((Object)n2);
                followLocalDataStore.updateFollowerCount(myUserId, n2 + 1);
            }
        }
        if (followCountEntity.getPendingCount() != null) {
            Integer n = followCountEntity.getPendingCount();
            Intrinsics.checkNotNull((Object)n);
            if (n >= 0) {
                Integer n3 = followCountEntity.getPendingCount();
                Intrinsics.checkNotNull((Object)n3);
                followLocalDataStore.updatePendingCount(myUserId, n3 + -1);
            }
        }
        return (CompletableSource)Completable.complete();
    }

    private static final void acceptFollow$lambda-6(String $userId, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
            new FollowLocalDataStore().updateFollower($userId, AmityFollowStatus.NONE);
        } else {
            new FollowLocalDataStore().updateFollower($userId, AmityFollowStatus.PENDING);
        }
    }

    private static final void declineFollow$lambda-7(String $userId) {
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        new FollowLocalDataStore().updateFollower($userId, AmityFollowStatus.NONE);
    }

    private static final CompletableSource declineFollow$lambda-8(EkoFollowListDto it) {
        FollowLocalDataStore followLocalDataStore = new FollowLocalDataStore();
        String myUserId = AmityCoreClient.INSTANCE.getUserId();
        EkoFollowCountEntity followCountEntity = followLocalDataStore.getFollowCountByIdNow(myUserId);
        if (followCountEntity.getPendingCount() != null) {
            Integer n = followCountEntity.getPendingCount();
            Intrinsics.checkNotNull((Object)n);
            if (n >= 0) {
                Integer n2 = followCountEntity.getPendingCount();
                Intrinsics.checkNotNull((Object)n2);
                followLocalDataStore.updatePendingCount(myUserId, n2 + -1);
            }
        }
        return (CompletableSource)Completable.complete();
    }

    private static final void declineFollow$lambda-9(String $userId, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
            new FollowLocalDataStore().updateFollower($userId, AmityFollowStatus.NONE);
        } else {
            new FollowLocalDataStore().updateFollower($userId, AmityFollowStatus.PENDING);
        }
    }

    private static final void removeFollower$lambda-10(String $userId) {
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        new FollowLocalDataStore().updateFollower($userId, AmityFollowStatus.NONE);
    }

    private static final CompletableSource removeFollower$lambda-11(EkoFollowListDto it) {
        FollowLocalDataStore followLocalDataStore = new FollowLocalDataStore();
        String myUserId = AmityCoreClient.INSTANCE.getUserId();
        EkoFollowCountEntity followCountEntity = followLocalDataStore.getFollowCountByIdNow(myUserId);
        if (followCountEntity.getFollowerCount() != null) {
            Integer n = followCountEntity.getFollowerCount();
            Intrinsics.checkNotNull((Object)n);
            if (n >= 0) {
                Integer n2 = followCountEntity.getFollowerCount();
                Intrinsics.checkNotNull((Object)n2);
                followLocalDataStore.updateFollowerCount(myUserId, n2 + -1);
            }
        }
        return (CompletableSource)Completable.complete();
    }

    private static final void removeFollower$lambda-12(String $userId, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
            new FollowLocalDataStore().updateFollower($userId, AmityFollowStatus.NONE);
        } else {
            new FollowLocalDataStore().updateFollower($userId, AmityFollowStatus.ACCEPTED);
        }
    }

    private static final void unfollow$lambda-13(String $userId) {
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        new FollowLocalDataStore().updateFollowing($userId, AmityFollowStatus.NONE);
    }

    private static final CompletableSource unfollow$lambda-14(String $userId, EkoFollowListDto it) {
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        FollowLocalDataStore followLocalDataStore = new FollowLocalDataStore();
        EkoFollowCountEntity followCountEntity = followLocalDataStore.getFollowCountByIdNow($userId);
        if (followCountEntity.getFollowingCount() != null) {
            Integer n = followCountEntity.getFollowingCount();
            Intrinsics.checkNotNull((Object)n);
            if (n >= 0) {
                Integer n2 = followCountEntity.getFollowingCount();
                Intrinsics.checkNotNull((Object)n2);
                followLocalDataStore.updateFollowingCount($userId, n2 + -1);
            }
        }
        return (CompletableSource)Completable.complete();
    }

    private static final void unfollow$lambda-15(String $userId, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
            new FollowLocalDataStore().updateFollowing($userId, AmityFollowStatus.NONE);
        } else {
            new FollowLocalDataStore().updateFollowing($userId, AmityFollowStatus.ACCEPTED);
        }
    }

    private static final AmityFollowRelationship getLatestFollowing$lambda-16(EkoUserFollowStatusEntity it) {
        FollowRelationshipModelMapper followRelationshipModelMapper = new FollowRelationshipModelMapper();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return followRelationshipModelMapper.map(it);
    }

    private static final AmityFollowRelationship getLatestFollower$lambda-17(EkoUserFollowStatusEntity it) {
        FollowRelationshipModelMapper followRelationshipModelMapper = new FollowRelationshipModelMapper();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return followRelationshipModelMapper.map(it);
    }
}

