/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.boundarycallback;

import androidx.arch.core.util.Function;
import androidx.core.util.Pair;
import com.amity.socialcloud.sdk.infra.retrofit.request.QueryOptionsRequestParams;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.social.community.AmityCommunity;
import com.amity.socialcloud.sdk.social.community.AmityCommunityFilter;
import com.amity.socialcloud.sdk.social.community.AmityCommunitySortOption;
import com.amity.socialcloud.sdk.social.data.community.CommunityQueryPersister;
import com.amity.socialcloud.sdk.social.data.community.CommunityRemoteDataStore;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.internal.api.dto.CommunityListQueryDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityDto;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityQueryRequest;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.model.CommunityQueryToken;
import com.github.davidmoten.rx2.RetryWhen;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.Subject;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0003:\u0001*BE\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J\b\u0010$\u001a\u00020\"H\u0016J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0002H\u0016J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u0002H\u0016J\b\u0010)\u001a\u00020\"H\u0016R\u0016\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0018j\b\u0012\u0004\u0012\u00020\u0005`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/ekoapp/ekosdk/internal/data/boundarycallback/EkoCommunityBoundaryCallback;", "Lcom/ekoapp/ekosdk/internal/data/boundarycallback/EkoBoundaryCallback;", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunity;", "Landroidx/arch/core/util/Function;", "keyword", "", "categoryId", "filter", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityFilter;", "sortBy", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunitySortOption;", "isDeleted", "", "pageSize", "", "delaySubject", "Lio/reactivex/subjects/Subject;", "(Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/social/community/AmityCommunityFilter;Lcom/amity/socialcloud/sdk/social/community/AmityCommunitySortOption;Ljava/lang/Boolean;ILio/reactivex/subjects/Subject;)V", "TAG", "kotlin.jvm.PlatformType", "communityIdAndTokenMap", "", "Landroidx/core/util/Pair;", "communityIdSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "Ljava/lang/Boolean;", "apply", "input", "call", "Lio/reactivex/Completable;", "options", "Lcom/ekoapp/ekosdk/internal/api/socket/request/CommunityQueryRequest$CommunityQueryOptions;", "mapByCommunity", "", "communityId", "onFirstLoaded", "onItemAtEndLoaded", "itemAtEnd", "onItemAtFrontLoaded", "itemAtFront", "onZeroItemsLoaded", "Companion", "amity-sdk_release"})
public final class EkoCommunityBoundaryCallback
extends EkoBoundaryCallback<AmityCommunity>
implements Function<AmityCommunity, AmityCommunity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String keyword;
    @NotNull
    private final String categoryId;
    @NotNull
    private final AmityCommunityFilter filter;
    @NotNull
    private final AmityCommunitySortOption sortBy;
    @Nullable
    private final Boolean isDeleted;
    @NotNull
    private final Subject<Boolean> delaySubject;
    @NotNull
    private final Map<String, Pair<String, Boolean>> communityIdAndTokenMap;
    @NotNull
    private final HashSet<String> communityIdSet;
    private final String TAG;
    @NotNull
    private static final Executor SINGLE_THREAD_EXECUTOR;

    public EkoCommunityBoundaryCallback(@NotNull String keyword, @NotNull String categoryId, @NotNull AmityCommunityFilter filter, @NotNull AmityCommunitySortOption sortBy, @Nullable Boolean isDeleted, int pageSize, @NotNull Subject<Boolean> delaySubject) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        Intrinsics.checkNotNullParameter(delaySubject, (String)"delaySubject");
        super(pageSize);
        this.keyword = keyword;
        this.categoryId = categoryId;
        this.filter = filter;
        this.sortBy = sortBy;
        this.isDeleted = isDeleted;
        this.delaySubject = delaySubject;
        this.communityIdAndTokenMap = new LinkedHashMap();
        this.communityIdSet = new HashSet();
        this.TAG = ((Object)((Object)this)).getClass().getName();
        this.onFirstLoaded();
    }

    public void onItemAtFrontLoaded(@NotNull AmityCommunity itemAtFront) {
        Intrinsics.checkNotNullParameter((Object)itemAtFront, (String)"itemAtFront");
    }

    public void onItemAtEndLoaded(@NotNull AmityCommunity itemAtEnd) {
        Intrinsics.checkNotNullParameter((Object)itemAtEnd, (String)"itemAtEnd");
    }

    public void onZeroItemsLoaded() {
    }

    @Override
    public void onFirstLoaded() {
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        AmityLog.INSTANCE.tag(string).i("onFirstLoaded", new Object[0]);
        CommunityQueryRequest.CommunityQueryOptions options = new CommunityQueryRequest.CommunityQueryOptions(this.getPageSize(), null, 2, null);
        this.call(options).doOnComplete(() -> EkoCommunityBoundaryCallback.onFirstLoaded$lambda-0(this)).doOnError(arg_0 -> EkoCommunityBoundaryCallback.onFirstLoaded$lambda-1(this, arg_0)).subscribeOn(Schedulers.from((Executor)SINGLE_THREAD_EXECUTOR)).subscribe((CompletableObserver)this);
    }

    @NotNull
    public AmityCommunity apply(@NotNull AmityCommunity input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.communityIdSet.add(input.getCommunityId());
        this.mapByCommunity(input.getCommunityId());
        return input;
    }

    private final void mapByCommunity(String communityId) {
        block1: {
            Pair<String, Boolean> pair = this.communityIdAndTokenMap.get(communityId);
            if (pair == null) break block1;
            Pair<String, Boolean> communityIdAndTokenMapNonNull = pair;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)communityIdAndTokenMapNonNull.first;
            if (charSequence == null || charSequence.length() == 0 || Intrinsics.areEqual((Object)communityIdAndTokenMapNonNull.second, (Object)true)) {
                return;
            }
            CommunityQueryRequest.CommunityQueryOptions options = new CommunityQueryRequest.CommunityQueryOptions(null, (String)communityIdAndTokenMapNonNull.first, 1, null);
            this.call(options).doOnSubscribe(arg_0 -> EkoCommunityBoundaryCallback.mapByCommunity$lambda-4$lambda-2(this, communityId, communityIdAndTokenMapNonNull, arg_0)).doOnError(arg_0 -> EkoCommunityBoundaryCallback.mapByCommunity$lambda-4$lambda-3(this, communityId, communityIdAndTokenMapNonNull, arg_0)).subscribeOn(Schedulers.from((Executor)SINGLE_THREAD_EXECUTOR)).subscribe((CompletableObserver)this);
        }
    }

    private final Completable call(CommunityQueryRequest.CommunityQueryOptions options) {
        CharSequence charSequence;
        CharSequence charSequence2;
        CommunityRemoteDataStore communityRemoteDataStore;
        CommunityRemoteDataStore communityRemoteDataStore2 = new CommunityRemoteDataStore();
        CharSequence charSequence3 = this.keyword;
        if (charSequence3.length() == 0) {
            communityRemoteDataStore = communityRemoteDataStore2;
            boolean bl = false;
            charSequence2 = null;
            communityRemoteDataStore2 = communityRemoteDataStore;
        } else {
            charSequence2 = charSequence3;
        }
        String string = (String)charSequence2;
        charSequence3 = this.categoryId;
        if (charSequence3.length() == 0) {
            String string2 = string;
            communityRemoteDataStore = communityRemoteDataStore2;
            boolean bl = false;
            Object var6_6 = null;
            communityRemoteDataStore2 = communityRemoteDataStore;
            string = string2;
            charSequence = var6_6;
        } else {
            charSequence = charSequence3;
        }
        Completable completable = RxJava3BridgeExtensionsKt.toV2(CommunityRemoteDataStore.queryCommunities$default(communityRemoteDataStore2, string, (String)charSequence, this.filter.getValue(), this.sortBy.getApiKey(), null, new QueryOptionsRequestParams(options.getLimit(), options.getToken()), 16, null)).flatMap(EkoCommunityBoundaryCallback::call$lambda-7).doOnSuccess(arg_0 -> EkoCommunityBoundaryCallback.call$lambda-9(this, arg_0)).retryWhen(RetryWhen.maxRetries((int)3).exponentialBackoff(1L, 10L, TimeUnit.SECONDS, 1.5).action(arg_0 -> EkoCommunityBoundaryCallback.call$lambda-10(this, arg_0)).build()).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"CommunityRemoteDataStore\u2026         .ignoreElement()");
        return completable;
    }

    private static final void onFirstLoaded$lambda-0(EkoCommunityBoundaryCallback this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.delaySubject.onComplete();
    }

    private static final void onFirstLoaded$lambda-1(EkoCommunityBoundaryCallback this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.delaySubject.onComplete();
    }

    private static final void mapByCommunity$lambda-4$lambda-2(EkoCommunityBoundaryCallback this$0, String $communityId, Pair $communityIdAndTokenMapNonNull, Disposable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$communityId, (String)"$communityId");
        Intrinsics.checkNotNullParameter((Object)$communityIdAndTokenMapNonNull, (String)"$communityIdAndTokenMapNonNull");
        this$0.communityIdAndTokenMap.put($communityId, (Pair<String, Boolean>)new Pair($communityIdAndTokenMapNonNull.first, (Object)true));
    }

    private static final void mapByCommunity$lambda-4$lambda-3(EkoCommunityBoundaryCallback this$0, String $communityId, Pair $communityIdAndTokenMapNonNull, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$communityId, (String)"$communityId");
        Intrinsics.checkNotNullParameter((Object)$communityIdAndTokenMapNonNull, (String)"$communityIdAndTokenMapNonNull");
        this$0.communityIdAndTokenMap.put($communityId, (Pair<String, Boolean>)new Pair($communityIdAndTokenMapNonNull.first, (Object)false));
    }

    private static final SingleSource call$lambda-7(CommunityListQueryDto dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        return (SingleSource)RxJava3BridgeExtensionsKt.toV2(new CommunityQueryPersister().persist(dto)).andThen((SingleSource)Single.just((Object)dto));
    }

    private static final void call$lambda-9(EkoCommunityBoundaryCallback this$0, CommunityListQueryDto dto) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        List<EkoCommunityDto> communities = dto.getCommunities();
        Collection collection = communities;
        if (!(collection == null || collection.isEmpty())) {
            EkoCommunityDto ekoCommunityDto;
            Object $this$lastOrNull$iv;
            block6: {
                $this$lastOrNull$iv = communities;
                boolean $i$f$lastOrNull = false;
                ListIterator<EkoCommunityDto> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    EkoCommunityDto element$iv;
                    EkoCommunityDto it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    if (!(this$0.isDeleted == null ? true : Intrinsics.areEqual((Object)this$0.isDeleted, (Object)it.isDeleted()))) continue;
                    ekoCommunityDto = element$iv;
                    break block6;
                }
                ekoCommunityDto = null;
            }
            EkoCommunityDto ekoCommunityDto2 = ekoCommunityDto;
            String communityId = ekoCommunityDto2 != null ? ekoCommunityDto2.getCommunityId() : null;
            CommunityQueryToken communityQueryToken = dto.getPaging();
            String nextPage = communityQueryToken != null ? communityQueryToken.getNext() : null;
            $this$lastOrNull$iv = nextPage;
            if (!($this$lastOrNull$iv == null || $this$lastOrNull$iv.length() == 0)) {
                $this$lastOrNull$iv = communityId;
                if (!($this$lastOrNull$iv == null || $this$lastOrNull$iv.length() == 0)) {
                    $this$lastOrNull$iv = this$0.communityIdAndTokenMap;
                    Pair pair = Pair.create((Object)nextPage, (Object)false);
                    Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(nextPage, false)");
                    Pair pair2 = pair;
                    $this$lastOrNull$iv.put((String)communityId, (Pair<String, Boolean>)pair2);
                    if (this$0.communityIdSet.contains(communityId)) {
                        this$0.mapByCommunity(communityId);
                    }
                } else {
                    CommunityQueryRequest.CommunityQueryOptions options = new CommunityQueryRequest.CommunityQueryOptions(null, nextPage, 1, null);
                    this$0.call(options).subscribeOn(Schedulers.from((Executor)SINGLE_THREAD_EXECUTOR)).subscribe((CompletableObserver)this$0);
                }
            }
        }
    }

    private static final void call$lambda-10(EkoCommunityBoundaryCallback this$0, RetryWhen.ErrorAndDuration errorAndDuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)errorAndDuration, (String)"errorAndDuration");
        String string = this$0.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Object[] objectArray = new Object[]{errorAndDuration.durationMs()};
        AmityLog.INSTANCE.tag(string).e(errorAndDuration.throwable(), "an error occurred, back-off for durationMs:%s", objectArray);
    }

    static {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        SINGLE_THREAD_EXECUTOR = executorService;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ekoapp/ekosdk/internal/data/boundarycallback/EkoCommunityBoundaryCallback$Companion;", "", "()V", "SINGLE_THREAD_EXECUTOR", "Ljava/util/concurrent/Executor;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

