/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk;

import android.util.LruCache;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.MutableLiveData;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.socket.model.SocketRequest;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.SocketConnectionEvent;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public class EkoLiveData<T>
extends MediatorLiveData<T> {
    private static final String TAG = EkoLiveData.class.getName();
    private static final long LIVE_QUERY_EXPIRY = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
    private final MutableLiveData<DataStatus> dataStatus = new MutableLiveData();
    private final MutableLiveData<LoadingStatus> loadingStatus = new MutableLiveData();
    private final CompositeDisposable disposable = new CompositeDisposable();
    @Nullable
    private final Call<?> liveQueryCall;
    private static LruCache<SocketRequest, Long> lastQueryTimeMap = new LruCache<SocketRequest, Long>(100){

        protected Long create(SocketRequest request) {
            return 0L;
        }
    };

    private EkoLiveData(@NonNull LiveData<T> source, @NonNull T proxy, @Nullable Call liveQueryCall) {
        this.liveQueryCall = liveQueryCall;
        this.dataStatus.postValue((Object)DataStatus.NOT_EXIST);
        this.loadingStatus.postValue((Object)LoadingStatus.NOT_LOADING);
        this.addSource(source, item -> {
            if (item != null) {
                this.postValue(item);
                this.dataStatus.postValue((Object)(EkoLiveData.shouldCallLiveQuery(liveQueryCall) ? DataStatus.LOCAL : DataStatus.FRESH));
            } else {
                this.dataStatus.postValue((Object)DataStatus.NOT_EXIST);
            }
        });
    }

    public LiveData<DataStatus> getDataStatus() {
        return this.dataStatus;
    }

    public LiveData<LoadingStatus> getLoadingStatus() {
        return this.loadingStatus;
    }

    private static boolean shouldCallLiveQuery(@Nullable Call<?> call) {
        if (call == null) {
            return false;
        }
        SocketRequest request = call.getRequest();
        long lastSuccessQueryTime = (Long)lastQueryTimeMap.get((Object)request);
        AmityLog.INSTANCE.tag(TAG).d("request: %s lastSuccessQueryTime: %s", new Object[]{EkoGson.get().toJson((Object)request), lastSuccessQueryTime});
        AmityLog.INSTANCE.tag(TAG).d("lastQueryTimeMap: %s size: %s", new Object[]{lastQueryTimeMap, lastQueryTimeMap.size()});
        long now = System.currentTimeMillis();
        long timeSinceLastQuery = now - (Long)lastQueryTimeMap.get((Object)request);
        return timeSinceLastQuery > LIVE_QUERY_EXPIRY;
    }

    private void callLiveQueryIfNeeded(SocketConnectionEvent event, Call<?> call) {
        SocketRequest request = call.getRequest();
        if (EkoLiveData.shouldCallLiveQuery(call)) {
            if (event.isConnected()) {
                long lastSuccessQueryTime = (Long)lastQueryTimeMap.get((Object)request);
                AmityLog.INSTANCE.tag(TAG).i("restart live query: %s", new Object[]{request});
                EkoSocket.call(call).doOnSubscribe(disposable -> {
                    lastQueryTimeMap.put((Object)request, (Object)System.currentTimeMillis());
                    this.loadingStatus.postValue((Object)LoadingStatus.LOADING);
                }).doOnSuccess(ignored -> {
                    lastQueryTimeMap.put((Object)request, (Object)System.currentTimeMillis());
                    this.loadingStatus.postValue((Object)LoadingStatus.LOADED);
                }).doOnError(e -> {
                    lastQueryTimeMap.put((Object)request, (Object)lastSuccessQueryTime);
                    this.loadingStatus.postValue((Object)LoadingStatus.ERROR);
                }).subscribe();
            } else {
                AmityLog.INSTANCE.tag(TAG).e("live query expired but was not connected to socket", new Object[0]);
            }
        }
    }

    protected void onActive() {
        super.onActive();
        Call<?> call = this.liveQueryCall;
        if (call != null) {
            this.disposable.add(EkoSocket.connectionEvent().subscribeOn(Schedulers.io()).subscribe(event -> this.callLiveQueryIfNeeded((SocketConnectionEvent)event, call)));
        }
    }

    protected void onInactive() {
        super.onInactive();
        this.disposable.clear();
    }

    static <T> EkoLiveData<T> create(@NonNull LiveData<T> source, @NonNull T proxy, @Nullable Call liveQueryCall) {
        return new EkoLiveData<T>(source, proxy, liveQueryCall);
    }

    public static enum LoadingStatus {
        NOT_LOADING,
        LOADING,
        LOADED,
        ERROR;

    }

    public static enum DataStatus {
        NOT_EXIST,
        LOCAL,
        FRESH,
        ERROR;

    }
}

