/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.infra;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.AmityEndpoint;
import com.amity.socialcloud.sdk.core.encryption.AmityDBEncryption;
import com.amity.socialcloud.sdk.core.session.SessionStateManager;
import com.amity.socialcloud.sdk.core.session.component.DatabaseSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenRenewalSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenWatcherSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.UserSettingSessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.infra.AmityChannelReader;
import com.amity.socialcloud.sdk.infra.mqtt.AmityMqttClient;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.ekoapp.ekosdk.internal.api.EkoApi;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoApiKeyDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoHttpUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMqttUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoSocketUrlDao;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoMqttUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoSocketUrl;
import com.ekoapp.ekosdk.internal.init.AmityCoreSDKInitializer;
import com.ekoapp.ekosdk.internal.init.EkoSdkInitProvider;
import com.ekoapp.ekosdk.internal.util.AppContext;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.Objects;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.CompletableSubject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00042\b\b\u0002\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u000206J\b\u00107\u001a\u000208H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u00069"}, d2={"Lcom/amity/socialcloud/sdk/infra/CoreClient;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "getAppEventBus$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "setAppEventBus$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;)V", "mqttClient", "Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient;", "getMqttClient$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient;", "setMqttClient$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient;)V", "renewalManager", "Lcom/amity/socialcloud/sdk/core/session/component/TokenRenewalSessionComponent;", "getRenewalManager$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/session/component/TokenRenewalSessionComponent;", "setRenewalManager$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/session/component/TokenRenewalSessionComponent;)V", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "getSessionLifeCycleEventBus$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "setSessionLifeCycleEventBus$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;)V", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "getSessionStateEventBus$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "setSessionStateEventBus$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "sessionStateManager", "Lcom/amity/socialcloud/sdk/core/session/SessionStateManager;", "getSessionStateManager$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/session/SessionStateManager;", "setSessionStateManager$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/session/SessionStateManager;)V", "socketClient", "Lcom/ekoapp/ekosdk/internal/api/EkoSocket;", "getSocketClient$amity_sdk_release", "()Lcom/ekoapp/ekosdk/internal/api/EkoSocket;", "setSocketClient$amity_sdk_release", "(Lcom/ekoapp/ekosdk/internal/api/EkoSocket;)V", "setup", "Lio/reactivex/Completable;", "apiKey", "endpoint", "Lcom/amity/socialcloud/sdk/AmityEndpoint;", "dbEncryption", "Lcom/amity/socialcloud/sdk/core/encryption/AmityDBEncryption;", "setupSessionComponents", "", "amity-sdk_release"})
public final class CoreClient {
    @NotNull
    public static final CoreClient INSTANCE = new CoreClient();
    private static final String TAG = CoreClient.class.getName();
    @Nullable
    private static AmityMqttClient mqttClient;
    @Nullable
    private static EkoSocket socketClient;
    @Nullable
    private static TokenRenewalSessionComponent renewalManager;
    @Nullable
    private static SessionLifeCycleEventBus sessionLifeCycleEventBus;
    @Nullable
    private static AppEventBus appEventBus;
    @Nullable
    private static SessionStateEventBus sessionStateEventBus;
    @Nullable
    private static SessionStateManager sessionStateManager;

    private CoreClient() {
    }

    @Nullable
    public final AmityMqttClient getMqttClient$amity_sdk_release() {
        return mqttClient;
    }

    public final void setMqttClient$amity_sdk_release(@Nullable AmityMqttClient amityMqttClient) {
        mqttClient = amityMqttClient;
    }

    @Nullable
    public final EkoSocket getSocketClient$amity_sdk_release() {
        return socketClient;
    }

    public final void setSocketClient$amity_sdk_release(@Nullable EkoSocket ekoSocket) {
        socketClient = ekoSocket;
    }

    @Nullable
    public final TokenRenewalSessionComponent getRenewalManager$amity_sdk_release() {
        return renewalManager;
    }

    public final void setRenewalManager$amity_sdk_release(@Nullable TokenRenewalSessionComponent tokenRenewalSessionComponent) {
        renewalManager = tokenRenewalSessionComponent;
    }

    @Nullable
    public final SessionLifeCycleEventBus getSessionLifeCycleEventBus$amity_sdk_release() {
        return sessionLifeCycleEventBus;
    }

    public final void setSessionLifeCycleEventBus$amity_sdk_release(@Nullable SessionLifeCycleEventBus sessionLifeCycleEventBus) {
        CoreClient.sessionLifeCycleEventBus = sessionLifeCycleEventBus;
    }

    @Nullable
    public final AppEventBus getAppEventBus$amity_sdk_release() {
        return appEventBus;
    }

    public final void setAppEventBus$amity_sdk_release(@Nullable AppEventBus appEventBus) {
        CoreClient.appEventBus = appEventBus;
    }

    @Nullable
    public final SessionStateEventBus getSessionStateEventBus$amity_sdk_release() {
        return sessionStateEventBus;
    }

    public final void setSessionStateEventBus$amity_sdk_release(@Nullable SessionStateEventBus sessionStateEventBus) {
        CoreClient.sessionStateEventBus = sessionStateEventBus;
    }

    @Nullable
    public final SessionStateManager getSessionStateManager$amity_sdk_release() {
        return sessionStateManager;
    }

    public final void setSessionStateManager$amity_sdk_release(@Nullable SessionStateManager sessionStateManager) {
        CoreClient.sessionStateManager = sessionStateManager;
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey, @NotNull AmityEndpoint endpoint, @NotNull AmityDBEncryption dbEncryption) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)dbEncryption, (String)"dbEncryption");
        if (!EkoSdkInitProvider.Companion.isInitialized()) {
            Completable completable = Completable.never();
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"never()");
            return completable;
        }
        EkoPreconditions.checkValidId(apiKey, "apiKey");
        EkoDatabase.init(AppContext.get(), dbEncryption);
        UserDatabase.init(AppContext.get(), dbEncryption);
        CompletableSubject completableSubject = CompletableSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)completableSubject, (String)"create()");
        CompletableSubject result = completableSubject;
        EkoDatabase database = EkoDatabase.get();
        EkoHttpUrlDao httpUrlDao = database.httpUrlDao();
        EkoSocketUrlDao socketUrlDao = database.socketUrlDao();
        EkoMqttUrlDao mqttUrlDao = database.mqttUrlDao();
        String newHttpUrl = endpoint.getHttpEndpoint();
        String newSocketUrl = endpoint.getSocketEndpoint();
        String newMqttUrl = endpoint.getMqttEndpoint();
        EkoApiKeyDao apiKeyDao = EkoDatabase.get().apiKeyDao();
        Maybe.zip((MaybeSource)((MaybeSource)apiKeyDao.getCurrentApiKey()), (MaybeSource)((MaybeSource)httpUrlDao.getCurrentHttpUrl()), (MaybeSource)((MaybeSource)socketUrlDao.getCurrentSocketUrl()), (MaybeSource)((MaybeSource)mqttUrlDao.getCurrentMqttUrl()), CoreClient::setup$lambda-0).subscribeOn(Schedulers.io()).doOnSuccess(arg_0 -> CoreClient.setup$lambda-1(newHttpUrl, newSocketUrl, newMqttUrl, apiKey, httpUrlDao, socketUrlDao, mqttUrlDao, apiKeyDao, arg_0)).doOnComplete(() -> CoreClient.setup$lambda-2(httpUrlDao, newHttpUrl, socketUrlDao, newSocketUrl, mqttUrlDao, newMqttUrl, apiKeyDao, apiKey)).flatMapCompletable(CoreClient::setup$lambda-3).doOnError(CoreClient::setup$lambda-4).subscribe((CompletableObserver)result);
        this.setupSessionComponents();
        AmityChannelReader.init();
        Completable completable = result.hide();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"result.hide()");
        return completable;
    }

    public static /* synthetic */ Completable setup$default(CoreClient coreClient, String string, AmityEndpoint amityEndpoint, AmityDBEncryption amityDBEncryption, int n, Object object) {
        if ((n & 2) != 0) {
            amityEndpoint = AmityEndpoint.SG.INSTANCE;
        }
        if ((n & 4) != 0) {
            amityDBEncryption = AmityDBEncryption.NONE.INSTANCE;
        }
        return coreClient.setup(string, amityEndpoint, amityDBEncryption);
    }

    private final void setupSessionComponents() {
        if (sessionLifeCycleEventBus == null) {
            sessionLifeCycleEventBus = new SessionLifeCycleEventBus();
        }
        if (appEventBus == null) {
            appEventBus = new AppEventBus();
        }
        if (sessionStateEventBus == null) {
            sessionStateEventBus = new SessionStateEventBus();
        }
        if (sessionStateManager == null) {
            AppEventBus appEventBus = CoreClient.appEventBus;
            Intrinsics.checkNotNull((Object)appEventBus);
            AppEventBus appEventBus2 = appEventBus;
            SessionStateEventBus sessionStateEventBus = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus);
            SessionStateEventBus sessionStateEventBus2 = sessionStateEventBus;
            SessionLifeCycleEventBus sessionLifeCycleEventBus = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus);
            SessionLifeCycleEventBus sessionLifeCycleEventBus2 = sessionLifeCycleEventBus;
            sessionStateManager = new SessionStateManager(appEventBus2, sessionLifeCycleEventBus2, sessionStateEventBus2);
        }
        if (mqttClient == null || socketClient == null || renewalManager == null) {
            SessionLifeCycleEventBus sessionLifeCycleEventBus = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus);
            SessionStateEventBus sessionStateEventBus = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus);
            mqttClient = new AmityMqttClient(sessionLifeCycleEventBus, sessionStateEventBus);
            SessionLifeCycleEventBus sessionLifeCycleEventBus3 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus3);
            SessionStateEventBus sessionStateEventBus3 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus3);
            socketClient = new EkoSocket(sessionLifeCycleEventBus3, sessionStateEventBus3);
            AppEventBus appEventBus = CoreClient.appEventBus;
            Intrinsics.checkNotNull((Object)appEventBus);
            SessionLifeCycleEventBus sessionLifeCycleEventBus4 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus4);
            SessionStateEventBus sessionStateEventBus4 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus4);
            renewalManager = new TokenRenewalSessionComponent(appEventBus, sessionLifeCycleEventBus4, sessionStateEventBus4);
            SessionLifeCycleEventBus sessionLifeCycleEventBus5 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus5);
            SessionStateEventBus sessionStateEventBus5 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus5);
            new EkoApi(sessionLifeCycleEventBus5, sessionStateEventBus5);
            SessionLifeCycleEventBus sessionLifeCycleEventBus6 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus6);
            SessionStateEventBus sessionStateEventBus6 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus6);
            new DatabaseSessionComponent(sessionLifeCycleEventBus6, sessionStateEventBus6);
            SessionLifeCycleEventBus sessionLifeCycleEventBus7 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus7);
            SessionStateEventBus sessionStateEventBus7 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus7);
            new UserSettingSessionComponent(sessionLifeCycleEventBus7, sessionStateEventBus7);
            AppEventBus appEventBus3 = CoreClient.appEventBus;
            Intrinsics.checkNotNull((Object)appEventBus3);
            SessionLifeCycleEventBus sessionLifeCycleEventBus8 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus8);
            SessionStateEventBus sessionStateEventBus8 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus8);
            new TokenWatcherSessionComponent(appEventBus3, sessionLifeCycleEventBus8, sessionStateEventBus8);
        }
    }

    private static final Pair setup$lambda-0(EkoApiKey apiKey, EkoHttpUrl httpEntity, EkoSocketUrl socketEntity, EkoMqttUrl mqttEntity) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)httpEntity, (String)"httpEntity");
        Intrinsics.checkNotNullParameter((Object)socketEntity, (String)"socketEntity");
        Intrinsics.checkNotNullParameter((Object)mqttEntity, (String)"mqttEntity");
        String string = httpEntity.getHttpUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"httpEntity.httpUrl");
        String string2 = socketEntity.getSocketUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"socketEntity.socketUrl");
        String string3 = mqttEntity.getMqttUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"mqttEntity.mqttUrl");
        AmityEndpoint.CUSTOM storedEndpoint = new AmityEndpoint.CUSTOM(string, string2, string3);
        return new Pair((Object)apiKey, (Object)storedEndpoint);
    }

    private static final void setup$lambda-1(String $newHttpUrl, String $newSocketUrl, String $newMqttUrl, String $apiKey, EkoHttpUrlDao $httpUrlDao, EkoSocketUrlDao $socketUrlDao, EkoMqttUrlDao $mqttUrlDao, EkoApiKeyDao $apiKeyDao, Pair setupPair) {
        Intrinsics.checkNotNullParameter((Object)$newHttpUrl, (String)"$newHttpUrl");
        Intrinsics.checkNotNullParameter((Object)$newSocketUrl, (String)"$newSocketUrl");
        Intrinsics.checkNotNullParameter((Object)$newMqttUrl, (String)"$newMqttUrl");
        Intrinsics.checkNotNullParameter((Object)$apiKey, (String)"$apiKey");
        Intrinsics.checkNotNullParameter((Object)setupPair, (String)"setupPair");
        String string = ((EkoApiKey)setupPair.getFirst()).getApiKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"setupPair.first.apiKey");
        String storedApiKey = string;
        String storedHttpUrl = ((AmityEndpoint)setupPair.getSecond()).getHttpEndpoint();
        String storedSocketUrl = ((AmityEndpoint)setupPair.getSecond()).getSocketEndpoint();
        String storedMqttUrl = ((AmityEndpoint)setupPair.getSecond()).getMqttEndpoint();
        if (!(Objects.equal((Object)storedHttpUrl, (Object)$newHttpUrl) && Objects.equal((Object)storedSocketUrl, (Object)$newSocketUrl) && Objects.equal((Object)storedMqttUrl, (Object)$newMqttUrl) && Objects.equal((Object)storedApiKey, (Object)$apiKey))) {
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            Object[] objectArray = new Object[]{$apiKey, $newHttpUrl, $newSocketUrl, $newMqttUrl};
            AmityLog.INSTANCE.tag(string2).e("Setup value changed. new api key: %s new http url: %s new socket url: %s new mqtt url: %s", objectArray);
            String string3 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
            AmityLog.INSTANCE.tag(string3).e("deleting user database", new Object[0]);
            AmityCoreClient.INSTANCE.logout();
            $httpUrlDao.insert(EkoHttpUrl.create($newHttpUrl));
            $socketUrlDao.insert(EkoSocketUrl.create($newSocketUrl));
            $mqttUrlDao.insert(EkoMqttUrl.create($newMqttUrl));
            $apiKeyDao.insert(EkoApiKey.create($apiKey));
        }
        AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
    }

    private static final void setup$lambda-2(EkoHttpUrlDao $httpUrlDao, String $newHttpUrl, EkoSocketUrlDao $socketUrlDao, String $newSocketUrl, EkoMqttUrlDao $mqttUrlDao, String $newMqttUrl, EkoApiKeyDao $apiKeyDao, String $apiKey) {
        Intrinsics.checkNotNullParameter((Object)$newHttpUrl, (String)"$newHttpUrl");
        Intrinsics.checkNotNullParameter((Object)$newSocketUrl, (String)"$newSocketUrl");
        Intrinsics.checkNotNullParameter((Object)$newMqttUrl, (String)"$newMqttUrl");
        Intrinsics.checkNotNullParameter((Object)$apiKey, (String)"$apiKey");
        $httpUrlDao.insert(EkoHttpUrl.create($newHttpUrl));
        $socketUrlDao.insert(EkoSocketUrl.create($newSocketUrl));
        $mqttUrlDao.insert(EkoMqttUrl.create($newMqttUrl));
        $apiKeyDao.insert(EkoApiKey.create($apiKey));
        AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
    }

    private static final CompletableSource setup$lambda-3(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (CompletableSource)Completable.complete();
    }

    private static final void setup$lambda-4(Throwable it) {
        AmityLog.INSTANCE.tag("error").e(it);
    }
}

