/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoFollowDao;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFollowStatusEntity;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoFollowDao_Impl
extends EkoFollowDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoUserFollowStatusEntity> __insertionAdapterOfEkoUserFollowStatusEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<EkoUserFollowStatusEntity> __deletionAdapterOfEkoUserFollowStatusEntity;
    private final EntityDeletionOrUpdateAdapter<EkoUserFollowStatusEntity> __updateAdapterOfEkoUserFollowStatusEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfUpdateFollowing;
    private final SharedSQLiteStatement __preparedStmtOfUpdateFollower;

    public EkoFollowDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoUserFollowStatusEntity = new EntityInsertionAdapter<EkoUserFollowStatusEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `user_follow` (`id`,`sourceUserId`,`targetUserId`,`status`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoUserFollowStatusEntity value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getSourceUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSourceUserId());
                }
                if (value.getTargetUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTargetUserId());
                }
                if (value.getStatus() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getStatus());
                }
                String _tmp = EkoFollowDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = EkoFollowDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                String _tmp_2 = EkoFollowDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
            }
        };
        this.__deletionAdapterOfEkoUserFollowStatusEntity = new EntityDeletionOrUpdateAdapter<EkoUserFollowStatusEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `user_follow` WHERE `sourceUserId` = ? AND `targetUserId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoUserFollowStatusEntity value) {
                if (value.getSourceUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSourceUserId());
                }
                if (value.getTargetUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getTargetUserId());
                }
            }
        };
        this.__updateAdapterOfEkoUserFollowStatusEntity = new EntityDeletionOrUpdateAdapter<EkoUserFollowStatusEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `user_follow` SET `id` = ?,`sourceUserId` = ?,`targetUserId` = ?,`status` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `sourceUserId` = ? AND `targetUserId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoUserFollowStatusEntity value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getSourceUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSourceUserId());
                }
                if (value.getTargetUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTargetUserId());
                }
                if (value.getStatus() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getStatus());
                }
                String _tmp = EkoFollowDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = EkoFollowDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                String _tmp_2 = EkoFollowDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
                if (value.getSourceUserId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getSourceUserId());
                }
                if (value.getTargetUserId() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getTargetUserId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from user_follow";
                return "DELETE from user_follow";
            }
        };
        this.__preparedStmtOfUpdateFollowing = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE user_follow set status = ? where targetUserId = ?";
                return "UPDATE user_follow set status = ? where targetUserId = ?";
            }
        };
        this.__preparedStmtOfUpdateFollower = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE user_follow set status = ? where sourceUserId = ?";
                return "UPDATE user_follow set status = ? where sourceUserId = ?";
            }
        };
    }

    @Override
    public void insertImpl(EkoUserFollowStatusEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoUserFollowStatusEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends EkoUserFollowStatusEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoUserFollowStatusEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoUserFollowStatusEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoUserFollowStatusEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends EkoUserFollowStatusEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoUserFollowStatusEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(EkoUserFollowStatusEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoUserFollowStatusEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoUserFollowStatusEntity object) {
        this.__db.beginTransaction();
        try {
            EkoFollowDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends EkoUserFollowStatusEntity> objects) {
        this.__db.beginTransaction();
        try {
            EkoFollowDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoUserFollowStatusEntity object) {
        this.__db.beginTransaction();
        try {
            EkoFollowDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFollowing(String userId, String status) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateFollowing.acquire();
        int _argIndex = 1;
        if (status == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, status);
        }
        _argIndex = 2;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateFollowing.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFollower(String userId, String status) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateFollower.acquire();
        int _argIndex = 1;
        if (status == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, status);
        }
        _argIndex = 2;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateFollower.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EkoUserFollowStatusEntity getByIdNowImpl(String id) {
        String _sql = "SELECT * from user_follow where id = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from user_follow where id = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoUserFollowStatusEntity _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfSourceUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUserId");
            int _cursorIndexOfTargetUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetUserId");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                String _tmpSourceUserId = _cursor.isNull(_cursorIndexOfSourceUserId) ? null : _cursor.getString(_cursorIndexOfSourceUserId);
                String _tmpTargetUserId = _cursor.isNull(_cursorIndexOfTargetUserId) ? null : _cursor.getString(_cursorIndexOfTargetUserId);
                String _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : _cursor.getString(_cursorIndexOfStatus);
                _result = new EkoUserFollowStatusEntity(_tmpId, _tmpSourceUserId, _tmpTargetUserId, _tmpStatus);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            EkoUserFollowStatusEntity ekoUserFollowStatusEntity = _result;
            return ekoUserFollowStatusEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<EkoUserFollowStatusEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from user_follow where id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfSourceUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUserId");
            int _cursorIndexOfTargetUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetUserId");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<EkoUserFollowStatusEntity> _result = new ArrayList<EkoUserFollowStatusEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                String _tmpSourceUserId = _cursor.isNull(_cursorIndexOfSourceUserId) ? null : _cursor.getString(_cursorIndexOfSourceUserId);
                String _tmpTargetUserId = _cursor.isNull(_cursorIndexOfTargetUserId) ? null : _cursor.getString(_cursorIndexOfTargetUserId);
                String _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : _cursor.getString(_cursorIndexOfStatus);
                EkoUserFollowStatusEntity _item_1 = new EkoUserFollowStatusEntity(_tmpId, _tmpSourceUserId, _tmpTargetUserId, _tmpStatus);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _item_1.setExpiresAt(_tmpExpiresAt);
                _result.add(_item_1);
            }
            ArrayList<EkoUserFollowStatusEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<EkoUserFollowStatusEntity> getAllByIdImpl(String sourceUserId, String targetUserId) {
        String _sql = "SELECT * from user_follow where sourceUserId = ? and targetUserId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from user_follow where sourceUserId = ? and targetUserId = ? LIMIT 1", (int)2);
        int _argIndex = 1;
        if (sourceUserId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, sourceUserId);
        }
        _argIndex = 2;
        if (targetUserId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetUserId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_follow"}, (Callable)new Callable<EkoUserFollowStatusEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoUserFollowStatusEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoFollowDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoUserFollowStatusEntity _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfSourceUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUserId");
                    int _cursorIndexOfTargetUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetUserId");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        String _tmpSourceUserId = _cursor.isNull(_cursorIndexOfSourceUserId) ? null : _cursor.getString(_cursorIndexOfSourceUserId);
                        String _tmpTargetUserId = _cursor.isNull(_cursorIndexOfTargetUserId) ? null : _cursor.getString(_cursorIndexOfTargetUserId);
                        String _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : _cursor.getString(_cursorIndexOfStatus);
                        _result = new EkoUserFollowStatusEntity(_tmpId, _tmpSourceUserId, _tmpTargetUserId, _tmpStatus);
                        String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    EkoUserFollowStatusEntity ekoUserFollowStatusEntity = _result;
                    return ekoUserFollowStatusEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    DataSource.Factory<Integer, EkoUserFollowStatusEntity> getFollowersDataSourceImpl(String userId, List<String> statuses, String statusFilter) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from user_follow, follower_query_token where user_follow.targetUserId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and user_follow.status in (");
        int _inputSize = statuses.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and follower_query_token.userId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and follower_query_token.filter = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and follower_query_token.pageNumber = 1 and ((follower_query_token.ids like '%' || user_follow.id || '%') or (user_follow.updatedAt > follower_query_token.updatedAt))");
        String _sql = _stringBuilder.toString();
        int _argCount = 3 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 2;
        for (String _item : statuses) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 3 + _inputSize;
        if (statusFilter == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, statusFilter);
        }
        return new DataSource.Factory<Integer, EkoUserFollowStatusEntity>(){

            public LimitOffsetDataSource<EkoUserFollowStatusEntity> create() {
                return new LimitOffsetDataSource<EkoUserFollowStatusEntity>(EkoFollowDao_Impl.this.__db, _statement, false, true, new String[]{"user_follow", "follower_query_token"}){

                    protected List<EkoUserFollowStatusEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"id");
                        int _cursorIndexOfSourceUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sourceUserId");
                        int _cursorIndexOfTargetUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetUserId");
                        int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"status");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"expiresAt");
                        int _cursorIndexOfUpdatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<EkoUserFollowStatusEntity> _res = new ArrayList<EkoUserFollowStatusEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            String _tmpId = cursor.isNull(_cursorIndexOfId) ? null : cursor.getString(_cursorIndexOfId);
                            String _tmpSourceUserId = cursor.isNull(_cursorIndexOfSourceUserId) ? null : cursor.getString(_cursorIndexOfSourceUserId);
                            String _tmpTargetUserId = cursor.isNull(_cursorIndexOfTargetUserId) ? null : cursor.getString(_cursorIndexOfTargetUserId);
                            String _tmpStatus = cursor.isNull(_cursorIndexOfStatus) ? null : cursor.getString(_cursorIndexOfStatus);
                            EkoUserFollowStatusEntity _item_1 = new EkoUserFollowStatusEntity(_tmpId, _tmpSourceUserId, _tmpTargetUserId, _tmpStatus);
                            String _tmp = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                            _item_1.setCreatedAt(_tmpCreatedAt);
                            String _tmp_1 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                            _item_1.setUpdatedAt(_tmpUpdatedAt);
                            String _tmp_2 = cursor.isNull(_cursorIndexOfExpiresAt) ? null : cursor.getString(_cursorIndexOfExpiresAt);
                            DateTime _tmpExpiresAt = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                            _item_1.setExpiresAt(_tmpExpiresAt);
                            String _tmp_3 = cursor.isNull(_cursorIndexOfUpdatedAt_1) ? null : cursor.getString(_cursorIndexOfUpdatedAt_1);
                            DateTime _tmpUpdatedAt_1 = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                            _item_1.setUpdatedAt(_tmpUpdatedAt_1);
                            _res.add(_item_1);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, EkoUserFollowStatusEntity> getFollowingsDataSourceImpl(String userId, List<String> statuses, String statusFilter) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from user_follow, following_query_token where user_follow.sourceUserId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and user_follow.status in (");
        int _inputSize = statuses.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and following_query_token.userId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and following_query_token.filter = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and following_query_token.pageNumber = 1 and ((following_query_token.ids like '%' || user_follow.id || '%') or (user_follow.updatedAt > following_query_token.updatedAt))");
        String _sql = _stringBuilder.toString();
        int _argCount = 3 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 2;
        for (String _item : statuses) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 3 + _inputSize;
        if (statusFilter == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, statusFilter);
        }
        return new DataSource.Factory<Integer, EkoUserFollowStatusEntity>(){

            public LimitOffsetDataSource<EkoUserFollowStatusEntity> create() {
                return new LimitOffsetDataSource<EkoUserFollowStatusEntity>(EkoFollowDao_Impl.this.__db, _statement, false, true, new String[]{"user_follow", "following_query_token"}){

                    protected List<EkoUserFollowStatusEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"id");
                        int _cursorIndexOfSourceUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sourceUserId");
                        int _cursorIndexOfTargetUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetUserId");
                        int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"status");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"expiresAt");
                        int _cursorIndexOfUpdatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<EkoUserFollowStatusEntity> _res = new ArrayList<EkoUserFollowStatusEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            String _tmpId = cursor.isNull(_cursorIndexOfId) ? null : cursor.getString(_cursorIndexOfId);
                            String _tmpSourceUserId = cursor.isNull(_cursorIndexOfSourceUserId) ? null : cursor.getString(_cursorIndexOfSourceUserId);
                            String _tmpTargetUserId = cursor.isNull(_cursorIndexOfTargetUserId) ? null : cursor.getString(_cursorIndexOfTargetUserId);
                            String _tmpStatus = cursor.isNull(_cursorIndexOfStatus) ? null : cursor.getString(_cursorIndexOfStatus);
                            EkoUserFollowStatusEntity _item_1 = new EkoUserFollowStatusEntity(_tmpId, _tmpSourceUserId, _tmpTargetUserId, _tmpStatus);
                            String _tmp = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                            _item_1.setCreatedAt(_tmpCreatedAt);
                            String _tmp_1 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                            _item_1.setUpdatedAt(_tmpUpdatedAt);
                            String _tmp_2 = cursor.isNull(_cursorIndexOfExpiresAt) ? null : cursor.getString(_cursorIndexOfExpiresAt);
                            DateTime _tmpExpiresAt = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                            _item_1.setExpiresAt(_tmpExpiresAt);
                            String _tmp_3 = cursor.isNull(_cursorIndexOfUpdatedAt_1) ? null : cursor.getString(_cursorIndexOfUpdatedAt_1);
                            DateTime _tmpUpdatedAt_1 = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                            _item_1.setUpdatedAt(_tmpUpdatedAt_1);
                            _res.add(_item_1);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    Flowable<EkoUserFollowStatusEntity> getLatestFollowingImpl(String userId, List<String> statuses, DateTime now) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from user_follow where user_follow.sourceUserId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and user_follow.status in (");
        int _inputSize = statuses.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and user_follow.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" order by user_follow.updatedAt  desc limit 1");
        String _sql = _stringBuilder.toString();
        int _argCount = 2 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 2;
        for (String _item : statuses) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(now);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_follow"}, (Callable)new Callable<EkoUserFollowStatusEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoUserFollowStatusEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoFollowDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoUserFollowStatusEntity _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfSourceUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUserId");
                    int _cursorIndexOfTargetUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetUserId");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        String _tmpSourceUserId = _cursor.isNull(_cursorIndexOfSourceUserId) ? null : _cursor.getString(_cursorIndexOfSourceUserId);
                        String _tmpTargetUserId = _cursor.isNull(_cursorIndexOfTargetUserId) ? null : _cursor.getString(_cursorIndexOfTargetUserId);
                        String _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : _cursor.getString(_cursorIndexOfStatus);
                        _result = new EkoUserFollowStatusEntity(_tmpId, _tmpSourceUserId, _tmpTargetUserId, _tmpStatus);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    EkoUserFollowStatusEntity ekoUserFollowStatusEntity = _result;
                    return ekoUserFollowStatusEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    Flowable<EkoUserFollowStatusEntity> getLatestFollowerImpl(String userId, List<String> statuses, DateTime now) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from user_follow where user_follow.targetUserId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and user_follow.status in (");
        int _inputSize = statuses.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and user_follow.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" order by user_follow.updatedAt  desc limit 1");
        String _sql = _stringBuilder.toString();
        int _argCount = 2 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 2;
        for (String _item : statuses) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(now);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_follow"}, (Callable)new Callable<EkoUserFollowStatusEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoUserFollowStatusEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoFollowDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoUserFollowStatusEntity _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfSourceUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUserId");
                    int _cursorIndexOfTargetUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetUserId");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        String _tmpSourceUserId = _cursor.isNull(_cursorIndexOfSourceUserId) ? null : _cursor.getString(_cursorIndexOfSourceUserId);
                        String _tmpTargetUserId = _cursor.isNull(_cursorIndexOfTargetUserId) ? null : _cursor.getString(_cursorIndexOfTargetUserId);
                        String _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : _cursor.getString(_cursorIndexOfStatus);
                        _result = new EkoUserFollowStatusEntity(_tmpId, _tmpSourceUserId, _tmpTargetUserId, _tmpStatus);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoFollowDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    EkoUserFollowStatusEntity ekoUserFollowStatusEntity = _result;
                    return ekoUserFollowStatusEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

