/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.event;

import androidx.annotation.NonNull;
import com.amity.socialcloud.sdk.chat.data.message.MessageEventPersister;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto;
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto;
import com.ekoapp.ekosdk.internal.api.event.SocketEventListener;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.jakewharton.rxrelay2.PublishRelay;
import com.jakewharton.rxrelay2.Relay;
import hu.akarnokd.rxjava3.bridge.RxJavaBridge;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

abstract class MessageListener
extends SocketEventListener {
    private static final long BUFFER_TIME_SPAN_IN_MILLIS = 500L;
    private static final int BUFFER_MAX_COUNT = 100;
    private static final int RETAIN_MESSAGES_PER_CHANNEL = 1000;
    private final Gson gson = EkoGson.get();
    private final EkoMessageDao messageDao = UserDatabase.get().messageDao();
    private final Relay<MessageQueryDto> relay = PublishRelay.create();
    private final EkoChannelDao channelDao = UserDatabase.get().channelDao();
    private Predicate<List<MessageQueryDto>> hasItem = list -> !list.isEmpty();
    private Consumer<List<MessageQueryDto>> persist = list -> {
        MessageQueryDto dto = (MessageQueryDto)list.get(0);
        int size = list.size();
        if (size > 1) {
            List<EkoMessageDto> messages = dto.getMessages();
            List<EkoUserDto> users = dto.getUsers();
            for (int i = 1; i < size; ++i) {
                MessageQueryDto item = (MessageQueryDto)list.get(i);
                messages.addAll(item.getMessages());
                users.addAll(item.getUsers());
            }
        }
        RxJavaBridge.toV2Completable((Completable)new MessageEventPersister().persist(dto)).subscribeOn(Schedulers.io()).doOnError((Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
            }
        }).subscribe();
    };
    private Consumer<List<MessageQueryDto>> trim = list -> {
        EkoMessageDto dto = ((MessageQueryDto)list.get(0)).getMessages().get(0);
        String channelId = dto.getChannelId();
        this.messageDao.retainLatestFromChannel(channelId, 1000);
    };

    MessageListener() {
        this.relay.buffer(500L, TimeUnit.MILLISECONDS, Schedulers.io(), 100).filter(this.hasItem).doOnNext(this.persist).doOnNext(this.trim).subscribe();
    }

    @Override
    protected void onEvent(@NonNull String event, Object ... args) {
        super.onEvent(event, args);
        String json = args[0].toString();
        MessageQueryDto dto = (MessageQueryDto)this.gson.fromJson(json, MessageQueryDto.class);
        this.relay.accept((Object)dto);
        this.onMessageEvent(dto.getMessages());
    }

    private void onMessageEvent(@NonNull List<EkoMessageDto> messages) {
        ConcurrentMap channelIds = Maps.newConcurrentMap();
        for (EkoMessageDto message : messages) {
            String channelId = message.getChannelId();
            if (channelId == null) continue;
            channelIds.put(channelId, channelId);
        }
        for (String channelId : channelIds.values()) {
            this.channelDao.updateLastActivity(channelId, DateTime.now());
        }
    }
}

