/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.data.stream;

import androidx.arch.core.util.Function;
import androidx.paging.DataSource;
import androidx.paging.PagedList;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.video.data.stream.StreamLocalDataStore;
import com.amity.socialcloud.sdk.video.data.stream.StreamMediator;
import com.amity.socialcloud.sdk.video.data.stream.StreamModelMapper;
import com.amity.socialcloud.sdk.video.data.stream.StreamQueryPersister;
import com.amity.socialcloud.sdk.video.data.stream.StreamRemoteDataStore;
import com.amity.socialcloud.sdk.video.data.stream.StreamRepository;
import com.amity.socialcloud.sdk.video.data.stream.StreamRepositoryHelper;
import com.amity.socialcloud.sdk.video.model.AmityBroadcastResolution;
import com.amity.socialcloud.sdk.video.stream.AmityBroadcasterData;
import com.amity.socialcloud.sdk.video.stream.AmityStream;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.dto.EkoStreamDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoStreamListDto;
import com.ekoapp.ekosdk.internal.api.socket.request.CreateStreamRequest;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoStreamBoundaryCallback;
import com.ekoapp.ekosdk.internal.entity.EkoStreamEntity;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0007J>\u0010\f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\r0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015H\u0002\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J%\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u001e0\u001a2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015\u00a2\u0006\u0002\u0010\u001fJ%\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050!0\u001a2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015\u00a2\u0006\u0002\u0010\u001fJ\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\u0006\u0010\u0010\u001a\u00020\u0007\u00a8\u0006#"}, d2={"Lcom/amity/socialcloud/sdk/video/data/stream/StreamRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "createStream", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/video/stream/AmityStream;", "title", "", "description", "resolution", "Lcom/amity/socialcloud/sdk/video/model/AmityBroadcastResolution;", "thumbnailFileId", "createStreamBroadcaster", "Lkotlin/Pair;", "disposeVideoStreaming", "Lio/reactivex/rxjava3/core/Completable;", "streamId", "fetchStream", "getDefaultPageSize", "", "getFormattedStatuses", "", "statuses", "Lcom/amity/socialcloud/sdk/video/stream/AmityStream$Status;", "([Lcom/amity/socialcloud/sdk/video/stream/AmityStream$Status;)[Ljava/lang/String;", "getLatestSteam", "Lio/reactivex/rxjava3/core/Flowable;", "", "getStream", "getStreamCollection", "Landroidx/paging/PagedList;", "([Lcom/amity/socialcloud/sdk/video/stream/AmityStream$Status;)Lio/reactivex/rxjava3/core/Flowable;", "getStreamCollectionPagingData", "Landroidx/paging/PagingData;", "observeStream", "amity-sdk_release"})
public final class StreamRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<PagedList<AmityStream>> getStreamCollection(@NotNull AmityStream.Status[] statuses) {
        Intrinsics.checkNotNullParameter((Object)statuses, (String)"statuses");
        String[] statusArray = this.getFormattedStatuses(statuses);
        DataSource.Factory factory2 = new StreamLocalDataStore().getStreams(statusArray).map((Function1)getStreamCollection.factory.1.INSTANCE).map((Function1)getStreamCollection.factory.2.INSTANCE);
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)publishSubject, (String)"create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        EkoStreamBoundaryCallback boundaryCallback = new EkoStreamBoundaryCallback(statusArray, false, this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        return RxJava3BridgeExtensionsKt.toV3(this.createRxCollectionWithBoundaryCallback(factory2.map((Function)boundaryCallback), boundaryCallback));
    }

    @NotNull
    public final Flowable<PagingData<AmityStream>> getStreamCollectionPagingData(@NotNull AmityStream.Status[] statuses) {
        Intrinsics.checkNotNullParameter((Object)statuses, (String)"statuses");
        List statusList = ArraysKt.toList((Object[])this.getFormattedStatuses(statuses));
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null), null, new StreamMediator(statusList), (Function0)new Function0<PagingSource<Integer, EkoStreamEntity>>((List<String>)statusList){
            final /* synthetic */ List<String> $statusList;
            {
                this.$statusList = $statusList;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, EkoStreamEntity> invoke() {
                return new StreamLocalDataStore().getStreamsPagingSource(this.$statusList);
            }
        }, (ModelMapper)new StreamModelMapper(), 2, null);
        return RxJava3BridgeExtensionsKt.toV3(pagerCreator2.create());
    }

    @NotNull
    public final Flowable<AmityStream> observeStream(@NotNull String streamId) {
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        Flowable flowable = new StreamLocalDataStore().observeStream(streamId).map(StreamRepository::observeStream$lambda-0);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"StreamLocalDataStore().o\u2026r().map(it)\n            }");
        return flowable;
    }

    @NotNull
    public final Completable fetchStream(@NotNull String streamId) {
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        Completable completable = new StreamRemoteDataStore().getVideoStreaming(streamId).flatMapCompletable(StreamRepository::fetchStream$lambda-1);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"StreamRemoteDataStore().\u2026persist(it)\n            }");
        return completable;
    }

    @NotNull
    public final Single<AmityStream> createStream(@NotNull String title, @NotNull String description, @NotNull AmityBroadcastResolution resolution, @Nullable String thumbnailFileId) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
        CreateStreamRequest request = new CreateStreamRequest(title, description, resolution.getReadableName(), thumbnailFileId);
        Single single = new StreamRemoteDataStore().createVideoStreaming(request).flatMap(StreamRepository::createStream$lambda-2).map(arg_0 -> StreamRepository.createStream$lambda-3(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"StreamRemoteDataStore().\u2026tStream(it)\n            }");
        return single;
    }

    public static /* synthetic */ Single createStream$default(StreamRepository streamRepository, String string, String string2, AmityBroadcastResolution amityBroadcastResolution, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        return streamRepository.createStream(string, string2, amityBroadcastResolution, string3);
    }

    @NotNull
    public final Single<Pair<String, String>> createStreamBroadcaster(@NotNull String title, @NotNull String description, @NotNull AmityBroadcastResolution resolution, @Nullable String thumbnailFileId) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
        Single single = this.createStream(title, description, resolution, thumbnailFileId).map(StreamRepository::createStreamBroadcaster$lambda-4);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"createStream(title, desc\u2026castingUrl)\n            }");
        return single;
    }

    public static /* synthetic */ Single createStreamBroadcaster$default(StreamRepository streamRepository, String string, String string2, AmityBroadcastResolution amityBroadcastResolution, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        return streamRepository.createStreamBroadcaster(string, string2, amityBroadcastResolution, string3);
    }

    @NotNull
    public final Completable disposeVideoStreaming(@NotNull String streamId) {
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        Completable completable = new StreamRemoteDataStore().disposeVideoStreaming(streamId).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"StreamRemoteDataStore().\u2026streamId).ignoreElement()");
        return completable;
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getFormattedStatuses(AmityStream.Status[] statuses) {
        void $this$mapTo$iv$iv;
        Set statusSet = !(statuses.length == 0) ? ArraysKt.toSet((Object[])statuses) : SetsKt.setOf((Object)((Object)AmityStream.Status.IDLE));
        Iterable $this$map$iv = statusSet;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            AmityStream.Status status = (AmityStream.Status)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getApiKey());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AmityStream getStream(String streamId) {
        EkoStreamEntity ekoStreamEntity = new StreamLocalDataStore().getStream(streamId);
        if (ekoStreamEntity == null) return null;
        EkoStreamEntity it = ekoStreamEntity;
        boolean bl = false;
        EkoStreamEntity ekoStreamEntity2 = new StreamRepositoryHelper().attachDataToEntity(it);
        if (ekoStreamEntity2 == null) return null;
        it = ekoStreamEntity2;
        boolean bl2 = false;
        AmityStream amityStream = new StreamModelMapper().map(it);
        return amityStream;
    }

    @NotNull
    public final Flowable<AmityStream> getLatestSteam(@NotNull List<String> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        Flowable flowable = new StreamLocalDataStore().getLatestStream(statuses).map(new StreamModelMapper()::map);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"StreamLocalDataStore().g\u2026StreamModelMapper()::map)");
        return flowable;
    }

    private static final AmityStream observeStream$lambda-0(EkoStreamEntity it) {
        StreamModelMapper streamModelMapper = new StreamModelMapper();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return streamModelMapper.map(it);
    }

    private static final CompletableSource fetchStream$lambda-1(EkoStreamListDto it) {
        StreamQueryPersister streamQueryPersister = new StreamQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (CompletableSource)streamQueryPersister.persist(it);
    }

    private static final SingleSource createStream$lambda-2(EkoStreamListDto it) {
        StreamQueryPersister streamQueryPersister = new StreamQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (SingleSource)streamQueryPersister.persist(it).andThen((SingleSource)Single.just((Object)((EkoStreamDto)CollectionsKt.first(it.getStreams())).getStreamId()));
    }

    private static final AmityStream createStream$lambda-3(StreamRepository this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return this$0.getStream(it);
    }

    private static final Pair createStreamBroadcaster$lambda-4(AmityStream it) {
        String streamId = it.getStreamId();
        AmityBroadcasterData amityBroadcasterData = it.getBroadcasterData();
        String broadcastingUrl = amityBroadcasterData != null ? amityBroadcasterData.getUrl() : null;
        return TuplesKt.to((Object)streamId, (Object)broadcastingUrl);
    }
}

