/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.user;

import androidx.arch.core.util.Function;
import androidx.paging.DataSource;
import androidx.paging.PagedList;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.message.MessageLocalDataStore;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore;
import com.amity.socialcloud.sdk.core.data.user.UserModelMapper;
import com.amity.socialcloud.sdk.core.data.user.UserQueryPersister;
import com.amity.socialcloud.sdk.core.data.user.UserRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.user.paging.UserMediator;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.amity.socialcloud.sdk.core.error.AmityException;
import com.amity.socialcloud.sdk.core.user.AmityUser;
import com.amity.socialcloud.sdk.core.user.AmityUserSortOption;
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipLocalDataStore;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.AmityObjectRepository;
import com.ekoapp.ekosdk.UserEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto;
import com.ekoapp.ekosdk.internal.api.socket.request.UserUpdateRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.UserBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.UserDao;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.repository.user.UserUpdateOption;
import com.ekoapp.ekosdk.internal.repository.user.helper.UserComposerFunction;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\bJ$\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J$\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00160\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\bJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\n\u001a\u00020\bJ\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010 \u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bJ\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#\u00a8\u0006$"}, d2={"Lcom/amity/socialcloud/sdk/core/data/user/UserRepository;", "Lcom/ekoapp/ekosdk/AmityObjectRepository;", "Lcom/ekoapp/ekosdk/UserEntity;", "Lcom/amity/socialcloud/sdk/core/user/AmityUser;", "()V", "fetchAndSave", "Lio/reactivex/rxjava3/core/Completable;", "objectId", "", "flagUser", "userId", "getDefaultPageSize", "", "getUser", "getUserPagedList", "Lio/reactivex/Flowable;", "Landroidx/paging/PagedList;", "keyword", "sortBy", "Lcom/amity/socialcloud/sdk/core/user/AmityUserSortOption;", "getUserPagingData", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagingData;", "hasInLocal", "", "isFlaggedByMe", "Lio/reactivex/rxjava3/core/Single;", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "notifyUserUpdate", "observeFromCache", "queryFromCache", "unflagUser", "updateUser", "option", "Lcom/ekoapp/ekosdk/internal/repository/user/UserUpdateOption;", "amity-sdk_release"})
public final class UserRepository
extends AmityObjectRepository<UserEntity, AmityUser> {
    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new UserRemoteDataStore().getUser(objectId).flatMap(UserRepository::fetchAndSave$lambda-0).doOnSuccess(UserRepository::fetchAndSave$lambda-1).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"UserRemoteDataStore().ge\u2026         .ignoreElement()");
        return completable;
    }

    @Override
    @Nullable
    public UserEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new UserLocalDataStore().getUser(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<UserEntity, AmityUser> mapper() {
        return new UserModelMapper();
    }

    @Override
    @NotNull
    public Flowable<UserEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new UserLocalDataStore().observeUser(objectId);
    }

    @Deprecated(message="Use getUserPagingData instead")
    @NotNull
    public final io.reactivex.Flowable<PagedList<AmityUser>> getUserPagedList(@NotNull String keyword, @NotNull AmityUserSortOption sortBy) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        UserDao userDao = UserDatabase.get().userDao();
        Intrinsics.checkNotNullExpressionValue((Object)userDao, (String)"get().userDao()");
        UserDao userDao2 = userDao;
        DataSource.Factory<Integer, UserEntity> factory2 = userDao2.getDataSource(keyword, sortBy);
        UserBoundaryCallback boundaryCallback = new UserBoundaryCallback(keyword, sortBy.getApiKey(), this.getDefaultPageSize());
        return this.createRxCollectionWithBoundaryCallback(factory2.map((Function)new UserComposerFunction()), boundaryCallback);
    }

    @NotNull
    public final Flowable<PagingData<AmityUser>> getUserPagingData(@Nullable String keyword, @NotNull AmityUserSortOption sortBy) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, true, 0, 0, 0, 58, null), null, new UserMediator(keyword, sortBy), (Function0)new Function0<PagingSource<Integer, UserEntity>>(keyword, sortBy){
            final /* synthetic */ String $keyword;
            final /* synthetic */ AmityUserSortOption $sortBy;
            {
                this.$keyword = $keyword;
                this.$sortBy = $sortBy;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, UserEntity> invoke() {
                return new UserLocalDataStore().getUserPagingSource(this.$keyword, this.$sortBy);
            }
        }, (ModelMapper)new UserModelMapper(), 2, null);
        return RxJava3BridgeExtensionsKt.toV3(pagerCreator2.create());
    }

    @Nullable
    public final AmityUser getUser(@NotNull String userId) {
        AmityUser amityUser;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserEntity userEntity = new UserLocalDataStore().getUser(userId);
        if (userEntity != null) {
            UserEntity it = userEntity;
            boolean bl = false;
            amityUser = new UserModelMapper().map(it);
        } else {
            amityUser = null;
        }
        return amityUser;
    }

    @NotNull
    public final Single<AmityUser> updateUser(@NotNull String userId, @NotNull UserUpdateOption option) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        UserUpdateRequest request = new UserUpdateRequest(userId, option.getDisplayName(), option.getRoles(), option.getMetadata(), option.getAvatarFileId(), option.getAvatarCustomUrl(), option.getDescription());
        Single single = new UserRemoteDataStore().updateUser(request).flatMap(UserRepository::updateUser$lambda-3).map(arg_0 -> UserRepository.updateUser$lambda-4(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"UserRemoteDataStore().up\u2026getUser(it)\n            }");
        return single;
    }

    public final boolean hasInLocal(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return new UserLocalDataStore().getUser(userId) != null;
    }

    @NotNull
    public final Completable flagUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new UserRemoteDataStore().flagUser(userId).flatMapCompletable(arg_0 -> UserRepository.flagUser$lambda-5(this, userId, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"UserRemoteDataStore().fl\u2026te(userId))\n            }");
        return completable;
    }

    @NotNull
    public final Completable unflagUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new UserRemoteDataStore().unflagUser(userId).flatMapCompletable(arg_0 -> UserRepository.unflagUser$lambda-6(this, userId, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"UserRemoteDataStore().un\u2026te(userId))\n            }");
        return completable;
    }

    @NotNull
    public final Single<Boolean> isFlaggedByMe(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Single single = new UserRemoteDataStore().isFlaggedByMe(userId).map(UserRepository::isFlaggedByMe$lambda-7);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"UserRemoteDataStore().is\u2026\"isFlagByMe\").asBoolean }");
        return single;
    }

    private final Completable notifyUserUpdate(String userId) {
        Completable completable = Completable.fromAction(() -> UserRepository.notifyUserUpdate$lambda-8(userId));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026rUpdate(userId)\n        }");
        return completable;
    }

    private final int getDefaultPageSize() {
        return 20;
    }

    private static final SingleSource fetchAndSave$lambda-0(EkoUserListDto it) {
        UserQueryPersister userQueryPersister = new UserQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (SingleSource)userQueryPersister.persist(it).andThen((SingleSource)Single.just(it.getUsers()));
    }

    private static final void fetchAndSave$lambda-1(List it) {
        Collection collection = it;
        if (collection == null || collection.isEmpty()) {
            throw AmityException.Companion.create(AmityError.ITEM_NOT_FOUND.name(), null, AmityError.ITEM_NOT_FOUND);
        }
    }

    private static final SingleSource updateUser$lambda-3(EkoUserListDto it) {
        UserQueryPersister userQueryPersister = new UserQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Completable completable = userQueryPersister.persist(it);
        List<EkoUserDto> list = it.getUsers();
        Intrinsics.checkNotNullExpressionValue(list, (String)"it.users");
        return (SingleSource)completable.andThen((SingleSource)Single.just((Object)((EkoUserDto)CollectionsKt.first(list)).getUserId()));
    }

    private static final AmityUser updateUser$lambda-4(UserRepository this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return this$0.getUser(it);
    }

    private static final CompletableSource flagUser$lambda-5(UserRepository this$0, String $userId, EkoUserListDto it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        UserQueryPersister userQueryPersister = new UserQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (CompletableSource)userQueryPersister.persist(it).andThen((CompletableSource)this$0.notifyUserUpdate($userId));
    }

    private static final CompletableSource unflagUser$lambda-6(UserRepository this$0, String $userId, EkoUserListDto it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        UserQueryPersister userQueryPersister = new UserQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (CompletableSource)userQueryPersister.persist(it).andThen((CompletableSource)this$0.notifyUserUpdate($userId));
    }

    private static final Boolean isFlaggedByMe$lambda-7(JsonObject it) {
        return it.get("isFlagByMe").getAsBoolean();
    }

    private static final void notifyUserUpdate$lambda-8(String $userId) {
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        new MessageLocalDataStore().notifyUserUpdate($userId);
        new ChannelMembershipLocalDataStore().notifyUserUpdate($userId);
        new CommunityMembershipLocalDataStore().notifyUserUpdate($userId);
    }
}

