/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.Nullable;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Transaction;
import androidx.room.Update;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.data.model.EkoAccountCache;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import java.util.List;

@Dao
public abstract class EkoAccountDao {
    @Query(value="SELECT * from account")
    public abstract Flowable<List<EkoAccount>> getAll();

    @Query(value="SELECT * from account where userId = :userId LIMIT 1")
    public abstract Flowable<EkoAccount> getByIdFlowable(String var1);

    @Query(value="SELECT * from account where userId = :userId LIMIT 1")
    public abstract Maybe<EkoAccount> getByIdMaybe(String var1);

    public Flowable<EkoAccount> getCurrentAccountFlowable() {
        return this.getCurrentAccountFlowableImpl();
    }

    public Single<EkoAccount> getCurrentAccountSingle() {
        return this.getCurrentAccountFlowableImpl().firstOrError();
    }

    @Query(value="SELECT * from account  LIMIT 1")
    abstract Flowable<EkoAccount> getCurrentAccountFlowableImpl();

    @Query(value="SELECT * from account LIMIT 1")
    public abstract EkoAccount getCurrentAccountNow();

    @Insert(onConflict=1)
    abstract void insert(EkoAccount var1);

    @Update(onConflict=1)
    public abstract void update(EkoAccount var1);

    @Transaction
    public EkoAccount activateAccount(String userId) {
        EkoAccount account = this.createAccountIfNeed(userId);
        this.update(account);
        EkoAccountCache.setMyAccount(userId, account.getDeviceId());
        return account;
    }

    @Transaction
    public EkoAccount deactivateAccount(String userId) {
        return this.createAccountIfNeed(userId);
    }

    @Transaction
    public void logoutAccount(String userId) {
        this.clearAllUserData(userId);
    }

    private EkoAccount createAccountIfNeed(String userId) {
        EkoAccount account = this.getByIdNow(userId);
        if (account == null) {
            account = EkoAccount.create(userId);
            this.insert(account);
        }
        return account;
    }

    @Transaction
    public void clearAllUserData(String userId) {
        UserDatabase.get().clearAllTables();
        this.deleteAll();
        EkoAccountCache.get().clear();
    }

    @Delete
    public abstract void delete(EkoAccount var1);

    @Nullable
    @Query(value="SELECT * from account where userId = :userId LIMIT 1")
    abstract EkoAccount getByIdNow(String var1);

    @Query(value="DELETE from account")
    public abstract void deleteAll();
}

