/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.community;

import androidx.paging.DataSource;
import androidx.paging.PagedList;
import androidx.paging.Pager;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import androidx.paging.RemoteMediator;
import androidx.paging.rxjava3.PagingRx;
import co.amity.rxremotemediator.AmityQueryTokenDao;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.infra.retrofit.request.QueryOptionsRequestParams;
import com.amity.socialcloud.sdk.social.community.AmityCommunity;
import com.amity.socialcloud.sdk.social.community.AmityCommunityFilter;
import com.amity.socialcloud.sdk.social.community.AmityCommunitySortOption;
import com.amity.socialcloud.sdk.social.data.community.CommunityLocalDataStore;
import com.amity.socialcloud.sdk.social.data.community.CommunityModelMapper;
import com.amity.socialcloud.sdk.social.data.community.CommunityRemoteDataStore;
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository;
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository$WhenMappings;
import com.amity.socialcloud.sdk.social.feed.AmityFeedType;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.AmityObjectRepository;
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoCommunityBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityDao;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import com.ekoapp.ekosdk.internal.repository.community.CommunityPageKeyedRxRemoteMediator;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004Ju\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bJ\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\bJA\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010%JA\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030'0\u001c2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010%J\b\u0010(\u001a\u00020)H\u0002JC\u0010*\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00020+2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010,J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020)0\u001c2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u000200J\u0012\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0\u001cJ\u0012\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0\u001cJ\u000e\u00103\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u00104\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bJ\u0014\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000306H\u0016J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0012\u00108\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\bH\u0016Jo\u00109\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0017\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010:\u00a8\u0006;"}, d2={"Lcom/amity/socialcloud/sdk/social/data/community/CommunityRepository;", "Lcom/ekoapp/ekosdk/AmityObjectRepository;", "Lcom/ekoapp/ekosdk/internal/entity/CommunityEntity;", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunity;", "()V", "createCommunity", "Lio/reactivex/rxjava3/core/Single;", "displayName", "", "description", "categoryIds", "", "isPublic", "", "metadata", "Lcom/google/gson/JsonObject;", "userIds", "avatarFileId", "needApprovalOnPostCreation", "onlyAdminCanPost", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;Lcom/google/gson/JsonObject;Ljava/util/List;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lio/reactivex/rxjava3/core/Single;", "deleteCommunity", "Lio/reactivex/rxjava3/core/Completable;", "communityId", "fetchAndSave", "objectId", "getCommunityById", "getCommunityCollection", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagedList;", "keyword", "categoryId", "filter", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityFilter;", "sortBy", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunitySortOption;", "isDeleted", "(Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/social/community/AmityCommunityFilter;Lcom/amity/socialcloud/sdk/social/community/AmityCommunitySortOption;Ljava/lang/Boolean;)Lio/reactivex/rxjava3/core/Flowable;", "getCommunityPagingData", "Landroidx/paging/PagingData;", "getDefaultPageSize", "", "getFactory", "Landroidx/paging/DataSource$Factory;", "(Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/social/community/AmityCommunityFilter;Lcom/amity/socialcloud/sdk/social/community/AmityCommunitySortOption;Ljava/lang/Boolean;)Landroidx/paging/DataSource$Factory;", "getPostCount", "targetId", "feedType", "Lcom/amity/socialcloud/sdk/social/feed/AmityFeedType;", "getRecommendedCommunities", "getTrendingCommunities", "joinCommunity", "leaveCommunity", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "queryFromCache", "updateCommunity", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;Lcom/google/gson/JsonObject;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lio/reactivex/rxjava3/core/Single;", "amity-sdk_release"})
public final class CommunityRepository
extends AmityObjectRepository<CommunityEntity, AmityCommunity> {
    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new CommunityRemoteDataStore().getCommunity(objectId).flatMapCompletable((Function)fetchAndSave.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"CommunityRemoteDataStore\u2026persist(it)\n            }");
        return completable;
    }

    @Override
    @Nullable
    public CommunityEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new CommunityLocalDataStore().getCommunityById(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<CommunityEntity, AmityCommunity> mapper() {
        return new CommunityModelMapper();
    }

    @Override
    @NotNull
    public Flowable<CommunityEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new CommunityLocalDataStore().observeCommunity(objectId);
    }

    @NotNull
    public final Flowable<PagedList<AmityCommunity>> getCommunityCollection(@NotNull String keyword, @NotNull String categoryId, @NotNull AmityCommunityFilter filter, @NotNull AmityCommunitySortOption sortBy, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        DataSource.Factory factory2 = this.getFactory(keyword, categoryId, filter, sortBy, isDeleted).map((Function1)getCommunityCollection.factory.1.INSTANCE).map((Function1)getCommunityCollection.factory.2.INSTANCE);
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        EkoCommunityBoundaryCallback boundaryCallback = new EkoCommunityBoundaryCallback(keyword, categoryId, filter, sortBy, isDeleted, this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        return RxJava3BridgeExtensionsKt.toV3(this.createRxCollectionWithBoundaryCallback(factory2.map((androidx.arch.core.util.Function)boundaryCallback), boundaryCallback));
    }

    @NotNull
    public final Flowable<PagingData<AmityCommunity>> getCommunityPagingData(@NotNull String keyword, @NotNull String categoryId, @NotNull AmityCommunityFilter filter, @NotNull AmityCommunitySortOption sortBy, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        PagingConfig pagingConfig = new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null);
        AmityQueryTokenDao amityQueryTokenDao = UserDatabase.get().queryTokenDao();
        Intrinsics.checkNotNullExpressionValue((Object)amityQueryTokenDao, (String)"UserDatabase.get().queryTokenDao()");
        Pager pager2 = new Pager(pagingConfig, null, (RemoteMediator)new CommunityPageKeyedRxRemoteMediator(keyword, categoryId, filter, sortBy, isDeleted, amityQueryTokenDao), (Function0)new Function0<PagingSource<Integer, CommunityEntity>>(keyword, categoryId, filter, sortBy, isDeleted){
            final /* synthetic */ String $keyword;
            final /* synthetic */ String $categoryId;
            final /* synthetic */ AmityCommunityFilter $filter;
            final /* synthetic */ AmityCommunitySortOption $sortBy;
            final /* synthetic */ Boolean $isDeleted;

            @NotNull
            public final PagingSource<Integer, CommunityEntity> invoke() {
                return new CommunityLocalDataStore().getCommunityPagingSource(this.$keyword, this.$categoryId, this.$filter, this.$sortBy, this.$isDeleted);
            }
            {
                this.$keyword = string;
                this.$categoryId = string2;
                this.$filter = amityCommunityFilter;
                this.$sortBy = amityCommunitySortOption;
                this.$isDeleted = bl;
                super(0);
            }
        });
        Flowable flowable = PagingRx.getFlowable((Pager)pager2).map((Function)getCommunityPagingData.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"pager.flowable\n         \u2026      }\n                }");
        return flowable;
    }

    @NotNull
    public final Flowable<List<AmityCommunity>> getRecommendedCommunities() {
        Flowable flowable = new CommunityRemoteDataStore().getRecommendedCommunities(new QueryOptionsRequestParams(15, null, 2, null)).flatMap((Function)getRecommendedCommunities.1.INSTANCE).flatMapPublisher((Function)getRecommendedCommunities.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"CommunityRemoteDataStore\u2026          }\n            }");
        return flowable;
    }

    @NotNull
    public final Flowable<List<AmityCommunity>> getTrendingCommunities() {
        Flowable flowable = new CommunityRemoteDataStore().getTrendingCommunities(new QueryOptionsRequestParams(15, null, 2, null)).flatMap((Function)getTrendingCommunities.1.INSTANCE).flatMapPublisher((Function)getTrendingCommunities.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"CommunityRemoteDataStore\u2026          }\n            }");
        return flowable;
    }

    private final DataSource.Factory<Integer, CommunityEntity> getFactory(String keyword, String categoryId, AmityCommunityFilter filter, AmityCommunitySortOption sortBy, Boolean isDeleted) {
        DataSource.Factory<Integer, CommunityEntity> factory2;
        EkoCommunityDao communityDao = UserDatabase.get().communityDao();
        switch (CommunityRepository$WhenMappings.$EnumSwitchMapping$0[filter.ordinal()]) {
            case 1: {
                DataSource.Factory<Integer, CommunityEntity> factory3;
                CharSequence charSequence = categoryId;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    DataSource.Factory<Integer, CommunityEntity> factory4 = communityDao.getAllByKeywordForMember(keyword, sortBy, isDeleted);
                    factory3 = factory4;
                    Intrinsics.checkNotNullExpressionValue(factory4, (String)"communityDao.getAllByKey\u2026yword, sortBy, isDeleted)");
                } else {
                    DataSource.Factory<Integer, CommunityEntity> factory5 = communityDao.getAllByCategoryIdForMember(keyword, categoryId, sortBy, isDeleted);
                    factory3 = factory5;
                    Intrinsics.checkNotNullExpressionValue(factory5, (String)"communityDao.getAllByCat\u2026oryId, sortBy, isDeleted)");
                }
                return factory3;
            }
            case 2: {
                DataSource.Factory<Integer, CommunityEntity> factory6;
                CharSequence charSequence = categoryId;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    DataSource.Factory<Integer, CommunityEntity> factory7 = communityDao.getAllByKeywordForNonMember(keyword, sortBy, isDeleted);
                    factory6 = factory7;
                    Intrinsics.checkNotNullExpressionValue(factory7, (String)"communityDao.getAllByKey\u2026yword, sortBy, isDeleted)");
                } else {
                    DataSource.Factory<Integer, CommunityEntity> factory8 = communityDao.getAllByCategoryIdForNonMember(keyword, categoryId, sortBy, isDeleted);
                    factory6 = factory8;
                    Intrinsics.checkNotNullExpressionValue(factory8, (String)"communityDao.getAllByCat\u2026ted\n                    )");
                }
                return factory6;
            }
        }
        CharSequence charSequence = categoryId;
        boolean bl = false;
        if (charSequence.length() == 0) {
            DataSource.Factory<Integer, CommunityEntity> factory9 = communityDao.getAllByKeyword(keyword, sortBy, isDeleted);
            factory2 = factory9;
            Intrinsics.checkNotNullExpressionValue(factory9, (String)"communityDao.getAllByKey\u2026yword, sortBy, isDeleted)");
        } else {
            DataSource.Factory<Integer, CommunityEntity> factory10 = communityDao.getAllByCategoryId(keyword, categoryId, sortBy, isDeleted);
            factory2 = factory10;
            Intrinsics.checkNotNullExpressionValue(factory10, (String)"communityDao.getAllByCat\u2026oryId, sortBy, isDeleted)");
        }
        return factory2;
    }

    @NotNull
    public final Single<AmityCommunity> createCommunity(@NotNull String displayName, @Nullable String description, @Nullable List<String> categoryIds, @Nullable Boolean isPublic, @Nullable JsonObject metadata, @Nullable List<String> userIds, @Nullable String avatarFileId, @Nullable Boolean needApprovalOnPostCreation, @Nullable Boolean onlyAdminCanPost) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Single single = new CommunityRemoteDataStore().createCommunity(displayName, description, categoryIds, isPublic, metadata, userIds, avatarFileId, needApprovalOnPostCreation, onlyAdminCanPost).flatMap((Function)createCommunity.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"CommunityRemoteDataStore\u2026)\n            )\n        }");
        return single;
    }

    @NotNull
    public final Single<AmityCommunity> updateCommunity(@NotNull String communityId, @Nullable String displayName, @Nullable String description, @Nullable List<String> categoryIds, @Nullable Boolean isPublic, @Nullable JsonObject metadata, @Nullable String avatarFileId, @Nullable Boolean needApprovalOnPostCreation, @Nullable Boolean onlyAdminCanPost) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Single single = new CommunityRemoteDataStore().updateCommunity(communityId, displayName, description, categoryIds, isPublic, metadata, avatarFileId, needApprovalOnPostCreation, onlyAdminCanPost).flatMap((Function)updateCommunity.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"CommunityRemoteDataStore\u2026             ))\n        }");
        return single;
    }

    @Nullable
    public final AmityCommunity getCommunityById(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        CommunityEntity community = new CommunityLocalDataStore().getCommunityById(communityId);
        return community == null ? null : new CommunityModelMapper().map(community);
    }

    @NotNull
    public final Completable joinCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Completable completable = new CommunityRemoteDataStore().joinCommunity(communityId).flatMapCompletable((Function)joinCommunity.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"CommunityRemoteDataStore\u2026persist(it)\n            }");
        return completable;
    }

    @NotNull
    public final Completable leaveCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Completable completable = new CommunityRemoteDataStore().leaveCommunity(communityId).flatMapCompletable((Function)leaveCommunity.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"CommunityRemoteDataStore\u2026Persister().persist(it) }");
        return completable;
    }

    @NotNull
    public final Completable deleteCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Completable completable = new CommunityRemoteDataStore().deleteCommunity(communityId).flatMapCompletable((Function)new Function<EkoDeletionDto, CompletableSource>(communityId){
            final /* synthetic */ String $communityId;

            public final CompletableSource apply(EkoDeletionDto it) {
                EkoDeletionDto ekoDeletionDto = it;
                Intrinsics.checkNotNullExpressionValue((Object)ekoDeletionDto, (String)"it");
                boolean bl = ekoDeletionDto.isSuccess();
                return bl ? (CompletableSource)new CommunityLocalDataStore().deleteCommunity(this.$communityId) : (CompletableSource)Completable.complete();
            }
            {
                this.$communityId = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"CommunityRemoteDataStore\u2026          }\n            }");
        return completable;
    }

    @NotNull
    public final Flowable<Integer> getPostCount(@NotNull String targetId, @NotNull AmityFeedType feedType) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
        return new CommunityLocalDataStore().getPostCount(targetId, feedType);
    }

    private final int getDefaultPageSize() {
        return 15;
    }
}

