/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.boundarycallback;

import androidx.arch.core.util.Function;
import androidx.core.util.Pair;
import androidx.paging.PagedList;
import com.amity.socialcloud.sdk.core.reaction.AmityReaction;
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.ekoapp.core.utils.UtilsKt;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionAndUserListDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionQueryResultDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectMapper;
import com.ekoapp.ekosdk.internal.api.mapper.EkoReactionMapper;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.ReactionQueryConverter;
import com.ekoapp.ekosdk.internal.api.socket.call.ResponseConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.ReactionQueryRequest;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import com.github.davidmoten.rx2.RetryWhen;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.Subject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 ?2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0004:\u0001?B+\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u0002H\u0016J\u001c\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u0006H\u0002J&\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010+\u001a\u0004\u0018\u00010\u0006J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0006H\u0002J\b\u00102\u001a\u000200H\u0016J\u0010\u00103\u001a\u0002002\u0006\u00104\u001a\u000205H\u0016J\u0006\u00106\u001a\u000200J\u0010\u00107\u001a\u0002002\u0006\u00108\u001a\u00020\u0002H\u0016J\u0010\u00109\u001a\u0002002\u0006\u0010:\u001a\u00020\u0002H\u0016J\u0010\u0010;\u001a\u0002002\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u000200H\u0016R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R(\u0010\u0011\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\r0\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R2\u0010!\u001a&\u0012\f\u0012\n #*\u0004\u0018\u00010\u00060\u0006 #*\u0012\u0012\f\u0012\n #*\u0004\u0018\u00010\u00060\u0006\u0018\u00010$0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/ekoapp/ekosdk/internal/data/boundarycallback/AmityReactionBoundaryCallback;", "Landroidx/paging/PagedList$BoundaryCallback;", "Lcom/amity/socialcloud/sdk/core/reaction/AmityReaction;", "Lio/reactivex/CompletableObserver;", "Landroidx/arch/core/util/Function;", "referenceId", "", "referenceType", "Lcom/amity/socialcloud/sdk/core/reaction/ReactionReferenceType;", "pageSize", "", "delaySubject", "Lio/reactivex/subjects/Subject;", "", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/core/reaction/ReactionReferenceType;ILio/reactivex/subjects/Subject;)V", "getDelaySubject", "()Lio/reactivex/subjects/Subject;", "mapReactionIdAndToken", "", "Landroidx/core/util/Pair;", "mapper", "Lcom/ekoapp/ekosdk/internal/api/mapper/EkoObjectMapper;", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoReactionAndUserListDto;", "", "Lcom/ekoapp/ekosdk/internal/data/model/EkoReactionEntity;", "getMapper", "()Lcom/ekoapp/ekosdk/internal/api/mapper/EkoObjectMapper;", "getPageSize", "()I", "getReferenceId", "()Ljava/lang/String;", "getReferenceType", "()Lcom/amity/socialcloud/sdk/core/reaction/ReactionReferenceType;", "setOfReactionId", "", "kotlin.jvm.PlatformType", "", "apply", "input", "call", "Lio/reactivex/Completable;", "options", "Lcom/ekoapp/ekosdk/internal/api/socket/request/ReactionQueryRequest$ReactionQueryOptions;", "lastMapReactionId", "getConverter", "Lcom/ekoapp/ekosdk/internal/api/socket/call/ResponseConverter;", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoReactionQueryResultDto;", "mapByReaction", "", "reactionId", "onComplete", "onError", "e", "", "onFirstLoaded", "onItemAtEndLoaded", "itemAtEnd", "onItemAtFrontLoaded", "itemAtFront", "onSubscribe", "d", "Lio/reactivex/disposables/Disposable;", "onZeroItemsLoaded", "Companion", "amity-sdk_release"})
public final class AmityReactionBoundaryCallback
extends PagedList.BoundaryCallback<AmityReaction>
implements CompletableObserver,
Function<AmityReaction, AmityReaction> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String referenceId;
    @NotNull
    private final ReactionReferenceType referenceType;
    private final int pageSize;
    @NotNull
    private final Subject<Boolean> delaySubject;
    @NotNull
    private final Map<String, Pair<String, Boolean>> mapReactionIdAndToken;
    private final Set<String> setOfReactionId;
    @NotNull
    private static final Executor SINGLE_THREAD_EXECUTOR;

    public AmityReactionBoundaryCallback(@NotNull String referenceId, @NotNull ReactionReferenceType referenceType, int pageSize, @NotNull Subject<Boolean> delaySubject) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter(delaySubject, (String)"delaySubject");
        this.referenceId = referenceId;
        this.referenceType = referenceType;
        this.pageSize = pageSize;
        this.delaySubject = delaySubject;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"newConcurrentMap()");
        this.mapReactionIdAndToken = concurrentMap;
        this.setOfReactionId = Sets.newConcurrentHashSet();
        this.onFirstLoaded();
    }

    @NotNull
    public final String getReferenceId() {
        return this.referenceId;
    }

    @NotNull
    public final ReactionReferenceType getReferenceType() {
        return this.referenceType;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    @NotNull
    public final Subject<Boolean> getDelaySubject() {
        return this.delaySubject;
    }

    @NotNull
    public final EkoObjectMapper<EkoReactionAndUserListDto, List<EkoReactionEntity>> getMapper() {
        EkoReactionMapper ekoReactionMapper = EkoReactionMapper.MAPPER;
        Intrinsics.checkNotNullExpressionValue((Object)ekoReactionMapper, (String)"MAPPER");
        return ekoReactionMapper;
    }

    @NotNull
    public final ResponseConverter<EkoReactionQueryResultDto> getConverter(@NotNull String referenceId, @NotNull String referenceType, @Nullable String lastMapReactionId) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        return new ReactionQueryConverter(referenceId, referenceType, lastMapReactionId);
    }

    public void onItemAtFrontLoaded(@NotNull AmityReaction itemAtFront) {
        Intrinsics.checkNotNullParameter((Object)itemAtFront, (String)"itemAtFront");
    }

    public void onItemAtEndLoaded(@NotNull AmityReaction itemAtEnd) {
        Intrinsics.checkNotNullParameter((Object)itemAtEnd, (String)"itemAtEnd");
    }

    public void onZeroItemsLoaded() {
    }

    public final void onFirstLoaded() {
        String TAG = UtilsKt.getCurrentClassAndMethodNames();
        AmityLog.INSTANCE.tag(TAG).i("onFirstLoaded", new Object[0]);
        ReactionQueryRequest.ReactionQueryOptions options = new ReactionQueryRequest.ReactionQueryOptions(null, null, null, null, 15, null);
        options.setLimit(this.pageSize);
        AmityReactionBoundaryCallback.call$default(this, options, null, 2, null).doOnComplete(() -> AmityReactionBoundaryCallback.onFirstLoaded$lambda-0(this)).doOnError(arg_0 -> AmityReactionBoundaryCallback.onFirstLoaded$lambda-1(this, arg_0)).subscribeOn(Schedulers.from((Executor)SINGLE_THREAD_EXECUTOR)).subscribe((CompletableObserver)this);
    }

    @NotNull
    public AmityReaction apply(@NotNull AmityReaction input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.setOfReactionId.add(input.getReactionId());
        this.mapByReaction(input.getReactionId());
        return input;
    }

    private final void mapByReaction(String reactionId) {
        block1: {
            Pair<String, Boolean> pair = this.mapReactionIdAndToken.get(reactionId);
            if (pair == null) break block1;
            Pair<String, Boolean> tokenAndStatusNonNull = pair;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)tokenAndStatusNonNull.first;
            if (charSequence == null || charSequence.length() == 0 || Intrinsics.areEqual((Object)tokenAndStatusNonNull.second, (Object)true)) {
                return;
            }
            String TAG = UtilsKt.getCurrentClassAndMethodNames();
            AmityLog.INSTANCE.tag(TAG).i("map reactionId:" + reactionId, new Object[0]);
            ReactionQueryRequest.ReactionQueryOptions options = new ReactionQueryRequest.ReactionQueryOptions(null, null, null, null, 15, null);
            options.setToken((String)tokenAndStatusNonNull.first);
            this.call(options, reactionId).doOnSubscribe(arg_0 -> AmityReactionBoundaryCallback.mapByReaction$lambda-4$lambda-2(this, reactionId, tokenAndStatusNonNull, arg_0)).doOnError(arg_0 -> AmityReactionBoundaryCallback.mapByReaction$lambda-4$lambda-3(this, reactionId, tokenAndStatusNonNull, arg_0)).subscribeOn(Schedulers.from((Executor)SINGLE_THREAD_EXECUTOR)).subscribe((CompletableObserver)this);
        }
    }

    private final Completable call(ReactionQueryRequest.ReactionQueryOptions options, String lastMapReactionId) {
        ReactionQueryRequest reactionQueryRequest = new ReactionQueryRequest(null, null, null, 7, null);
        reactionQueryRequest.setReferenceId(this.referenceId);
        reactionQueryRequest.setReferenceType(this.referenceType.getValue());
        reactionQueryRequest.setOptions(options);
        Call<EkoReactionQueryResultDto> call = Call.create(reactionQueryRequest, this.getConverter(this.referenceId, this.referenceType.getValue(), lastMapReactionId));
        Intrinsics.checkNotNullExpressionValue(call, (String)"create(\n                \u2026ReactionId)\n            )");
        Completable completable = EkoSocket.Companion.call(call).doOnSuccess(arg_0 -> AmityReactionBoundaryCallback.call$lambda-5(this, arg_0)).retryWhen(RetryWhen.maxRetries((int)3).exponentialBackoff(1L, 10L, TimeUnit.SECONDS, 1.5).action(AmityReactionBoundaryCallback::call$lambda-6).build()).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(\n        \u2026         .ignoreElement()");
        return completable;
    }

    static /* synthetic */ Completable call$default(AmityReactionBoundaryCallback amityReactionBoundaryCallback, ReactionQueryRequest.ReactionQueryOptions reactionQueryOptions, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return amityReactionBoundaryCallback.call(reactionQueryOptions, string);
    }

    public void onSubscribe(@NotNull Disposable d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
    }

    public void onComplete() {
    }

    public void onError(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String TAG = UtilsKt.getCurrentClassAndMethodNames();
        AmityLog.INSTANCE.tag(TAG).e(e);
    }

    private static final void onFirstLoaded$lambda-0(AmityReactionBoundaryCallback this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.delaySubject.onComplete();
    }

    private static final void onFirstLoaded$lambda-1(AmityReactionBoundaryCallback this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.delaySubject.onComplete();
    }

    private static final void mapByReaction$lambda-4$lambda-2(AmityReactionBoundaryCallback this$0, String $reactionId, Pair $tokenAndStatusNonNull, Disposable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$reactionId, (String)"$reactionId");
        Intrinsics.checkNotNullParameter((Object)$tokenAndStatusNonNull, (String)"$tokenAndStatusNonNull");
        this$0.mapReactionIdAndToken.put($reactionId, (Pair<String, Boolean>)new Pair($tokenAndStatusNonNull.first, (Object)true));
    }

    private static final void mapByReaction$lambda-4$lambda-3(AmityReactionBoundaryCallback this$0, String $reactionId, Pair $tokenAndStatusNonNull, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$reactionId, (String)"$reactionId");
        Intrinsics.checkNotNullParameter((Object)$tokenAndStatusNonNull, (String)"$tokenAndStatusNonNull");
        this$0.mapReactionIdAndToken.put($reactionId, (Pair<String, Boolean>)new Pair($tokenAndStatusNonNull.first, (Object)false));
    }

    private static final void call$lambda-5(AmityReactionBoundaryCallback this$0, EkoReactionQueryResultDto dto) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        List<EkoReactionEntity> reactionList = this$0.getMapper().map(dto.getResults());
        Intrinsics.checkNotNullExpressionValue(reactionList, (String)"reactionList");
        if (!((Collection)reactionList).isEmpty()) {
            EkoReactionEntity reaction = reactionList.get(reactionList.size() - 1);
            String string = reaction.getReactionId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reaction.getReactionId()");
            String lastObtainReactionId = string;
            Map<String, Pair<String, Boolean>> map = this$0.mapReactionIdAndToken;
            String string2 = dto.getToken().getNext();
            if (string2 == null) {
                string2 = "";
            }
            Pair pair = Pair.create((Object)string2, (Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(dto.token.next ?: \"\", false)");
            Pair pair2 = pair;
            map.put(lastObtainReactionId, (Pair<String, Boolean>)pair2);
            if (this$0.setOfReactionId.contains(lastObtainReactionId)) {
                this$0.mapByReaction(lastObtainReactionId);
            }
        }
    }

    private static final void call$lambda-6(RetryWhen.ErrorAndDuration errorAndDuration) {
        Intrinsics.checkNotNullParameter((Object)errorAndDuration, (String)"errorAndDuration");
        Object[] objectArray = new Object[]{errorAndDuration.durationMs()};
        AmityLog.INSTANCE.tag(UtilsKt.getCurrentClassAndMethodNames()).e(errorAndDuration.throwable(), "an error occurred, back-off for durationMs:%s", objectArray);
    }

    static {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        SINGLE_THREAD_EXECUTOR = executorService;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ekoapp/ekosdk/internal/data/boundarycallback/AmityReactionBoundaryCallback$Companion;", "", "()V", "SINGLE_THREAD_EXECUTOR", "Ljava/util/concurrent/Executor;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

