/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.http;

import android.util.Log;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.amity.socialcloud.sdk.core.error.AmityException;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/ekoapp/ekosdk/internal/api/http/AmityErrorInterceptor;", "Lokhttp3/Interceptor;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "getSessionStateEventBus", "()Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "amity-sdk_release"})
public final class AmityErrorInterceptor
implements Interceptor {
    @NotNull
    private final SessionStateEventBus sessionStateEventBus;

    public AmityErrorInterceptor(@NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        this.sessionStateEventBus = sessionStateEventBus;
    }

    @NotNull
    public final SessionStateEventBus getSessionStateEventBus() {
        return this.sessionStateEventBus;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Response response = chain.proceed(chain.request().newBuilder().removeHeader("Accept-Encoding").build());
        Response response2 = response;
        if (!response2.isSuccessful()) {
            AmityException amityError = AmityException.Companion.fromResponse(response2);
            if (amityError.getCode() == AmityError.UNAUTHORIZED_ERROR.getCode() || amityError.getCode() == AmityError.USER_IS_GLOBAL_BANNED.getCode()) {
                this.sessionStateEventBus.publish(new SessionState.Terminated(amityError));
            }
            Log.e((String)"SSM3", (String)("<-- HTTP FAILED: " + amityError.getCode()));
        }
        return response2;
    }
}

