/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.AmityEndpoint;
import com.amity.socialcloud.sdk.core.AmityConnectionState;
import com.amity.socialcloud.sdk.core.AmityGlobalBanEvent;
import com.amity.socialcloud.sdk.core.authen.UserRegistration;
import com.amity.socialcloud.sdk.core.domain.notification.RegisterDeviceForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.notification.UnregisterAllUsersForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.notification.UnregisterDeviceForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.session.ActiveUserIdGetUseCase;
import com.amity.socialcloud.sdk.core.domain.session.DisconnectUseCase;
import com.amity.socialcloud.sdk.core.domain.session.LogoutUseCase;
import com.amity.socialcloud.sdk.core.events.AmityTopic;
import com.amity.socialcloud.sdk.core.events.AmityTopicSubscription;
import com.amity.socialcloud.sdk.core.file.AmityFileRepository;
import com.amity.socialcloud.sdk.core.permission.AmityPermission;
import com.amity.socialcloud.sdk.core.permission.AmityPermissionValidator;
import com.amity.socialcloud.sdk.core.user.AmityUser;
import com.amity.socialcloud.sdk.core.user.AmityUserNotification;
import com.amity.socialcloud.sdk.core.user.AmityUserRepository;
import com.amity.socialcloud.sdk.core.user.AmityUserUpdate;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.streamapi.AmityClientConfiguration;
import com.amity.socialcloud.sdk.streamapi.StreamFunctionInterface;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.AmityContentCheck;
import com.ekoapp.ekosdk.StreamFunction;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoApiKeyDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoHttpUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMqttUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoSocketUrlDao;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoMqttUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoSocketUrl;
import com.ekoapp.ekosdk.internal.init.AmityCoreSDKInitializer;
import com.ekoapp.ekosdk.internal.init.EkoSdkInitProvider;
import com.ekoapp.ekosdk.internal.usecase.content.GetContentCheckUseCase;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.Objects;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Single;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Function4;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.CompletableSubject;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0012J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012J\r\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0006\u0010\u001e\u001a\u00020\u0004J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0004J\u0006\u0010&\u001a\u00020\rJ\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020\rJ\u000e\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\u0004J\u0016\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u000201J \u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0004H\u0007J\u000e\u00104\u001a\u0002052\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u00020\rJ\u000e\u00108\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u0004J\u0006\u00109\u001a\u00020:R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006;"}, d2={"Lcom/amity/socialcloud/sdk/AmityCoreClient;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "millisTimeDiff", "", "getMillisTimeDiff$amity_sdk_release", "()I", "setMillisTimeDiff$amity_sdk_release", "(I)V", "disconnect", "Lio/reactivex/Completable;", "getAmityCoreSdkVersion", "getConfiguration", "Lcom/amity/socialcloud/sdk/streamapi/AmityClientConfiguration;", "getConnectionState", "Lio/reactivex/Flowable;", "Lcom/amity/socialcloud/sdk/core/AmityConnectionState;", "getContentCheck", "Lio/reactivex/Single;", "Lcom/ekoapp/ekosdk/AmityContentCheck;", "getCurrentUser", "Lcom/amity/socialcloud/sdk/core/user/AmityUser;", "getGlobalBanEvents", "Lcom/amity/socialcloud/sdk/core/AmityGlobalBanEvent;", "getServerTime", "Lorg/joda/time/DateTime;", "getServerTime$amity_sdk_release", "getUserId", "hasPermission", "Lcom/amity/socialcloud/sdk/core/permission/AmityPermissionValidator;", "permission", "Lcom/amity/socialcloud/sdk/core/permission/AmityPermission;", "login", "Lcom/amity/socialcloud/sdk/core/authen/UserRegistration$Builder;", "userId", "logout", "newFileRepository", "Lcom/amity/socialcloud/sdk/core/file/AmityFileRepository;", "newUserRepository", "Lcom/amity/socialcloud/sdk/core/user/AmityUserRepository;", "notification", "Lcom/amity/socialcloud/sdk/core/user/AmityUserNotification;", "registerDeviceForPushNotification", "setup", "apiKey", "endpoint", "Lcom/amity/socialcloud/sdk/AmityEndpoint;", "httpEndpoint", "socketEndpoint", "subscription", "Lcom/amity/socialcloud/sdk/core/events/AmityTopicSubscription;", "topic", "Lcom/amity/socialcloud/sdk/core/events/AmityTopic;", "unregisterDeviceForPushNotification", "updateUser", "Lcom/amity/socialcloud/sdk/core/user/AmityUserUpdate$Builder;", "amity-sdk_release"})
public final class AmityCoreClient {
    private static final String TAG;
    private static int millisTimeDiff;
    @NotNull
    public static final AmityCoreClient INSTANCE;

    public final int getMillisTimeDiff$amity_sdk_release() {
        return millisTimeDiff;
    }

    public final void setMillisTimeDiff$amity_sdk_release(int n) {
        millisTimeDiff = n;
    }

    @NotNull
    public final DateTime getServerTime$amity_sdk_release() {
        DateTime dateTime = DateTime.now().plusMillis(millisTimeDiff);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"DateTime.now().plusMillis(millisTimeDiff)");
        return dateTime;
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey, @NotNull AmityEndpoint endpoint) {
        EkoApiKeyDao apiKeyDao;
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        if (!EkoSdkInitProvider.Companion.isInitialized()) {
            Completable completable = Completable.never();
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.never()");
            return completable;
        }
        EkoPreconditions.checkValidId(apiKey, "apiKey");
        CompletableSubject completableSubject = CompletableSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)completableSubject, (String)"CompletableSubject.create()");
        CompletableSubject result = completableSubject;
        EkoDatabase database = EkoDatabase.get();
        EkoHttpUrlDao httpUrlDao = database.httpUrlDao();
        EkoSocketUrlDao socketUrlDao = database.socketUrlDao();
        EkoMqttUrlDao mqttUrlDao = database.mqttUrlDao();
        String newHttpUrl = endpoint.getHttpEndpoint();
        String newSocketUrl = endpoint.getSocketEndpoint();
        String newMqttUrl = endpoint.getMqttEndpoint();
        EkoApiKeyDao ekoApiKeyDao = apiKeyDao = EkoDatabase.get().apiKeyDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoApiKeyDao, (String)"apiKeyDao");
        MaybeSource maybeSource = (MaybeSource)ekoApiKeyDao.getCurrentApiKey();
        EkoHttpUrlDao ekoHttpUrlDao = httpUrlDao;
        Intrinsics.checkNotNullExpressionValue((Object)ekoHttpUrlDao, (String)"httpUrlDao");
        MaybeSource maybeSource2 = (MaybeSource)ekoHttpUrlDao.getCurrentHttpUrl();
        EkoSocketUrlDao ekoSocketUrlDao = socketUrlDao;
        Intrinsics.checkNotNullExpressionValue((Object)ekoSocketUrlDao, (String)"socketUrlDao");
        MaybeSource maybeSource3 = (MaybeSource)ekoSocketUrlDao.getCurrentSocketUrl();
        EkoMqttUrlDao ekoMqttUrlDao = mqttUrlDao;
        Intrinsics.checkNotNullExpressionValue((Object)ekoMqttUrlDao, (String)"mqttUrlDao");
        Maybe.zip((MaybeSource)maybeSource, (MaybeSource)maybeSource2, (MaybeSource)maybeSource3, (MaybeSource)((MaybeSource)ekoMqttUrlDao.getCurrentMqttUrl()), (Function4)setup.1.INSTANCE).subscribeOn(Schedulers.io()).doOnSuccess((Consumer)new Consumer<Pair<? extends EkoApiKey, ? extends AmityEndpoint.CUSTOM>>(newHttpUrl, newSocketUrl, newMqttUrl, apiKey, httpUrlDao, socketUrlDao, mqttUrlDao, apiKeyDao){
            final /* synthetic */ String $newHttpUrl;
            final /* synthetic */ String $newSocketUrl;
            final /* synthetic */ String $newMqttUrl;
            final /* synthetic */ String $apiKey;
            final /* synthetic */ EkoHttpUrlDao $httpUrlDao;
            final /* synthetic */ EkoSocketUrlDao $socketUrlDao;
            final /* synthetic */ EkoMqttUrlDao $mqttUrlDao;
            final /* synthetic */ EkoApiKeyDao $apiKeyDao;

            public final void accept(@NotNull Pair<? extends EkoApiKey, ? extends AmityEndpoint> setupPair) {
                Intrinsics.checkNotNullParameter(setupPair, (String)"setupPair");
                String string = ((EkoApiKey)setupPair.getFirst()).getApiKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"setupPair.first.apiKey");
                String storedApiKey = string;
                String storedHttpUrl = ((AmityEndpoint)setupPair.getSecond()).getHttpEndpoint();
                String storedSocketUrl = ((AmityEndpoint)setupPair.getSecond()).getSocketEndpoint();
                String storedMqttUrl = ((AmityEndpoint)setupPair.getSecond()).getMqttEndpoint();
                if (!(Objects.equal((Object)storedHttpUrl, (Object)this.$newHttpUrl) && Objects.equal((Object)storedSocketUrl, (Object)this.$newSocketUrl) && Objects.equal((Object)storedMqttUrl, (Object)this.$newMqttUrl) && Objects.equal((Object)storedApiKey, (Object)this.$apiKey))) {
                    String string2 = AmityCoreClient.access$getTAG$p(AmityCoreClient.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
                    AmityLog.INSTANCE.tag(string2).e("Setup value changed. new api key: %s new http url: %s new socket url: %s new mqtt url: %s", new Object[]{this.$apiKey, this.$newHttpUrl, this.$newSocketUrl, this.$newMqttUrl});
                    String string3 = AmityCoreClient.access$getTAG$p(AmityCoreClient.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
                    AmityLog.INSTANCE.tag(string3).e("deleting user database", new Object[0]);
                    AmityCoreClient.INSTANCE.logout();
                    this.$httpUrlDao.insert(EkoHttpUrl.create(this.$newHttpUrl));
                    this.$socketUrlDao.insert(EkoSocketUrl.create(this.$newSocketUrl));
                    this.$mqttUrlDao.insert(EkoMqttUrl.create(this.$newMqttUrl));
                    this.$apiKeyDao.insert(EkoApiKey.create(this.$apiKey));
                }
                AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
            }
            {
                this.$newHttpUrl = string;
                this.$newSocketUrl = string2;
                this.$newMqttUrl = string3;
                this.$apiKey = string4;
                this.$httpUrlDao = ekoHttpUrlDao;
                this.$socketUrlDao = ekoSocketUrlDao;
                this.$mqttUrlDao = ekoMqttUrlDao;
                this.$apiKeyDao = ekoApiKeyDao;
            }
        }).doOnComplete(new Action(httpUrlDao, newHttpUrl, socketUrlDao, newSocketUrl, mqttUrlDao, newMqttUrl, apiKeyDao, apiKey){
            final /* synthetic */ EkoHttpUrlDao $httpUrlDao;
            final /* synthetic */ String $newHttpUrl;
            final /* synthetic */ EkoSocketUrlDao $socketUrlDao;
            final /* synthetic */ String $newSocketUrl;
            final /* synthetic */ EkoMqttUrlDao $mqttUrlDao;
            final /* synthetic */ String $newMqttUrl;
            final /* synthetic */ EkoApiKeyDao $apiKeyDao;
            final /* synthetic */ String $apiKey;

            public final void run() {
                this.$httpUrlDao.insert(EkoHttpUrl.create(this.$newHttpUrl));
                this.$socketUrlDao.insert(EkoSocketUrl.create(this.$newSocketUrl));
                this.$mqttUrlDao.insert(EkoMqttUrl.create(this.$newMqttUrl));
                this.$apiKeyDao.insert(EkoApiKey.create(this.$apiKey));
                AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
            }
            {
                this.$httpUrlDao = ekoHttpUrlDao;
                this.$newHttpUrl = string;
                this.$socketUrlDao = ekoSocketUrlDao;
                this.$newSocketUrl = string2;
                this.$mqttUrlDao = ekoMqttUrlDao;
                this.$newMqttUrl = string3;
                this.$apiKeyDao = ekoApiKeyDao;
                this.$apiKey = string4;
            }
        }).flatMapCompletable((Function)setup.4.INSTANCE).subscribe((CompletableObserver)result);
        Completable completable = result.hide();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"result.hide()");
        return completable;
    }

    /*
     * Unable to fully structure code
     */
    @Deprecated(message="please use setup(apiKey: String, endpoint: AmityEndpoint) instead")
    @NotNull
    public final Completable setup(@NotNull String apiKey, @NotNull String httpEndpoint, @NotNull String socketEndpoint) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Intrinsics.checkNotNullParameter((Object)httpEndpoint, (String)"httpEndpoint");
            Intrinsics.checkNotNullParameter((Object)socketEndpoint, (String)"socketEndpoint");
            var5_4 = httpEndpoint;
            switch (var5_4.hashCode()) {
                case 2126050090: {
                    if (!var5_4.equals("https://api.us.amity.co/")) ** break;
                    break;
                }
                case 761791164: {
                    if (!var5_4.equals("https://api.eu.amity.co/")) ** break;
                    v0 = "ssq.eu.amity.co";
                    break block4;
                }
            }
            v0 = "ssq.us.amity.co";
            break block4;
            v0 = "ssq.sg.amity.co";
        }
        mqttEndpoint = v0;
        return this.setup(apiKey, new AmityEndpoint.CUSTOM(httpEndpoint, socketEndpoint, mqttEndpoint));
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return this.setup(apiKey, AmityEndpoint.SG.INSTANCE);
    }

    @NotNull
    public final Completable registerDeviceForPushNotification() {
        return RxJava3BridgeExtensionsKt.toV2(new RegisterDeviceForNotificationUseCase().execute());
    }

    @NotNull
    public final Completable unregisterDeviceForPushNotification() {
        return RxJava3BridgeExtensionsKt.toV2(new UnregisterAllUsersForNotificationUseCase().execute());
    }

    @NotNull
    public final Completable unregisterDeviceForPushNotification(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return RxJava3BridgeExtensionsKt.toV2(new UnregisterDeviceForNotificationUseCase().execute(userId));
    }

    @NotNull
    public final Completable disconnect() {
        return RxJava3BridgeExtensionsKt.toV2(new DisconnectUseCase().execute());
    }

    @NotNull
    public final UserRegistration.Builder login(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return new UserRegistration.Builder(userId);
    }

    @NotNull
    public final Completable logout() {
        return RxJava3BridgeExtensionsKt.toV2(new LogoutUseCase().execute());
    }

    @NotNull
    public final String getUserId() {
        return new ActiveUserIdGetUseCase().execute();
    }

    @NotNull
    public final AmityUserUpdate.Builder updateUser() {
        return new AmityUserUpdate.Builder(this.getUserId());
    }

    @NotNull
    public final AmityPermissionValidator hasPermission(@NotNull AmityPermission permission) {
        Intrinsics.checkNotNullParameter((Object)((Object)permission), (String)"permission");
        return new AmityPermissionValidator(permission);
    }

    @NotNull
    public final Flowable<AmityUser> getCurrentUser() {
        return this.newUserRepository().getCurrentUser();
    }

    @NotNull
    public final AmityUserRepository newUserRepository() {
        return new AmityUserRepository();
    }

    @NotNull
    public final AmityFileRepository newFileRepository() {
        return new AmityFileRepository();
    }

    @NotNull
    public final String getAmityCoreSdkVersion() {
        return "5.29.0";
    }

    @NotNull
    public final Flowable<AmityGlobalBanEvent> getGlobalBanEvents() {
        Flowable<AmityGlobalBanEvent> flowable = EkoSocket.getGlobalBanEvents();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"EkoSocket.getGlobalBanEvents()");
        return flowable;
    }

    @NotNull
    public final AmityUserNotification notification() {
        return new AmityUserNotification();
    }

    @NotNull
    public final AmityClientConfiguration getConfiguration() {
        return new AmityClientConfiguration((StreamFunctionInterface)new StreamFunction());
    }

    @NotNull
    public final Flowable<AmityConnectionState> getConnectionState() {
        Flowable<AmityConnectionState> flowable = EkoSocket.getConnectionState();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"EkoSocket.getConnectionState()");
        return flowable;
    }

    @NotNull
    public final AmityTopicSubscription subscription(@NotNull AmityTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return new AmityTopicSubscription(topic);
    }

    @NotNull
    public final Single<AmityContentCheck> getContentCheck() {
        return new GetContentCheckUseCase().execute();
    }

    private AmityCoreClient() {
    }

    static {
        AmityCoreClient amityCoreClient;
        INSTANCE = amityCoreClient = new AmityCoreClient();
        TAG = AmityCoreClient.class.getName();
    }

    public static final /* synthetic */ String access$getTAG$p(AmityCoreClient $this) {
        AmityCoreClient amityCoreClient = $this;
        return TAG;
    }
}

