/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.reaction;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionLocalDataStore;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionLocalDataStore$WhenMappings;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.PostEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.dao.PostDao;
import com.ekoapp.ekosdk.internal.data.model.AmityReactionMap;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import com.ekoapp.ekosdk.internal.entity.CommentEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.functions.Action;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.amity.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006JR\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010J&\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\bJ,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ,\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\bJ&\u0010\u001a\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u001b\u001a\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dJ*\u0010\u001e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d\u00a8\u0006 "}, d2={"Lcom/amity/socialcloud/sdk/core/data/reaction/ReactionLocalDataStore;", "", "()V", "addReaction", "Lio/reactivex/rxjava3/core/Completable;", "reaction", "Lcom/ekoapp/ekosdk/internal/data/model/EkoReactionEntity;", "reactionId", "", "referenceType", "Lcom/amity/socialcloud/sdk/core/reaction/ReactionReferenceType;", "referenceId", "reactionName", "userId", "userDisplayName", "createdAt", "Lorg/joda/time/DateTime;", "updateAt", "createReaction", "getLatestReaction", "Lio/reactivex/rxjava3/core/Flowable;", "getReaction", "Lio/reactivex/rxjava3/core/Maybe;", "getReactionsPagingSource", "Landroidx/paging/PagingSource;", "", "removeReaction", "saveReactions", "reactions", "", "saveReactionsAndDeletePrevious", "ids", "amity-sdk_release"})
public final class ReactionLocalDataStore {
    @NotNull
    public final Completable saveReactionsAndDeletePrevious(@NotNull ReactionReferenceType referenceType, @NotNull List<String> ids, @NotNull List<? extends EkoReactionEntity> reactions) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter(reactions, (String)"reactions");
        Completable completable = Completable.fromAction((Action)new Action(ids, referenceType, reactions){
            final /* synthetic */ List $ids;
            final /* synthetic */ ReactionReferenceType $referenceType;
            final /* synthetic */ List $reactions;

            public final void run() {
                EkoReactionDao ekoReactionDao = UserDatabase.get().reactionDao();
                Intrinsics.checkNotNullExpressionValue((Object)ekoReactionDao, (String)"UserDatabase.get().reactionDao()");
                EkoReactionDao reactionDao = ekoReactionDao;
                Iterable $this$forEach$iv = this.$ids;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    reactionDao.deleteByReferenceIdAndUserId(it, this.$referenceType.getValue(), new SessionLocalDataStore().getActiveUserId());
                }
                reactionDao.insert(this.$reactions);
            }
            {
                this.$ids = list;
                this.$referenceType = reactionReferenceType;
                this.$reactions = list2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026sert(reactions)\n        }");
        return completable;
    }

    @NotNull
    public final Completable saveReactions(@NotNull List<? extends EkoReactionEntity> reactions) {
        Intrinsics.checkNotNullParameter(reactions, (String)"reactions");
        Completable completable = Completable.fromAction((Action)new Action(reactions){
            final /* synthetic */ List $reactions;

            public final void run() {
                EkoReactionDao ekoReactionDao = UserDatabase.get().reactionDao();
                Intrinsics.checkNotNullExpressionValue((Object)ekoReactionDao, (String)"UserDatabase.get().reactionDao()");
                EkoReactionDao reactionDao = ekoReactionDao;
                reactionDao.insert(this.$reactions);
            }
            {
                this.$reactions = list;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026sert(reactions)\n        }");
        return completable;
    }

    @NotNull
    public final Completable addReaction(@NotNull String reactionId, @NotNull ReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName, @NotNull String userId, @Nullable String userDisplayName, @Nullable DateTime createdAt, @Nullable DateTime updateAt) {
        Intrinsics.checkNotNullParameter((Object)reactionId, (String)"reactionId");
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction((Action)new Action(reactionId, referenceType, referenceId, reactionName, userId, userDisplayName, createdAt, updateAt){
            final /* synthetic */ String $reactionId;
            final /* synthetic */ ReactionReferenceType $referenceType;
            final /* synthetic */ String $referenceId;
            final /* synthetic */ String $reactionName;
            final /* synthetic */ String $userId;
            final /* synthetic */ String $userDisplayName;
            final /* synthetic */ DateTime $createdAt;
            final /* synthetic */ DateTime $updateAt;

            public final void run() {
                EkoReactionDao reactionDao = UserDatabase.get().reactionDao();
                EkoReactionEntity reactionEntity = EkoReactionEntity.createReaction(this.$reactionId, this.$referenceType, this.$referenceId, this.$reactionName, this.$userId, this.$userDisplayName, this.$createdAt, this.$updateAt);
                reactionDao.insert((EkoObject)reactionEntity);
            }
            {
                this.$reactionId = string;
                this.$referenceType = reactionReferenceType;
                this.$referenceId = string2;
                this.$reactionName = string3;
                this.$userId = string4;
                this.$userDisplayName = string5;
                this.$createdAt = dateTime;
                this.$updateAt = dateTime2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026reactionEntity)\n        }");
        return completable;
    }

    public static /* synthetic */ Completable addReaction$default(ReactionLocalDataStore reactionLocalDataStore, String string, ReactionReferenceType reactionReferenceType, String string2, String string3, String string4, String string5, DateTime dateTime, DateTime dateTime2, int n, Object object) {
        if ((n & 0x20) != 0) {
            string5 = null;
        }
        if ((n & 0x40) != 0) {
            dateTime = null;
        }
        if ((n & 0x80) != 0) {
            dateTime2 = null;
        }
        return reactionLocalDataStore.addReaction(string, reactionReferenceType, string2, string3, string4, string5, dateTime, dateTime2);
    }

    @NotNull
    public final Completable removeReaction(@NotNull ReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction((Action)new Action(referenceType, referenceId, userId, reactionName){
            final /* synthetic */ ReactionReferenceType $referenceType;
            final /* synthetic */ String $referenceId;
            final /* synthetic */ String $userId;
            final /* synthetic */ String $reactionName;

            public final void run() {
                EkoReactionDao reactionDao = UserDatabase.get().reactionDao();
                reactionDao.deleteByPrimaryKey(this.$referenceType.getValue(), this.$referenceId, this.$userId, this.$reactionName);
            }
            {
                this.$referenceType = reactionReferenceType;
                this.$referenceId = string;
                this.$userId = string2;
                this.$reactionName = string3;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026e\n            )\n        }");
        return completable;
    }

    @NotNull
    public final PagingSource<Integer, EkoReactionEntity> getReactionsPagingSource(@NotNull ReactionReferenceType referenceType, @NotNull String referenceId, @Nullable String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        return UserDatabase.get().reactionPagingDao().getReactionPagingSource(referenceType, referenceId, reactionName);
    }

    @NotNull
    public final Flowable<EkoReactionEntity> getLatestReaction(@NotNull ReactionReferenceType referenceType, @NotNull String referenceId, @Nullable String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Flowable<EkoReactionEntity> flowable = UserDatabase.get().reactionDao().getLatestReaction(referenceType.getValue(), referenceId, reactionName, DateTime.now());
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"UserDatabase.get().react\u2026tionName, DateTime.now())");
        return flowable;
    }

    @NotNull
    public final Maybe<EkoReactionEntity> getReaction(@NotNull ReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Maybe<EkoReactionEntity> maybe = UserDatabase.get().reactionDao().getReactionByReferenceAndReactionName(referenceType.getValue(), referenceId, reactionName, userId);
        Intrinsics.checkNotNullExpressionValue(maybe, (String)"UserDatabase.get().react\u2026,\n                userId)");
        return maybe;
    }

    @NotNull
    public final EkoReactionEntity createReaction(@NotNull ReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        EkoReactionEntity ekoReactionEntity = EkoReactionEntity.createReaction("!" + ObjectId.get().toHexString(), referenceType, referenceId, reactionName, userId, null, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)ekoReactionEntity, (String)"EkoReactionEntity.create\u2026           null\n        )");
        return ekoReactionEntity;
    }

    @NotNull
    public final Completable addReaction(@NotNull EkoReactionEntity reaction) {
        Intrinsics.checkNotNullParameter((Object)reaction, (String)"reaction");
        Completable completable = Completable.fromAction((Action)new Action(reaction){
            final /* synthetic */ EkoReactionEntity $reaction;

            public final void run() {
                UserDatabase userDatabase = UserDatabase.get();
                EkoReactionDao reactionDao = userDatabase.reactionDao();
                userDatabase.runInTransaction(new Runnable(this, reactionDao, userDatabase){
                    final /* synthetic */ addReaction.2 this$0;
                    final /* synthetic */ EkoReactionDao $reactionDao;
                    final /* synthetic */ UserDatabase $userDatabase;

                    public final void run() {
                        this.$reactionDao.insert((EkoObject)this.this$0.$reaction);
                        switch (ReactionLocalDataStore$WhenMappings.$EnumSwitchMapping$0[ReactionReferenceType.Companion.enumOf(this.this$0.$reaction.getReferenceType()).ordinal()]) {
                            case 1: {
                                PostDao postDao = this.$userDatabase.postDao();
                                PostEntity post = postDao.getByIdNow(this.this$0.$reaction.getReferenceId());
                                if (post == null) break;
                                AmityReactionMap reactionMap = post.getReactions();
                                post.setReactionCount(post.getReactionCount() + 1);
                                Map map = reactionMap;
                                String string = this.this$0.$reaction.getReactionName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reaction.reactionName");
                                map.put(string, post.getReactions().getCount(this.this$0.$reaction.getReactionName()) + 1);
                                post.setReactions(reactionMap);
                                postDao.update((EkoObject)post);
                                break;
                            }
                            case 2: {
                                EkoMessageDao messageDao = this.$userDatabase.messageDao();
                                EkoMessageEntity message = messageDao.getByIdNow(this.this$0.$reaction.getReferenceId());
                                if (message == null) break;
                                AmityReactionMap reactionMap = message.getReactions();
                                message.setReactionCount(message.getReactionCount() + 1);
                                Map map = reactionMap;
                                String string = this.this$0.$reaction.getReactionName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reaction.reactionName");
                                map.put(string, message.getReactions().getCount(this.this$0.$reaction.getReactionName()) + 1);
                                message.setReactions(reactionMap);
                                messageDao.update(message);
                                break;
                            }
                            case 3: {
                                EkoCommentDao commentDao = this.$userDatabase.commentDao();
                                CommentEntity comment = commentDao.getByIdNow(this.this$0.$reaction.getReferenceId());
                                if (comment == null) break;
                                AmityReactionMap reactionMap = comment.getReactions();
                                comment.setReactionCount(comment.getReactionCount() + 1);
                                Map map = reactionMap;
                                String string = this.this$0.$reaction.getReactionName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reaction.reactionName");
                                map.put(string, comment.getReactions().getCount(this.this$0.$reaction.getReactionName()) + 1);
                                comment.setReactions(reactionMap);
                                commentDao.update((EkoObject)comment);
                                if (!Intrinsics.areEqual((Object)comment.getReferenceType(), (Object)"post")) break;
                                PostDao postDao = this.$userDatabase.postDao();
                                postDao.updatePost(comment.getReferenceId());
                                break;
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$reactionDao = ekoReactionDao;
                        this.$userDatabase = userDatabase;
                    }
                });
            }
            {
                this.$reaction = ekoReactionEntity;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026}\n            }\n        }");
        return completable;
    }

    @NotNull
    public final Completable removeReaction(@NotNull EkoReactionEntity reaction) {
        Intrinsics.checkNotNullParameter((Object)reaction, (String)"reaction");
        Completable completable = Completable.fromAction((Action)new Action(reaction){
            final /* synthetic */ EkoReactionEntity $reaction;

            public final void run() {
                UserDatabase userDatabase = UserDatabase.get();
                EkoReactionDao reactionDao = userDatabase.reactionDao();
                userDatabase.runInTransaction(new Runnable(this, reactionDao, userDatabase){
                    final /* synthetic */ removeReaction.2 this$0;
                    final /* synthetic */ EkoReactionDao $reactionDao;
                    final /* synthetic */ UserDatabase $userDatabase;

                    public final void run() {
                        String string = this.this$0.$reaction.getReactionName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reaction.reactionName");
                        String reactionName = string;
                        this.$reactionDao.delete(this.this$0.$reaction);
                        switch (ReactionLocalDataStore$WhenMappings.$EnumSwitchMapping$1[ReactionReferenceType.Companion.enumOf(this.this$0.$reaction.getReferenceType()).ordinal()]) {
                            case 1: {
                                PostDao postDao = this.$userDatabase.postDao();
                                PostEntity post = postDao.getByIdNow(this.this$0.$reaction.getReferenceId());
                                if (post == null) break;
                                AmityReactionMap reactionMap = post.getReactions();
                                int totalReactionCount = Math.max(0, post.getReactionCount() - 1);
                                int reactionCount = Math.max(0, post.getReactions().getCount(reactionName) - 1);
                                post.setReactionCount(totalReactionCount);
                                ((Map)reactionMap).put(reactionName, reactionCount);
                                post.setReactions(reactionMap);
                                postDao.update((EkoObject)post);
                                break;
                            }
                            case 2: {
                                EkoMessageDao messageDao = this.$userDatabase.messageDao();
                                EkoMessageEntity message = messageDao.getByIdNow(this.this$0.$reaction.getReferenceId());
                                if (message == null) break;
                                AmityReactionMap reactionMap = message.getReactions();
                                int totalReactionCount = Math.max(0, message.getReactionCount() - 1);
                                int reactionCount = Math.max(0, message.getReactions().getCount(reactionName) - 1);
                                message.setReactionCount(totalReactionCount);
                                ((Map)reactionMap).put(reactionName, reactionCount);
                                message.setReactions(reactionMap);
                                messageDao.update(message);
                                break;
                            }
                            case 3: {
                                EkoCommentDao commentDao = this.$userDatabase.commentDao();
                                CommentEntity comment = commentDao.getByIdNow(this.this$0.$reaction.getReferenceId());
                                if (comment == null) break;
                                AmityReactionMap reactionMap = comment.getReactions();
                                int totalReactionCount = Math.max(0, comment.getReactionCount() - 1);
                                int reactionCount = Math.max(0, comment.getReactions().getCount(reactionName) - 1);
                                comment.setReactionCount(totalReactionCount);
                                ((Map)reactionMap).put(reactionName, reactionCount);
                                comment.setReactions(reactionMap);
                                commentDao.update((EkoObject)comment);
                                if (!Intrinsics.areEqual((Object)comment.getReferenceType(), (Object)"post")) break;
                                PostDao postDao = this.$userDatabase.postDao();
                                postDao.updatePost(comment.getReferenceId());
                                break;
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$reactionDao = ekoReactionDao;
                        this.$userDatabase = userDatabase;
                    }
                });
            }
            {
                this.$reaction = ekoReactionEntity;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026}\n            }\n        }");
        return completable;
    }
}

