/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.api.dto.EkoObjectDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectMapper;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.github.davidmoten.guavamini.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import timber.log.Timber;

public abstract class EkoObjectPersister {
    private static final String TAG = EkoObjectPersister.class.getName();

    static <DTO extends EkoObjectDto, EKO extends EkoObject> void persistChanges(List<DTO> dtoList, EkoObjectMapper<DTO, EKO> mapper, EkoObjectDao<EKO> dao) {
        List<EKO> fromNetwork = mapper.map(dtoList);
        List idsFromNetwork = Lists.transform(fromNetwork, EkoObject::getId);
        List<EKO> onDisk = dao.getByIdsNow(idsFromNetwork);
        ImmutableMap onDiskMap = Maps.uniqueIndex(onDisk, EkoObject::getId);
        ArrayList freshObjects = Lists.newArrayList();
        ArrayList changedObjects = Lists.newArrayList();
        for (EkoObject objectFromNetwork : fromNetwork) {
            String id = objectFromNetwork.getId();
            EkoObject objectOnDisk = (EkoObject)onDiskMap.get(id);
            if (!onDiskMap.containsKey(id)) {
                Timber.tag((String)TAG).i("new object: id: %s objectFromNetwork: %s", new Object[]{id, objectFromNetwork});
                freshObjects.add(objectFromNetwork);
                continue;
            }
            if (Objects.equal((Object)objectFromNetwork, (Object)objectOnDisk)) continue;
            EkoObject changedObject = mapper.update(objectOnDisk, objectFromNetwork);
            Timber.tag((String)TAG).i("object changed: id: %s changedObject: %s", new Object[]{id, changedObject});
            changedObjects.add(changedObject);
        }
        if (!freshObjects.isEmpty()) {
            dao.insert(freshObjects);
        }
        if (!changedObjects.isEmpty()) {
            dao.update(changedObjects);
        }
    }
}

