/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.channel.reader;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.chat.data.channel.ChannelLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipRepository;
import com.amity.socialcloud.sdk.chat.data.channel.reader.ChannelReaderLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.channel.reader.ChannelReaderRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.channel.reader.ChannelReaderRepository;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.ekoapp.ekosdk.EkoChannelExtra;
import com.ekoapp.ekosdk.internal.EkoChannelEntity;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/channel/reader/ChannelReaderRepository;", "", "()V", "getUnreadCount", "", "channelId", "", "hasUnreadMention", "", "startReading", "", "stopReading", "amity-sdk_release"})
public final class ChannelReaderRepository {
    public final void startReading(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        ChannelReaderLocalDataStore localDataStore = new ChannelReaderLocalDataStore();
        Completable startReading2 = localDataStore.startReading(channelId).concatWith((CompletableSource)new ChannelReaderRemoteDataStore().startReading(channelId));
        localDataStore.observeChannelReader(channelId).firstElement().filter((Predicate)startReading.1.INSTANCE).flatMapCompletable((Function)new Function<EkoChannelExtra, CompletableSource>(startReading2){
            final /* synthetic */ Completable $startReading;

            public final CompletableSource apply(EkoChannelExtra it) {
                return (CompletableSource)this.$startReading;
            }
            {
                this.$startReading = completable;
            }
        }).onErrorResumeNext((Function)new Function<Throwable, CompletableSource>(channelId){
            final /* synthetic */ String $channelId;

            public final CompletableSource apply(Throwable it) {
                return AmityError.USER_IS_BANNED == AmityError.Companion.from(it) ? (CompletableSource)new ChannelMembershipRepository().handleMembershipBanned(this.$channelId, AmityCoreClient.INSTANCE.getUserId()).andThen((CompletableSource)Completable.error((Throwable)it)) : (CompletableSource)Completable.error((Throwable)it);
            }
            {
                this.$channelId = string;
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    public final void stopReading(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        ChannelReaderLocalDataStore localDataStore = new ChannelReaderLocalDataStore();
        Completable stopReading2 = localDataStore.stopReading(channelId).concatWith((CompletableSource)new ChannelReaderRemoteDataStore().stopReading(channelId));
        localDataStore.observeChannelReader(channelId).firstElement().filter((Predicate)stopReading.1.INSTANCE).flatMapCompletable((Function)new Function<EkoChannelExtra, CompletableSource>(stopReading2){
            final /* synthetic */ Completable $stopReading;

            public final CompletableSource apply(EkoChannelExtra it) {
                return (CompletableSource)this.$stopReading;
            }
            {
                this.$stopReading = completable;
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    public final int getUnreadCount(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        EkoChannelEntity ekoChannelEntity = new ChannelLocalDataStore().getChannel(channelId);
        int messageCount = ekoChannelEntity != null ? ekoChannelEntity.getMessageCount() : 0;
        String myUserId = new SessionLocalDataStore().getActiveUserId();
        ChannelMembershipEntity channelMembershipEntity = new ChannelMembershipLocalDataStore().getChannelMember(channelId, myUserId);
        int channelReadToSegment = channelMembershipEntity != null ? channelMembershipEntity.getReadToSegment() : 0;
        EkoChannelExtra ekoChannelExtra = new ChannelReaderLocalDataStore().getChannelReader(channelId);
        int localReadToSegment = ekoChannelExtra != null ? ekoChannelExtra.getLocalReadToSegment() : 0;
        return Math.max(0, messageCount - Math.max(channelReadToSegment, localReadToSegment));
    }

    public final boolean hasUnreadMention(@NotNull String channelId) {
        EkoChannelExtra channelReader;
        ChannelMembershipEntity channelMember;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        String myUserId = new SessionLocalDataStore().getActiveUserId();
        ChannelMembershipEntity channelMembershipEntity = channelMember = new ChannelMembershipLocalDataStore().getChannelMember(channelId, myUserId);
        int channelReadToSegment = channelMembershipEntity != null ? channelMembershipEntity.getReadToSegment() : 0;
        ChannelMembershipEntity channelMembershipEntity2 = channelMember;
        int channelLastMentionedSegment = channelMembershipEntity2 != null ? channelMembershipEntity2.getLastMentionedSegment() : 0;
        EkoChannelExtra ekoChannelExtra = channelReader = new ChannelReaderLocalDataStore().getChannelReader(channelId);
        int localReadToSegment = ekoChannelExtra != null ? ekoChannelExtra.getLocalReadToSegment() : 0;
        EkoChannelExtra ekoChannelExtra2 = channelReader;
        int localLastMentionedSegment = ekoChannelExtra2 != null ? ekoChannelExtra2.getLocalLastMentionedSegment() : 0;
        int readToSegment = Math.max(channelReadToSegment, localReadToSegment);
        int lastMentionedSegment = Math.max(channelLastMentionedSegment, localLastMentionedSegment);
        return readToSegment < lastMentionedSegment;
    }
}

