/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.user;

import androidx.paging.DataSource;
import androidx.paging.ExperimentalPagingApi;
import androidx.paging.PagedList;
import androidx.paging.Pager;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import androidx.paging.RemoteMediator;
import androidx.paging.rxjava2.PagingRx;
import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.amity.socialcloud.sdk.core.user.AmityFollowRelationship;
import com.amity.socialcloud.sdk.core.user.AmityFollowStatus;
import com.amity.socialcloud.sdk.core.user.AmityFollowStatusFilter;
import com.amity.socialcloud.sdk.core.user.AmityMyFollowInfo;
import com.amity.socialcloud.sdk.core.user.AmityUser;
import com.amity.socialcloud.sdk.core.user.AmityUserFollowInfo;
import com.amity.socialcloud.sdk.core.user.AmityUserSortOption;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.UserEntity;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.SocketConnectionEvent;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.FollowConverter;
import com.ekoapp.ekosdk.internal.api.socket.call.FollowInfoConverter;
import com.ekoapp.ekosdk.internal.api.socket.call.UserQueryConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.AcceptFollowRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.DeclineFollowRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.GetFollowInfoRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.RemoveFollowerRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.RequestFollowRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.UnfollowRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.UserGetRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.UserUpdateRequest;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.FollowersBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.boundarycallback.FollowingsBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.boundarycallback.UserBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoAccountDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoApiKeyDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoFollowCountDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoFollowDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoUserFlagDao;
import com.ekoapp.ekosdk.internal.data.dao.FollowerQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.dao.FollowingQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.dao.UserDao;
import com.ekoapp.ekosdk.internal.data.dao.UserQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFlag;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFollowStatusEntity;
import com.ekoapp.ekosdk.internal.repository.user.UserRepository;
import com.ekoapp.ekosdk.internal.repository.user.UserRepository$sam$io_reactivex_functions_Function$0;
import com.ekoapp.ekosdk.internal.repository.user.UserRxRemoteMediator;
import com.ekoapp.ekosdk.internal.repository.user.UserUpdateOption;
import com.ekoapp.ekosdk.internal.repository.user.follow.FollowerRxRemoteMediator;
import com.ekoapp.ekosdk.internal.repository.user.follow.FollowingRxRemoteMediator;
import com.ekoapp.ekosdk.internal.repository.user.helper.MapToUserFollowStatusModelHelper;
import com.ekoapp.ekosdk.internal.repository.user.helper.MapToUserModelHelper;
import com.ekoapp.ekosdk.internal.repository.user.helper.RegisterDeviceManager;
import com.ekoapp.ekosdk.internal.repository.user.helper.UserRepositoryHelper;
import com.ekoapp.ekosdk.internal.util.RxEko;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Action;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.CompletableSubject;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\b\u001a\u00020\tH\u0002J\"\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00110\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\"\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00110\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\"\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\f0\u000b2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fJ$\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00110\u000b2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\"\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\"\u001a\u0004\u0018\u00010\u00062\b\u0010#\u001a\u0004\u0018\u00010\u0006J\u000e\u0010$\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010(\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170&2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010*\u001a\u00020+\u00a8\u0006,"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/user/UserRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "acceptFollow", "Lio/reactivex/Completable;", "userId", "", "declineFollow", "getDefaultPageSize", "", "getFollowersPagedList", "Lio/reactivex/Flowable;", "Landroidx/paging/PagedList;", "Lcom/amity/socialcloud/sdk/core/user/AmityFollowRelationship;", "filter", "Lcom/amity/socialcloud/sdk/core/user/AmityFollowStatusFilter;", "getFollowersPagingData", "Landroidx/paging/PagingData;", "getFollowingsPagedList", "getFollowingsPagingData", "getMyFollowInfo", "Lcom/amity/socialcloud/sdk/core/user/AmityMyFollowInfo;", "getUser", "Lcom/amity/socialcloud/sdk/core/user/AmityUser;", "getUserFlag", "Lcom/ekoapp/ekosdk/internal/data/model/EkoUserFlag;", "getUserFollowInfo", "Lcom/amity/socialcloud/sdk/core/user/AmityUserFollowInfo;", "getUserPagedList", "keyword", "sortBy", "Lcom/amity/socialcloud/sdk/core/user/AmityUserSortOption;", "getUserPagingData", "registerDevice", "displayName", "authToken", "removeFollower", "requestFollow", "Lio/reactivex/Single;", "Lcom/amity/socialcloud/sdk/core/user/AmityFollowStatus;", "unfollow", "updateUser", "option", "Lcom/ekoapp/ekosdk/internal/repository/user/UserUpdateOption;", "amity-sdk_release"})
public final class UserRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<PagedList<AmityUser>> getUserPagedList(@NotNull String keyword, @NotNull AmityUserSortOption sortBy) {
        Intrinsics.checkParameterIsNotNull((Object)keyword, (String)"keyword");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sortBy), (String)"sortBy");
        UserDao userDao = UserDatabase.get().userDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)userDao, (String)"UserDatabase.get().userDao()");
        UserDao userDao2 = userDao;
        DataSource.Factory<Integer, UserEntity> factory2 = userDao2.getDataSource(keyword, sortBy);
        UserBoundaryCallback boundaryCallback = new UserBoundaryCallback(keyword, sortBy.getApiKey(), this.getDefaultPageSize());
        return this.createRxCollectionWithBoundaryCallback(factory2.map((androidx.arch.core.util.Function)new MapToUserModelHelper()), boundaryCallback);
    }

    @ExperimentalPagingApi
    @NotNull
    public final Flowable<PagingData<AmityUser>> getUserPagingData(@NotNull String keyword, @NotNull AmityUserSortOption sortBy) {
        Intrinsics.checkParameterIsNotNull((Object)keyword, (String)"keyword");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sortBy), (String)"sortBy");
        PagingConfig pagingConfig = new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null);
        String string = sortBy.getApiKey();
        UserQueryTokenDao userQueryTokenDao = UserDatabase.get().userQueryTokenDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)userQueryTokenDao, (String)"UserDatabase.get().userQueryTokenDao()");
        Pager pager2 = new Pager(pagingConfig, null, (RemoteMediator)new UserRxRemoteMediator(keyword, string, userQueryTokenDao), (Function0)new Function0<PagingSource<Integer, UserEntity>>(keyword, sortBy){
            final /* synthetic */ String $keyword;
            final /* synthetic */ AmityUserSortOption $sortBy;

            public final PagingSource<Integer, UserEntity> invoke() {
                UserDao userDao = UserDatabase.get().userDao();
                Intrinsics.checkExpressionValueIsNotNull((Object)userDao, (String)"UserDatabase.get().userDao()");
                UserDao userDao2 = userDao;
                PagingSource<Integer, UserEntity> pagingSource = userDao2.getPagingSource(this.$keyword, this.$sortBy);
                Intrinsics.checkExpressionValueIsNotNull(pagingSource, (String)"userDao.getPagingSource(keyword, sortBy)");
                return pagingSource;
            }
            {
                this.$keyword = string;
                this.$sortBy = amityUserSortOption;
                super(0);
            }
        });
        Flowable flowable = PagingRx.getFlowable((Pager)pager2).map((Function)getUserPagingData.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"pager.flowable\n         \u2026      }\n                }");
        return flowable;
    }

    @NotNull
    public final Flowable<AmityUser> getUser(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        UserDao userDao = UserDatabase.get().userDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)userDao, (String)"UserDatabase.get().userDao()");
        UserDao userDao2 = userDao;
        UserGetRequest request = new UserGetRequest(CollectionsKt.listOf((Object)userId));
        UserQueryConverter converter2 = new UserQueryConverter();
        EkoSocket.call(Call.create(request, converter2));
        Function1 function1 = (Function1)new Function1<UserEntity, AmityUser>(new UserRepositoryHelper()){

            @NotNull
            public final AmityUser invoke(@NotNull UserEntity p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((UserRepositoryHelper)this.receiver).attachDataAndMapToExternal(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(UserRepositoryHelper.class);
            }

            public final String getName() {
                return "attachDataAndMapToExternal";
            }

            public final String getSignature() {
                return "attachDataAndMapToExternal(Lcom/ekoapp/ekosdk/UserEntity;)Lcom/amity/socialcloud/sdk/core/user/AmityUser;";
            }
        };
        Flowable flowable = userDao2.getById(userId).map((Function)new UserRepository$sam$io_reactivex_functions_Function$0(function1));
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"userDao.getById(userId).\u2026tachDataAndMapToExternal)");
        return flowable;
    }

    @NotNull
    public final Flowable<EkoUserFlag> getUserFlag(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        EkoUserFlagDao userFlagDao = UserDatabase.get().userFlagDao();
        Flowable<EkoUserFlag> flowable = userFlagDao.getById(userId);
        Intrinsics.checkExpressionValueIsNotNull(flowable, (String)"userFlagDao.getById(userId)");
        return flowable;
    }

    @NotNull
    public final Single<AmityUser> updateUser(@NotNull String userId, @NotNull UserUpdateOption option) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        UserUpdateRequest request = new UserUpdateRequest(userId, option.getDisplayName(), option.getRoles(), option.getMetadata(), option.getAvatarFileId(), option.getAvatarCustomUrl(), option.getDescription());
        Single single = EkoSocket.call(Call.create(request, new UserQueryConverter())).flatMap(new Function<T, SingleSource<? extends R>>(this, userId){
            final /* synthetic */ UserRepository this$0;
            final /* synthetic */ String $userId;

            @NotNull
            public final Single<AmityUser> apply(@NotNull EkoUserListDto it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Single.defer((Callable)new Callable<SingleSource<? extends T>>(this){
                    final /* synthetic */ updateUser.1 this$0;

                    public final Single<AmityUser> call() {
                        return this.this$0.this$0.getUser(this.this$0.$userId).firstOrError();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = userRepository;
                this.$userId = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"EkoSocket.call(Call.crea\u2026serId).firstOrError() } }");
        return single;
    }

    @NotNull
    public final Completable registerDevice(@NotNull String userId, @Nullable String displayName, @Nullable String authToken) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        CompletableSubject completableSubject = CompletableSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)completableSubject, (String)"CompletableSubject.create()");
        CompletableSubject result = completableSubject;
        RegisterDeviceManager registerManager = new RegisterDeviceManager(userId, displayName, authToken);
        EkoApiKeyDao ekoApiKeyDao = EkoDatabase.get().apiKeyDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoApiKeyDao, (String)"EkoDatabase.get().apiKeyDao()");
        ekoApiKeyDao.getCurrentApiKey().map(new Function<T, R>(registerManager){
            final /* synthetic */ RegisterDeviceManager $registerManager;

            public final EkoAccountDao apply(@NotNull EkoApiKey it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string = it.getApiKey();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.apiKey");
                this.$registerManager.register(string).blockingGet();
                return EkoDatabase.get().accountDao();
            }
            {
                this.$registerManager = registerDeviceManager;
            }
        }).doOnSuccess((Consumer)new Consumer<EkoAccountDao>(userId){
            final /* synthetic */ String $userId;

            public final void accept(EkoAccountDao it) {
                EkoSocket.rpc(new UserGetRequest(CollectionsKt.listOf((Object)this.$userId)));
            }
            {
                this.$userId = string;
            }
        }).flatMap(new Function<T, MaybeSource<? extends R>>(registerManager){
            final /* synthetic */ RegisterDeviceManager $registerManager;

            @NotNull
            public final Maybe<SocketConnectionEvent> apply(@NotNull EkoAccountDao it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$registerManager.restart();
            }
            {
                this.$registerManager = registerDeviceManager;
            }
        }).doOnError(RxEko.CATCH_UNAUTHORIZED_ERROR_CONSUMER).doOnError(RxEko.LOG_ERROR_CONSUMER).switchIfEmpty((MaybeSource)Maybe.never()).ignoreElement().subscribeOn(Schedulers.io()).subscribe((CompletableObserver)result);
        Completable completable = result.hide();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"result.hide()");
        return completable;
    }

    @NotNull
    public final Single<AmityFollowStatus> requestFollow(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        RequestFollowRequest request = new RequestFollowRequest(userId);
        Single single = EkoSocket.call(Call.create(request, new FollowConverter())).map((Function)requestFollow.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"EkoSocket.call(Call.crea\u2026status)\n                }");
        return single;
    }

    @NotNull
    public final Completable acceptFollow(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction((Action)new Action(userId){
            final /* synthetic */ String $userId;

            public final void run() {
                UserDatabase.get().followDao().updateFollower(this.$userId, AmityFollowStatus.ACCEPTED.getApiKey());
            }
            {
                this.$userId = string;
            }
        }).concatWith((CompletableSource)EkoSocket.call(Call.create(new AcceptFollowRequest(userId), new FollowConverter())).flatMapCompletable((Function)acceptFollow.2.INSTANCE).doOnError((Consumer)new Consumer<Throwable>(userId){
            final /* synthetic */ String $userId;

            public final void accept(Throwable it) {
                if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
                    UserDatabase.get().followDao().updateFollower(this.$userId, AmityFollowStatus.NONE.getApiKey());
                } else {
                    UserDatabase.get().followDao().updateFollower(this.$userId, AmityFollowStatus.PENDING.getApiKey());
                }
            }
            {
                this.$userId = string;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.fromAction {\u2026     }\n                })");
        return completable;
    }

    @NotNull
    public final Completable declineFollow(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction((Action)new Action(userId){
            final /* synthetic */ String $userId;

            public final void run() {
                UserDatabase.get().followDao().updateFollower(this.$userId, AmityFollowStatus.NONE.getApiKey());
            }
            {
                this.$userId = string;
            }
        }).concatWith((CompletableSource)EkoSocket.call(Call.create(new DeclineFollowRequest(userId), new FollowConverter())).flatMapCompletable((Function)declineFollow.2.INSTANCE).doOnError((Consumer)new Consumer<Throwable>(userId){
            final /* synthetic */ String $userId;

            public final void accept(Throwable it) {
                if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
                    UserDatabase.get().followDao().updateFollower(this.$userId, AmityFollowStatus.NONE.getApiKey());
                } else {
                    UserDatabase.get().followDao().updateFollower(this.$userId, AmityFollowStatus.PENDING.getApiKey());
                }
            }
            {
                this.$userId = string;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.fromAction {\u2026     }\n                })");
        return completable;
    }

    @NotNull
    public final Completable removeFollower(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction((Action)new Action(userId){
            final /* synthetic */ String $userId;

            public final void run() {
                UserDatabase.get().followDao().updateFollower(this.$userId, AmityFollowStatus.NONE.getApiKey());
            }
            {
                this.$userId = string;
            }
        }).concatWith((CompletableSource)EkoSocket.call(Call.create(new RemoveFollowerRequest(userId), new FollowConverter())).flatMapCompletable((Function)removeFollower.2.INSTANCE).doOnError((Consumer)new Consumer<Throwable>(userId){
            final /* synthetic */ String $userId;

            public final void accept(Throwable it) {
                if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
                    UserDatabase.get().followDao().updateFollower(this.$userId, AmityFollowStatus.NONE.getApiKey());
                } else {
                    UserDatabase.get().followDao().updateFollower(this.$userId, AmityFollowStatus.ACCEPTED.getApiKey());
                }
            }
            {
                this.$userId = string;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.fromAction {\u2026     }\n                })");
        return completable;
    }

    @NotNull
    public final Completable unfollow(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction((Action)new Action(userId){
            final /* synthetic */ String $userId;

            public final void run() {
                UserDatabase.get().followDao().updateFollowing(this.$userId, AmityFollowStatus.NONE.getApiKey());
            }
            {
                this.$userId = string;
            }
        }).concatWith((CompletableSource)EkoSocket.call(Call.create(new UnfollowRequest(userId), new FollowConverter())).flatMapCompletable((Function)unfollow.2.INSTANCE).doOnError((Consumer)new Consumer<Throwable>(userId){
            final /* synthetic */ String $userId;

            public final void accept(Throwable it) {
                if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
                    UserDatabase.get().followDao().updateFollowing(this.$userId, AmityFollowStatus.NONE.getApiKey());
                } else {
                    UserDatabase.get().followDao().updateFollowing(this.$userId, AmityFollowStatus.ACCEPTED.getApiKey());
                }
            }
            {
                this.$userId = string;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.fromAction {\u2026     }\n                })");
        return completable;
    }

    @NotNull
    public final Flowable<AmityMyFollowInfo> getMyFollowInfo() {
        String myUserId = AmityCoreClient.INSTANCE.getUserId();
        EkoFollowCountDao followCountDao = UserDatabase.get().followCountDao();
        GetFollowInfoRequest request = new GetFollowInfoRequest(null);
        EkoSocket.call(Call.create(request, new FollowInfoConverter()));
        Function1 function1 = (Function1)new Function1<EkoFollowCountEntity, AmityMyFollowInfo>(new UserRepositoryHelper()){

            @NotNull
            public final AmityMyFollowInfo invoke(@NotNull EkoFollowCountEntity p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((UserRepositoryHelper)this.receiver).attachMyFollowInfoDataAndMapToExternal(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(UserRepositoryHelper.class);
            }

            public final String getName() {
                return "attachMyFollowInfoDataAndMapToExternal";
            }

            public final String getSignature() {
                return "attachMyFollowInfoDataAndMapToExternal(Lcom/ekoapp/ekosdk/internal/data/model/EkoFollowCountEntity;)Lcom/amity/socialcloud/sdk/core/user/AmityMyFollowInfo;";
            }
        };
        Flowable flowable = followCountDao.getById(myUserId).map((Function)new UserRepository$sam$io_reactivex_functions_Function$0(function1));
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"followCountDao.getById(m\u2026InfoDataAndMapToExternal)");
        return flowable;
    }

    @NotNull
    public final Flowable<AmityUserFollowInfo> getUserFollowInfo(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        String myUserId = AmityCoreClient.INSTANCE.getUserId();
        EkoFollowDao followDao = UserDatabase.get().followDao();
        EkoFollowCountDao followCountDao = UserDatabase.get().followCountDao();
        GetFollowInfoRequest request = new GetFollowInfoRequest(userId);
        EkoSocket.call(Call.create(request, new FollowInfoConverter()));
        Flowable flowable = followDao.getUserFollowById(myUserId, userId).zipWith((Publisher)followCountDao.getById(userId), (BiFunction)getUserFollowInfo.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"followDao.getUserFollowB\u2026ntity)\n                })");
        return flowable;
    }

    @NotNull
    public final Flowable<PagedList<AmityFollowRelationship>> getFollowingsPagedList(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        EkoFollowDao followDao = UserDatabase.get().followDao();
        DataSource.Factory<Integer, EkoUserFollowStatusEntity> factory2 = followDao.getFollowingsDataSource(userId, filter);
        FollowingsBoundaryCallback boundaryCallback = new FollowingsBoundaryCallback(userId, filter, this.getDefaultPageSize());
        return this.createRxCollectionWithBoundaryCallback(factory2.map((androidx.arch.core.util.Function)new MapToUserFollowStatusModelHelper()), boundaryCallback);
    }

    @ExperimentalPagingApi
    @NotNull
    public final Flowable<PagingData<AmityFollowRelationship>> getFollowingsPagingData(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        PagingConfig pagingConfig = new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null);
        FollowingQueryTokenDao followingQueryTokenDao = UserDatabase.get().followingQueryTokenDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)followingQueryTokenDao, (String)"UserDatabase.get().followingQueryTokenDao()");
        Pager pager2 = new Pager(pagingConfig, null, (RemoteMediator)new FollowingRxRemoteMediator(userId, filter, followingQueryTokenDao), (Function0)new Function0<PagingSource<Integer, EkoUserFollowStatusEntity>>(userId, filter){
            final /* synthetic */ String $userId;
            final /* synthetic */ AmityFollowStatusFilter $filter;

            public final PagingSource<Integer, EkoUserFollowStatusEntity> invoke() {
                EkoFollowDao followDao = UserDatabase.get().followDao();
                PagingSource<Integer, EkoUserFollowStatusEntity> pagingSource = followDao.getFollowingsPagingSource(this.$userId, this.$filter);
                Intrinsics.checkExpressionValueIsNotNull(pagingSource, (String)"followDao.getFollowingsP\u2026ingSource(userId, filter)");
                return pagingSource;
            }
            {
                this.$userId = string;
                this.$filter = amityFollowStatusFilter;
                super(0);
            }
        });
        Flowable flowable = PagingRx.getFlowable((Pager)pager2).map((Function)getFollowingsPagingData.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"pager.flowable\n         \u2026      }\n                }");
        return flowable;
    }

    @NotNull
    public final Flowable<PagedList<AmityFollowRelationship>> getFollowersPagedList(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        EkoFollowDao followerDao = UserDatabase.get().followDao();
        DataSource.Factory<Integer, EkoUserFollowStatusEntity> factory2 = followerDao.getFollowersDataSource(userId, filter);
        FollowersBoundaryCallback boundaryCallback = new FollowersBoundaryCallback(userId, filter, this.getDefaultPageSize());
        return this.createRxCollectionWithBoundaryCallback(factory2.map((androidx.arch.core.util.Function)new MapToUserFollowStatusModelHelper()), boundaryCallback);
    }

    @ExperimentalPagingApi
    @NotNull
    public final Flowable<PagingData<AmityFollowRelationship>> getFollowersPagingData(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        PagingConfig pagingConfig = new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null);
        FollowerQueryTokenDao followerQueryTokenDao = UserDatabase.get().followerQueryTokenDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)followerQueryTokenDao, (String)"UserDatabase.get().followerQueryTokenDao()");
        Pager pager2 = new Pager(pagingConfig, null, (RemoteMediator)new FollowerRxRemoteMediator(userId, filter, followerQueryTokenDao), (Function0)new Function0<PagingSource<Integer, EkoUserFollowStatusEntity>>(userId, filter){
            final /* synthetic */ String $userId;
            final /* synthetic */ AmityFollowStatusFilter $filter;

            public final PagingSource<Integer, EkoUserFollowStatusEntity> invoke() {
                EkoFollowDao followDao = UserDatabase.get().followDao();
                PagingSource<Integer, EkoUserFollowStatusEntity> pagingSource = followDao.getFollowersPagingSource(this.$userId, this.$filter);
                Intrinsics.checkExpressionValueIsNotNull(pagingSource, (String)"followDao.getFollowersPagingSource(userId, filter)");
                return pagingSource;
            }
            {
                this.$userId = string;
                this.$filter = amityFollowStatusFilter;
                super(0);
            }
        });
        Flowable flowable = PagingRx.getFlowable((Pager)pager2).map((Function)getFollowersPagingData.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"pager.flowable\n         \u2026      }\n                }");
        return flowable;
    }
}

