/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoTagObject;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

@Entity(tableName="message_tag", primaryKeys={"messageId", "tagName"}, foreignKeys={@ForeignKey(entity=EkoMessageEntity.class, parentColumns={"messageId"}, childColumns={"messageId"}, onDelete=5)})
public class EkoMessageTag
extends EkoTagObject {
    @NonNull
    private String messageId;
    @NonNull
    private String tagName;

    @NonNull
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(@NonNull String messageId) {
        this.messageId = EkoPreconditions.checkValidId(messageId, "messageId");
    }

    @NonNull
    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(@NonNull String tagName) {
        this.tagName = EkoPreconditions.checkValidId(tagName, "tagName");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        EkoMessageTag other = (EkoMessageTag)obj;
        return Objects.equal((Object)this.messageId, (Object)other.messageId) && Objects.equal((Object)this.tagName, (Object)other.tagName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.messageId, this.tagName});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("messageId", (Object)this.messageId).add("tagName", (Object)this.tagName).toString();
    }

    public static EkoMessageTag create(@NonNull String messageId, @NonNull String tagName) {
        EkoMessageTag messageTag = new EkoMessageTag();
        messageTag.setMessageId(messageId);
        messageTag.setTagName(tagName);
        return messageTag;
    }
}

