/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.event;

import androidx.annotation.NonNull;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.internal.api.dto.ChannelEvent;
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelDto;
import com.ekoapp.ekosdk.internal.api.event.SocketEventListener;
import com.ekoapp.ekosdk.internal.api.mapper.EkoChannelEventMapper;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.google.gson.Gson;

abstract class ChannelListener
extends SocketEventListener {
    private final Gson gson = EkoGson.get();

    ChannelListener() {
    }

    @Override
    protected final void onEvent(@NonNull String event, Object ... args) {
        super.onEvent(event, args);
        String json = args[0].toString();
        ChannelEvent eventData = (ChannelEvent)this.gson.fromJson(json, ChannelEvent.class);
        this.onChannelEvent(event, eventData);
    }

    void onChannelEvent(@NonNull String eventName, ChannelEvent eventData) {
        if (eventData.getChannelDtoList() != null && !eventData.getChannelDtoList().isEmpty()) {
            EkoChannelDto channelEvent = eventData.getChannelDtoList().get(0);
            UserDatabase.get().channelDao().updateMemberCount(channelEvent.getChannelId(), channelEvent.getMemberCount());
            EkoChannelEventMapper.MAPPER.map(eventData);
        }
    }
}

